/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.IFacesConfigChangeListener;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.IFacesConfigManager;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.WebrootUtil;

public class FacesConfigManager
implements IFacesConfigManager {
    private IProject currentProject;
    ListenerList listenerList = new ListenerList(1);
    private List facesConfigFileList;

    public FacesConfigManager(IProject project) {
        this.currentProject = project;
    }

    public IProject getProject() {
        return this.currentProject;
    }

    public IFile[] getFacesConfigs() {
        if (this.facesConfigFileList == null || this.facesConfigFileList.size() == 0) {
            this.loadConfiguration();
        }
        IFile[] files = new IFile[this.facesConfigFileList.size()];
        this.facesConfigFileList.toArray(files);
        return files;
    }

    public void refresh() {
        if (this.currentProject == null) {
            return;
        }
        this.loadConfiguration();
        this.fireFacesConfigChanged();
    }

    private boolean isDuplicateConfigFile(IFile facesConfigFile) {
        return this.facesConfigFileList != null && this.facesConfigFileList.contains(facesConfigFile);
    }

    private void registerConfigFile(IFile facesConfigFile) {
        if (facesConfigFile != null && !this.isDuplicateConfigFile(facesConfigFile)) {
            this.facesConfigFileList.add(facesConfigFile);
        }
    }

    public void loadConfiguration() {
        String paramValue = null;
        WebArtifactEdit web = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.currentProject);
        if (web != null) {
            WebApp webApp = web.getWebApp();
            EList contextParams = webApp.getContextParams();
            int i = 0;
            int n = contextParams.size();
            while (i < n) {
                ParamValue aParam = (ParamValue)contextParams.get(i);
                if ("javax.faces.CONFIG_FILES".equals(aParam.getName()) || "javax.faces.application.CONFIG_FILES".equals(aParam.getName())) {
                    paramValue = aParam.getValue();
                    break;
                }
                ++i;
            }
            web.dispose();
        }
        this.facesConfigFileList = new ArrayList();
        IFolder webrootFolder = WebrootUtil.getWebContentFolder((IProject)this.currentProject);
        IFile defaultFacesConfigFile = webrootFolder.getFile("WEB-INF/faces-config.xml");
        this.registerConfigFile(defaultFacesConfigFile);
        if (paramValue != null) {
            StringTokenizer tokenizer = new StringTokenizer(paramValue, ",");
            while (tokenizer.hasMoreTokens()) {
                IFile aConifgFile = webrootFolder.getFile(tokenizer.nextToken().trim());
                this.registerConfigFile(aConifgFile);
            }
        }
    }

    protected void fireFacesConfigChanged() {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IFacesConfigChangeListener l = (IFacesConfigChangeListener)listeners[i];
            if (l != null) {
                l.facesConfigChanged();
            }
            ++i;
        }
    }

    public void addFacesConfigChangeListener(IFacesConfigChangeListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeFacesConfigChangeListener(IFacesConfigChangeListener listener) {
        this.listenerList.remove((Object)listener);
    }
}

