/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.FacesConfigEditor;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.ChangeSingleNodeValueCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ClassButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldChangeListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.pages.ComponentsPage;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractSSESection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;

public class ValidatorsGeneralSection
extends AbstractSSESection {
    private IFormPage formPage;
    private static EditorResources resource = EditorResources.getInstance();
    private StringDialogField displayNameField;
    private StringDialogField descriptionField;
    private StringDialogField validatorIDField;
    private ClassButtonDialogField validatorClassField;
    private IProject currentProject;

    public ValidatorsGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, int style, String helpContextId, String helpTooltip) {
        super(parent, managedForm, toolkit, style, helpContextId, helpTooltip);
    }

    public ValidatorsGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, String helpContextId, String helpTooltip) {
        super(parent, managedForm, toolkit, helpContextId, helpTooltip);
    }

    public ValidatorsGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit) {
        super(parent, managedForm, toolkit);
    }

    public ValidatorsGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor) {
        this(parent, managedForm, toolkit, resource.getString("ComponentsPage.ValidatorsSection.General.HelpContextID"), resource.getString("ComponentsPage.ValidatorsSection.General.HelpToolTip"));
        this.formPage = editor;
        this.setText("General");
        this.setDescription("This section describes general information of this validator");
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        int numberOfColumns = 4;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        container.setLayout((Layout)layout);
        GridData td = new GridData(768);
        container.setLayoutData((Object)td);
        IDialogFieldChangeListener dialogFieldChangeListener = new IDialogFieldChangeListener(){

            public void dialogFieldChanged(DialogField field) {
                ((FacesConfigEditor)((ComponentsPage)ValidatorsGeneralSection.this.formPage).getEditor()).setDirty(true);
            }
        };
        toolkit.paintBordersFor(container);
        this.displayNameField = new StringDialogField();
        this.displayNameField.setLabelText("Display Name:");
        this.displayNameField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.displayNameField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.displayNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newNameValue = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand("Set validator display name", ValidatorsGeneralSection.this.getSectionPart(), "display-name", newNameValue);
                changeCmd.execute();
            }
        });
        this.descriptionField = new StringDialogField(2);
        this.descriptionField.setLabelText("Description:");
        this.descriptionField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.descriptionField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.descriptionField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newDescription = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand("Set validator description", ValidatorsGeneralSection.this.getSectionPart(), "description", newDescription);
                changeCmd.execute();
            }
        });
        this.validatorIDField = new StringDialogField();
        this.validatorIDField.setLabelText("Validator ID:");
        this.validatorIDField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.validatorIDField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.validatorIDField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newComponetType = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand("Set validator type", ValidatorsGeneralSection.this.getSectionPart(), "validator-id", newComponetType);
                changeCmd.execute();
            }
        });
        this.validatorClassField = new ClassButtonDialogField(this.getProject());
        this.validatorClassField.setLabelText("Validator Class:");
        this.validatorClassField.doFillIntoGrid(toolkit, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.validatorClassField.getTextControl(toolkit, container));
        this.validatorClassField.getTextControl(toolkit, container).setEditable(true);
        this.validatorClassField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.validatorClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newComponetClass = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand("Set validator class", ValidatorsGeneralSection.this.getSectionPart(), "validator-class", newComponetClass);
                changeCmd.execute();
            }
        });
        this.validatorClassField.setInterface("javax.faces.validator.Validator");
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("ComponentsPage.ValidatorsSection.General.HelpContextID"));
    }

    private IProject getProject() {
        if (this.currentProject == null && this.getInput() instanceof IDOMNode) {
            this.currentProject = StructuredModelUtil.getProjectFor((IDOMNode)this.getInput());
        }
        return this.currentProject;
    }

    public void clearAll() {
        this.displayNameField.setTextWithoutUpdate("");
        this.descriptionField.setTextWithoutUpdate("");
        this.validatorIDField.setTextWithoutUpdate("");
        this.validatorClassField.setTextWithoutUpdate("");
    }

    public void refreshAll() {
        if (this.getInput() instanceof IDOMNode) {
            this.clearAll();
            NodeWrapUtil validatorWrap = new NodeWrapUtil((IDOMNode)this.getInput());
            this.displayNameField.setTextWithoutUpdate(validatorWrap.getChildNodeValue("display-name"));
            this.descriptionField.setTextWithoutUpdate(validatorWrap.getChildNodeValue("description"));
            this.validatorIDField.setTextWithoutUpdate(validatorWrap.getChildNodeValue("validator-id"));
            this.validatorClassField.setTextWithoutUpdate(validatorWrap.getChildNodeValue("validator-class"));
        }
    }

    public IWorkbenchPartSite getSite() {
        return this.formPage.getSite();
    }

    public ClassButtonDialogField getValidatorClassField() {
        return this.validatorClassField;
    }

    public StringDialogField getValidatorDField() {
        return this.validatorIDField;
    }

    public StringDialogField getDescriptionField() {
        return this.descriptionField;
    }

    public StringDialogField getDisplayNameField() {
        return this.displayNameField;
    }

    public void setInput(Object newInput) {
        super.setInput(newInput);
        this.validatorClassField.setProject(this.getProject());
    }
}

