/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.FacesConfigEditor;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.ChangeSingleNodeValueCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ClassButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ComboDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldChangeListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.pages.ManagedBeanPage;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractSSESection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;

public class ManagedBeanGeneralSection
extends AbstractSSESection {
    private static EditorResources resource = EditorResources.getInstance();
    private StringDialogField mbNameField;
    private ClassButtonDialogField mbClassField;
    private ComboDialogField mbScopeField;
    private IProject currentProject;
    private IFormPage editor;
    private Composite container;

    public ManagedBeanGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor) {
        super(parent, managedForm, toolkit, resource.getString("ManagedBeansPage.ManagedBeanGeneralSection.HelpContextID"), resource.getString("ManagedBeansPage.ManagedBeanGeneralSection.HelpToolTip"));
        this.setText(resource.getString("ManagedBeansPage.ManagedBeanGeneralSection.Name"));
        this.setDescription(resource.getString("ManagedBeansPage.ManagedBeanGeneralSection.Description"));
        this.editor = editor;
    }

    public void dispose() {
        super.dispose();
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        this.container = container;
        int numberOfColumns = 4;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        container.setLayout((Layout)layout);
        toolkit.paintBordersFor(this.container);
        this.createMBNameEntry(this.container, toolkit, numberOfColumns);
        this.createMBClassEntry(this.container, toolkit, numberOfColumns);
        this.createMBScopeEntry(this.container, toolkit, numberOfColumns);
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("ManagedBeansPage.ManagedBeanGeneralSection.HelpContextID"));
    }

    public void setEnabled(boolean enabled) {
        if (this.container != null) {
            this.container.setEnabled(enabled);
        }
    }

    private void createMBNameEntry(Composite container, FormToolkit toolkit, int numberOfColumns) {
        this.mbNameField = new StringDialogField();
        this.mbNameField.setLabelText(resource.getString("ManagedBeansPage.ManagedBeanGeneralSection.ManagedBeanName"));
        this.mbNameField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.mbNameField.setDialogFieldChangeListener(new IDialogFieldChangeListener(){

            public void dialogFieldChanged(DialogField field) {
                ((FacesConfigEditor)((ManagedBeanPage)ManagedBeanGeneralSection.this.editor).getEditor()).setDirty(true);
            }
        });
        this.mbNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String mbNameValue = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand(EditorResources.getInstance().getString("ManagedBeanGeneralSection.ChangeManagedBeanName"), ManagedBeanGeneralSection.this.getSectionPart(), "managed-bean-name", mbNameValue);
                changeCmd.execute();
            }
        });
    }

    private void createMBClassEntry(Composite container, FormToolkit toolkit, int numberOfColumns) {
        this.mbClassField = new ClassButtonDialogField(this.getProject());
        this.mbClassField.setLabelText(resource.getString("ManagedBeansPage.ManagedBeanGeneralSection.ManagedBeanClass"));
        this.mbClassField.doFillIntoGrid(toolkit, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.mbClassField.getTextControl(toolkit, container));
        this.mbClassField.setDialogFieldChangeListener(new IDialogFieldChangeListener(){

            public void dialogFieldChanged(DialogField field) {
                ((FacesConfigEditor)((ManagedBeanPage)ManagedBeanGeneralSection.this.editor).getEditor()).setDirty(true);
            }
        });
        this.mbClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand(EditorResources.getInstance().getString("ManagedBeanGeneralSection.ChangeManagedBeanClass"), ManagedBeanGeneralSection.this.getSectionPart(), "managed-bean-class", ((StringDialogField)field).getText());
                changeCmd.execute();
            }
        });
    }

    private void createMBScopeEntry(Composite container, FormToolkit toolkit, int numberOfColumns) {
        this.mbScopeField = new ComboDialogField(12);
        this.mbScopeField.setLabelText(resource.getString("ManagedBeansPage.ManagedBeanGeneralSection.ManagedBeanScope"));
        this.mbScopeField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.mbScopeField.setItems(ManagedBean.scopeItems);
        this.mbScopeField.setDialogFieldChangeListener(new IDialogFieldChangeListener(){

            public void dialogFieldChanged(DialogField field) {
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand(EditorResources.getInstance().getString("ManagedBeanGeneralSection.ChangeManagedBeanScope"), ManagedBeanGeneralSection.this.getSectionPart(), "managed-bean-scope", ((ComboDialogField)field).getText());
                changeCmd.execute();
            }
        });
    }

    public void setInput(Object newInput) {
        super.setInput(newInput);
        this.mbClassField.setProject(this.getProject());
    }

    private IProject getProject() {
        if (this.currentProject == null && this.getInput() instanceof IDOMNode) {
            this.currentProject = StructuredModelUtil.getProjectFor((IDOMNode)this.getInput());
        }
        return this.currentProject;
    }

    public ComboDialogField getScopeField() {
        return this.mbScopeField;
    }

    public StringButtonDialogField getClassField() {
        return this.mbClassField;
    }

    public StringDialogField getNameField() {
        return this.mbNameField;
    }

    public void clearAll() {
        this.mbNameField.setTextWithoutUpdate("");
        this.mbClassField.setTextWithoutUpdate("");
        this.mbScopeField.setTextWithoutUpdate("");
    }

    public IWorkbenchPartSite getSite() {
        return this.editor.getSite();
    }

    public void refreshAll() {
        if (this.getInput() instanceof IDOMNode) {
            this.clearAll();
            ManagedBean bean = new ManagedBean((IDOMNode)this.getInput());
            this.mbNameField.setTextWithoutUpdate(bean.getManagedBeanName());
            this.mbClassField.setTextWithoutUpdate(bean.getManagedBeanClass());
            this.mbScopeField.setTextWithoutUpdate(bean.getManagedBeanScope().toLowerCase());
        }
    }
}

