/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editpolicies;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.actions.OpenEditorAction;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.ConnectionCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.OpenEditorCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.editparts.PageflowNodeEditPart;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.figures.PageflowNodeFigure;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFLink;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PageflowNode;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.impl.PageflowNodeImpl;

public class PageflowNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Connection createDummyConnection(Request req) {
        PolylineConnection conn = new PolylineConnection();
        conn.setLineWidth(this.getLineWidth());
        conn.setForegroundColor(ColorConstants.black);
        return conn;
    }

    private int getLineWidth() {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        int lineWidth = store.getInt("LineWidth");
        return lineWidth;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        ConnectionCommand command = (ConnectionCommand)request.getStartCommand();
        command.setTarget(this.getPageflowNode());
        return command;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        ConnectionCommand command = new ConnectionCommand();
        command.setPFLink((PFLink)request.getNewObject());
        PageflowNode flowObject = this.getPageflowNode();
        command.setSource(flowObject);
        request.setStartCommand((Command)command);
        return command;
    }

    protected PageflowNodeEditPart getPageflowNodeEditPart() {
        return (PageflowNodeEditPart)this.getHost();
    }

    protected PageflowNode getPageflowNode() {
        return (PageflowNode)this.getHost().getModel();
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        ConnectionCommand cmd = new ConnectionCommand();
        cmd.setPFLink((PFLink)request.getConnectionEditPart().getModel());
        cmd.setTarget(this.getPageflowNode());
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        ConnectionCommand cmd = new ConnectionCommand();
        cmd.setPFLink((PFLink)request.getConnectionEditPart().getModel());
        cmd.setSource(this.getPageflowNode());
        return cmd;
    }

    public Command getCommand(Request request) {
        if (OpenEditorAction.OPEN_EDITOR_REQUEST.equals(request.getType())) {
            OpenEditorCommand command = new OpenEditorCommand(this.getHost());
            command.setChild((PageflowNodeImpl)this.getHost().getModel());
            return command;
        }
        return super.getCommand(request);
    }

    protected PageflowNodeFigure getPageflowNodeFigure() {
        return (PageflowNodeFigure)((GraphicalEditPart)this.getHost()).getFigure();
    }
}

