/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldBase;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IStringButtonAdapter;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.SWTUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.IDialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.MapEntriesRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.TypeSelectionDialogUtil;

public class MapEntriesEditGroup
extends DialogFieldGroup
implements IDialogFieldGroup {
    private static EditorResources resource = EditorResources.getInstance();
    private StringButtonDialogField keyClassField;
    private StringButtonDialogField valueClassField;
    private DialogField valuesTitle;
    private FormToolkit toolkit;
    private Composite parent;
    private static final int KEY_COL_WIDTH = 150;
    private static final int VALUE_COL_WIDTH = 150;
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private MapEntriesRecorder mapEntries;
    private IProject currentProject;
    private Table mapTable;
    private Button addButton;
    private Button removeButton;
    private Button editButton;

    public MapEntriesEditGroup(MapEntriesRecorder mapEntries) {
        this.mapEntries = mapEntries;
    }

    public void initialize() {
        this.keyClassField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                TypeSelectionDialogUtil.handleFindType(((StringButtonDialogField)field).getTextControl(MapEntriesEditGroup.this.toolkit, MapEntriesEditGroup.this.parent), MapEntriesEditGroup.this.getProject());
            }
        });
        this.keyClassField.setLabelText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.MapType.KeyClass"));
        this.valueClassField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                TypeSelectionDialogUtil.handleFindType(((StringButtonDialogField)field).getTextControl(MapEntriesEditGroup.this.toolkit, MapEntriesEditGroup.this.parent), MapEntriesEditGroup.this.getProject());
            }
        });
        this.valueClassField.setLabelText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.MapType.ValueClass"));
        this.valuesTitle = new DialogFieldBase();
        this.valuesTitle.setLabelText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.MapTable.Title"));
    }

    public void refreshData() {
        if (this.mapEntries != null) {
            this.clearAll();
            this.keyClassField.setTextWithoutUpdate(this.mapEntries.getKeyClass());
            this.valueClassField.setTextWithoutUpdate(this.mapEntries.getValueClass());
            Iterator iter = this.mapEntries.getMapEntries().iterator();
            while (iter.hasNext()) {
                MapEntriesRecorder.MapEntry mapEntry = (MapEntriesRecorder.MapEntry)iter.next();
                this.addMapItem(mapEntry);
            }
        }
        this.updateButtonsStatus();
    }

    public void updateButtonsStatus() {
        if (this.mapTable.getSelectionCount() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        this.parent = parent;
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        parent.setLayout((Layout)gl);
        this.layoutMapTypeSelectionSection(toolkit, parent);
        this.createAndLayoutMapValueSection(toolkit, parent);
    }

    private void layoutMapTypeSelectionSection(FormToolkit toolkit, Composite container) {
        Composite typeSelectionSection = null;
        if (toolkit != null) {
            typeSelectionSection = toolkit.createComposite(container);
            toolkit.paintBordersFor(typeSelectionSection);
        } else {
            typeSelectionSection = SWTUtils.createComposite((Composite)container, (int)0);
        }
        GridData gd = new GridData(768);
        typeSelectionSection.setLayoutData((Object)gd);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        typeSelectionSection.setLayout((Layout)gl);
        this.keyClassField.doFillIntoGrid(toolkit, typeSelectionSection, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.keyClassField.getTextControl(toolkit, container));
        this.valueClassField.doFillIntoGrid(toolkit, typeSelectionSection, numberOfColumns);
    }

    private void createAndLayoutMapValueSection(FormToolkit toolkit, Composite parent) {
        Composite mapValueSection = null;
        if (toolkit != null) {
            mapValueSection = toolkit.createComposite(parent);
            toolkit.paintBordersFor(mapValueSection);
        } else {
            mapValueSection = SWTUtils.createComposite((Composite)parent, (int)0);
        }
        GridData gd = new GridData(1808);
        mapValueSection.setLayoutData((Object)gd);
        int numberOfColumns = 3;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        mapValueSection.setLayout((Layout)gl);
        this.valuesTitle.doFillIntoGrid(toolkit, mapValueSection, numberOfColumns);
        this.mapTable = toolkit == null ? new Table(mapValueSection, 68352) : new Table(mapValueSection, 66304);
        this.mapTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MapEntriesEditGroup.this.updateButtonsStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MapEntriesEditGroup.this.updateButtonsStatus();
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        this.mapTable.setLayoutData((Object)gd);
        this.mapTable.setHeaderVisible(true);
        this.mapTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        this.mapTable.setLayout((Layout)layout);
        TableColumn keyCol = new TableColumn(this.mapTable, 0);
        keyCol.setText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.MapTable.Key"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        keyCol.setResizable(true);
        TableColumn valueCol = new TableColumn(this.mapTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        valueCol.setText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.MapTable.Value"));
        valueCol.setResizable(true);
        Composite operationContainer = null;
        operationContainer = toolkit != null ? toolkit.createComposite(mapValueSection) : SWTUtils.createComposite((Composite)mapValueSection, (int)0);
        gd = new GridData(1040);
        operationContainer.setLayoutData((Object)gd);
        gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        this.addButton = null;
        this.addButton = toolkit != null ? toolkit.createButton(operationContainer, resource.getString("ManagedBeansPage.ManagedBeansSection.Button.Add.Name"), 8) : SWTUtils.createPushButton((Composite)operationContainer, (String)resource.getString("ManagedBeansPage.ManagedBeansSection.Button.Add.Name"));
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.addButton.setLayoutData((Object)gd);
        this.editButton = null;
        this.editButton = toolkit != null ? toolkit.createButton(operationContainer, resource.getString("MapEntriesEditGroup.Edit"), 8) : SWTUtils.createPushButton((Composite)operationContainer, (String)EditorResources.getInstance().getString("MapEntriesEditGroup.Edit"));
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.removeButton = null;
        this.removeButton = toolkit != null ? toolkit.createButton(operationContainer, resource.getString("ManagedBeansPage.ManagedBeansSection.Button.Remove.Name"), 8) : SWTUtils.createPushButton((Composite)operationContainer, (String)resource.getString("ManagedBeansPage.ManagedBeansSection.Button.Remove.Name"));
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
    }

    private IProject getProject() {
        if (this.currentProject == null && this.mapEntries.getBean() != null) {
            this.currentProject = StructuredModelUtil.getProjectFor(this.mapEntries.getBean().getNode());
        }
        return this.currentProject;
    }

    public void setProject(IProject project) {
        this.currentProject = project;
    }

    void addMapItem(MapEntriesRecorder.MapEntry mapEntry) {
        TableItem item = new TableItem(this.mapTable, 0);
        item.setText(0, mapEntry._key);
        if (mapEntry._valueType.equalsIgnoreCase("null-value")) {
            item.setText(1, "[null-value]");
        } else {
            item.setText(1, mapEntry._value);
        }
        item.setData((Object)mapEntry);
    }

    public void addMapEntry(IDOMNode node) {
        if (node != null && this.findMapEntry(node) == -1) {
            this.addMapItem(this.mapEntries.addMapEntry(node));
            this.mapTable.select(this.mapTable.getItemCount() - 1);
        }
    }

    public void removeMapEntry(IDOMNode node) {
        int itemIndex;
        if (node != null && (itemIndex = this.findMapEntry(node)) >= 0) {
            this.mapTable.remove(itemIndex);
            this.mapTable.select(itemIndex - 1);
            this.updateButtonsStatus();
        }
    }

    public void updateMapEntry(IDOMNode node) {
        int itemIndex;
        if (node != null && (itemIndex = this.findMapEntry(node)) >= 0) {
            TableItem item = this.mapTable.getItem(itemIndex);
            MapEntriesRecorder.MapEntry mapEntry = (MapEntriesRecorder.MapEntry)item.getData();
            this.mapEntries.updateMapEntry(mapEntry, node);
            item.setText(0, mapEntry._key);
            if (mapEntry._valueType.equalsIgnoreCase("null-value")) {
                item.setText(1, "[null-value]");
            } else {
                item.setText(1, mapEntry._value);
            }
            item.setData((Object)mapEntry);
        }
    }

    public int findMapEntry(IDOMNode node) {
        int itemIndex = -1;
        if (node != null) {
            TableItem[] items = this.mapTable.getItems();
            int i = 0;
            int n = this.mapTable.getItemCount();
            while (i < n) {
                if (((MapEntriesRecorder.MapEntry)items[i].getData())._node == node) {
                    itemIndex = i;
                    break;
                }
                ++i;
            }
        }
        return itemIndex;
    }

    public void updateTableItem(TableItem item, MapEntriesRecorder.MapEntry mapEntry) {
        item.setText(0, mapEntry._key);
        if (mapEntry._valueType.equalsIgnoreCase("null-value")) {
            item.setText(1, "[null-value]");
        } else {
            item.setText(1, mapEntry._value);
        }
        item.setData((Object)mapEntry);
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    public void setInput(Object newInput) {
        if (newInput instanceof MapEntriesRecorder) {
            this.mapEntries = (MapEntriesRecorder)newInput;
            this.refreshData();
        }
    }

    public Object getInput() {
        return this.mapEntries;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Table getMapTable() {
        return this.mapTable;
    }

    public StringDialogField getKeyClassField() {
        return this.keyClassField;
    }

    public StringDialogField getValueClassField() {
        return this.valueClassField;
    }

    public void clearAll() {
        this.keyClassField.setTextWithoutUpdate("");
        this.valueClassField.setTextWithoutUpdate("");
        this.getMapTable().removeAll();
        this.updateButtonsStatus();
    }
}

