/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.BaseSectionPartCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.Alerts;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ISSESection;
import org.w3c.dom.Node;

public class RemoveXMLNodeCommand
extends BaseSectionPartCommand {
    private ISelection selection;

    public RemoveXMLNodeCommand(String label, ISSESectionPart sectionPart) {
        super(label, sectionPart);
    }

    public RemoveXMLNodeCommand(String label, IStructuredModel model) {
        super(label, model);
    }

    protected boolean prePreExecute() {
        Alerts alerts;
        ISelection selection = this.getSelection();
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        String warningMsg = "";
        if (selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                Object node = iter.next();
                if (!(node instanceof IDOMNode)) continue;
                this.setLabel("Remove " + ((IDOMNode)node).getLocalName());
                warningMsg = this.getSectionPart().getLabel((IDOMNode)node);
            }
        }
        if (!(alerts = new Alerts((AbstractUIPlugin)EditorPlugin.getDefault(), EditorResources.getInstance().getResourceBundle())).question("Remove.Title", "Remove.Msg", (Object)warningMsg)) {
            return false;
        }
        return super.prePreExecute();
    }

    protected void doExecute() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                Object node = iter.next();
                if (!(node instanceof IDOMNode)) continue;
                NodeWrapUtil.removeNode((Node)node);
            }
        }
    }

    protected ISelection getSelection() {
        if (this.selection == null) {
            ISSESection section = this.getSectionPart().getSection();
            this.selection = section instanceof ISelectionProvider ? ((ISelectionProvider)section).getSelection() : this.getSectionPart().getSection().getSite().getSelectionProvider().getSelection();
        }
        return this.selection;
    }
}

