/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.IPreExecuteCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogs.CommonResourceDialog;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFAction;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFPage;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.Pageflow;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PageflowNode;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.PageflowValidation;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.WebrootUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.ActionSelectionWizard;

public class CreateNodeCommand
extends Command
implements IPreExecuteCommand {
    private static final String UNNAMED_NODE = "unnamed";
    private PageflowNode child;
    private Rectangle rect;
    private Pageflow parent;

    public CreateNodeCommand() {
        super(EditorResources.getInstance().getString("Pageflow.Commands.CreateNodeCommand.Label"));
    }

    public boolean canExecute() {
        return this.child != null && this.parent != null;
    }

    public void execute() {
        if (this.rect != null) {
            this.child.setX(this.rect.x);
            this.child.setY(this.rect.y);
            if (!this.rect.isEmpty()) {
                this.child.setHeight(this.rect.getSize().height);
                this.child.setWidth(this.rect.getSize().width);
            }
        }
        if (this.child.getName() == UNNAMED_NODE) {
            this.child.setName(this.parent.getDefaultNodeName(this.child.getClass()));
        }
        this.parent.getNodes().add((Object)this.child);
    }

    public void redo() {
        if (this.rect != null) {
            this.child.setX(this.rect.x);
            this.child.setY(this.rect.y);
            if (!this.rect.isEmpty()) {
                this.child.setHeight(this.rect.getSize().height);
                this.child.setWidth(this.rect.getSize().width);
            }
        }
        this.parent.getNodes().add((Object)this.child);
    }

    public void undo() {
        this.parent.getNodes().remove((Object)this.child);
    }

    private boolean createNewAction() {
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        ActionSelectionWizard actionSelectionWizard = new ActionSelectionWizard(4, 2);
        actionSelectionWizard.init(EditorPlugin.getDefault().getWorkbench(), (IStructuredSelection)selectionToPass);
        WizardDialog actionSelectionWizardDialog = new WizardDialog(EditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)actionSelectionWizard);
        if (actionSelectionWizardDialog.open() == 0) {
            String actionExpression = actionSelectionWizard.getActionExpression();
            if (actionExpression != null && actionExpression.length() > 0) {
                ((PFAction)this.child).setName(actionExpression);
                ((PFAction)this.child).setAction(actionExpression);
            }
            return true;
        }
        return false;
    }

    private boolean selectJSPPage() {
        IFile jspFile;
        Object[] result;
        Shell shell = null;
        IWorkbenchWindow workbenchWindow = EditorPlugin.getActiveWorkbenchWindow();
        shell = workbenchWindow.getShell() != null ? workbenchWindow.getShell() : new Shell();
        IProject project = WebrootUtil.getProject(this.getParent());
        CommonResourceDialog dialog = new CommonResourceDialog(shell, project, 0);
        dialog.setTitle(EditorResources.getInstance().getString("Pageflow.Commands.CreateNodeCommand.SelectJSPDialog.Title"));
        dialog.setSuffixs(new String[]{"jsp"});
        dialog.setResourceDescription(EditorResources.getInstance().getString("Pageflow.Commands.CreateNodeCommand.SelectJSPDialog.Description"));
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && (jspFile = (IFile)result[0]) != null) {
            String jsfSelection = WebrootUtil.getWebPath((IPath)jspFile.getFullPath());
            if (jsfSelection != null && jsfSelection.length() > 0) {
                if (PageflowValidation.getInstance().isExistedPage(this.parent, jsfSelection)) {
                    EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.DNDResourceTitle", "Pageflow.PageflowEditor.Alert.ExistingPage", (Object)jsfSelection);
                    return false;
                }
                ((PFPage)this.child).setPath(jsfSelection);
                ((PFPage)this.child).setName(WebrootUtil.getPageNameFromWebPath((String)jsfSelection));
            }
            return true;
        }
        return false;
    }

    public Pageflow getParent() {
        return this.parent;
    }

    public void setChild(PageflowNode subpart) {
        this.child = subpart;
    }

    public void setLocation(Rectangle r) {
        this.rect = r;
    }

    public void setParent(Pageflow newParent) {
        this.parent = newParent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean preExecute() {
        if (this.child instanceof PFPage) {
            if (((PFPage)this.child).getPath() == null) return this.selectJSPPage();
            if (!PageflowValidation.getInstance().isExistedPage(this.parent, (PFPage)this.child)) return true;
            EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.DNDResourceTitle", "Pageflow.PageflowEditor.Alert.ExistingPage", (Object)((PFPage)this.child).getPath());
            return false;
        }
        if (!(this.child instanceof PFAction)) return true;
        if (((PFAction)this.child).getAction() == null) return this.createNewAction();
        if (!PageflowValidation.getInstance().isExistedAction(this.parent, (PFAction)this.child)) return true;
        EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.DNDResourceTitle", "Pageflow.PageflowEditor.Alert.ExistingAction", (Object)((PFAction)this.child).getAction());
        return false;
    }
}

