/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.BaseSectionPartCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Validator;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;

public class AddValidatorCommand
extends BaseSectionPartCommand {
    private Object model;
    private static final String DEFAULT_NAME = "New Validator";

    public AddValidatorCommand(String label, ISSESectionPart sectionPart) {
        super(label, sectionPart);
        this.model = sectionPart.getModel();
    }

    public AddValidatorCommand(String label, IStructuredModel model) {
        super(label, model);
        this.model = model;
    }

    protected void doExecute() {
        if (!(this.model instanceof IStructuredModel)) {
            return;
        }
        IDOMDocument document = ((IDOMModel)this.model).getDocument();
        NodeWrapUtil documentWrapUtil = new NodeWrapUtil((IDOMNode)document);
        NodeWrapUtil facesConfigWrap = new NodeWrapUtil((IDOMNode)documentWrapUtil.getChildNode("faces-config"));
        if (facesConfigWrap != null) {
            IDOMNode newValidator = facesConfigWrap.createChildNode("validator", false, null, FacesConfigOrderHelper.getInstance());
            NodeWrapUtil newValidatorUtil = new NodeWrapUtil(newValidator);
            newValidatorUtil.createChildNode("display-name", false, this.getDefaultName(facesConfigWrap.getNode()), FacesConfigOrderHelper.getInstance());
            newValidatorUtil.createChildNode("validator-id", true, "", FacesConfigOrderHelper.getInstance());
            newValidatorUtil.createChildNode("validator-class", true, "", FacesConfigOrderHelper.getInstance());
        }
    }

    private String getDefaultName(IDOMNode parentNode) {
        FacesConfig facesConfig = new FacesConfig(parentNode);
        List childrenList = facesConfig.getValidatorList();
        String result = "";
        if (!childrenList.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            int n = childrenList.size();
            while (i < n) {
                String displayName = ((Validator)childrenList.get(i)).getDisplayName();
                list.add(displayName);
                ++i;
            }
            i = 1;
            while (true) {
                if (list.indexOf(DEFAULT_NAME + i) == -1) {
                    result = DEFAULT_NAME + i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

