/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.BaseSectionPartCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.AddLocaleWizard;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.LocaleConfigSection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;
import org.w3c.dom.Document;

public class AddLocaleCommand
extends BaseSectionPartCommand {
    private Object model;

    public AddLocaleCommand(String label, ISSESectionPart sectionPart) {
        super(label, sectionPart);
        this.model = sectionPart.getModel();
    }

    public AddLocaleCommand(String label, IStructuredModel model) {
        super(label, model);
        this.model = model;
    }

    protected void doExecute() {
        AddLocaleWizard wizard = new AddLocaleWizard(this.getCurrentLocales());
        wizard.init(EditorPlugin.getActiveWorkbenchWindow().getWorkbench(), (IStructuredSelection)((StructuredSelection)((LocaleConfigSection)this.getSectionPart().getSection()).getSelection()));
        wizard.setForcePreviousAndNextButtons(false);
        Shell shell = null;
        IWorkbenchWindow workbenchWindow = EditorPlugin.getActiveWorkbenchWindow();
        shell = workbenchWindow.getShell() != null ? workbenchWindow.getShell() : new Shell();
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0) {
            String localeString = wizard.getText();
            this.createSupportedLocalNode(localeString);
        }
    }

    private List getCurrentLocales() {
        NodeWrapUtil applicationWrap;
        IDOMNode localeConfigNode;
        IDOMNode facesConfigNode;
        NodeWrapUtil facesConfigWrap;
        IDOMNode applicationNode;
        IDOMDocument document;
        FacesConfigDocumentWrap documentWrap;
        FacesConfig facesConfig;
        ArrayList<String> list = new ArrayList<String>();
        if (this.model instanceof IStructuredModel && (facesConfig = (documentWrap = new FacesConfigDocumentWrap((Document)(document = ((IDOMModel)this.model).getDocument()))).getFacesConfig()) != null && (applicationNode = (IDOMNode)(facesConfigWrap = new NodeWrapUtil(facesConfigNode = facesConfig.getNode())).getChildNode("application")) != null && (localeConfigNode = (IDOMNode)(applicationWrap = new NodeWrapUtil(applicationNode)).getChildNode("locale-config")) != null) {
            List supportedLocales;
            NodeWrapUtil localeConfigWrap = new NodeWrapUtil(localeConfigNode);
            IDOMNode defaultLocaleNode = (IDOMNode)localeConfigWrap.getChildNode("default-locale");
            if (defaultLocaleNode != null) {
                list.add(defaultLocaleNode.getFirstChild().getNodeValue());
            }
            if ((supportedLocales = localeConfigWrap.getChildNodes("supported-locale")) != null) {
                int i = 0;
                int n = supportedLocales.size();
                while (i < n) {
                    IDOMNode aNode = (IDOMNode)supportedLocales.get(i);
                    list.add(aNode.getFirstChild().getNodeValue());
                    ++i;
                }
            }
        }
        return list;
    }

    private IDOMNode getLocaleConfigNode() {
        IDOMDocument document;
        FacesConfigDocumentWrap documentWrap;
        FacesConfig facesConfig;
        IDOMNode localeConfigNode = null;
        if (this.model instanceof IStructuredModel && (facesConfig = (documentWrap = new FacesConfigDocumentWrap((Document)(document = ((IDOMModel)this.model).getDocument()))).getFacesConfig()) != null) {
            NodeWrapUtil applicationWrap;
            IDOMNode facesConfigNode = facesConfig.getNode();
            NodeWrapUtil facesConfigWrap = new NodeWrapUtil(facesConfigNode);
            IDOMNode applicationNode = (IDOMNode)facesConfigWrap.getChildNode("application");
            if (applicationNode == null) {
                applicationNode = facesConfigWrap.createChildNode("application", false, null, FacesConfigOrderHelper.getInstance());
            }
            if ((localeConfigNode = (IDOMNode)(applicationWrap = new NodeWrapUtil(applicationNode)).getChildNode("locale-config")) == null) {
                localeConfigNode = applicationWrap.createChildNode("locale-config", false, null, FacesConfigOrderHelper.getInstance());
            }
        }
        return localeConfigNode;
    }

    private void createSupportedLocalNode(String supportedLocalNodeValue) {
        IDOMNode localeConfigNode = this.getLocaleConfigNode();
        NodeWrapUtil localeConfigWrap = new NodeWrapUtil(localeConfigNode);
        localeConfigWrap.createChildNode("supported-locale", false, supportedLocalNodeValue, FacesConfigOrderHelper.getInstance());
    }
}

