/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.ui.internal.classpath;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wtp.jsf.core.internal.JSFCorePlugin;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.wtp.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.wtp.jsf.ui.internal.Messages;
import org.eclipse.wtp.jsf.ui.internal.classpath.JSFLibraryWizard;

public class JSFLibraryContainerWizardPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private TableViewer lv;
    private JSFLibrariesTableViewerAdapter lvAdapter;
    private JSFLibrariesListLabelProvider lvLabelProvider;
    private ArrayList elements;
    private boolean isJSFProject = false;

    public JSFLibraryContainerWizardPage() {
        super(Messages.JSFLibraryContainerWizardPage_PageName);
        this.setTitle(Messages.JSFLibraryContainerWizardPage_Title);
        this.setDescription(Messages.JSFLibraryContainerWizardPage_Description);
        this.setImageDescriptor(JSFUiPlugin.getImageDescriptor("full/wizban/addlibrary_wiz.gif"));
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.isJSFProject = false;
        try {
            if (project.getProject().hasNature("org.eclipse.wst.common.project.facet.core.nature")) {
                IFacetedProject fproj = ProjectFacetsManager.create((IProject)project.getProject());
                Iterator it = fproj.getProjectFacets().iterator();
                while (it.hasNext()) {
                    IProjectFacetVersion facetVersion = (IProjectFacetVersion)it.next();
                    IProjectFacet facet = facetVersion.getProjectFacet();
                    if (!facet.getId().equals("wtp.jsf")) continue;
                    this.isJSFProject = true;
                    return;
                }
            }
        }
        catch (CoreException e) {
            JSFUiPlugin.log(4, Messages.JSFLibraryContainerWizardPage_ErrorInitializing, e);
        }
    }

    public boolean finish() {
        return true;
    }

    public boolean isPageComplete() {
        if (!this.isJSFProject) {
            return false;
        }
        return this.isValid();
    }

    private boolean isValid() {
        return false;
    }

    public IClasspathEntry getSelection() {
        this.lv.getSelection();
        return null;
    }

    public void setSelection(IClasspathEntry containerEntry) {
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(1808));
        if (!this.isJSFProject) {
            Label warning = new Label(c, 0);
            warning.setText(Messages.JSFLibraryContainerWizardPage_WarningNoJSFFacet);
            this.setControl((Control)c);
            return;
        }
        Label lblViewer = new Label(c, 0);
        lblViewer.setText(Messages.JSFLibraryContainerWizardPage_JSFLibraries);
        GridData gd1 = new GridData(1);
        gd1.horizontalSpan = 2;
        lblViewer.setLayoutData((Object)gd1);
        this.lv = this.createTableViewer(c);
        this.lv.getControl().setLayoutData((Object)new GridData(1808));
        this.lvAdapter = new JSFLibrariesTableViewerAdapter();
        this.lvLabelProvider = new JSFLibrariesListLabelProvider();
        this.lv.setContentProvider((IContentProvider)this.lvAdapter);
        this.lv.setLabelProvider((IBaseLabelProvider)this.lvLabelProvider);
        this.lv.addSelectionChangedListener((ISelectionChangedListener)this.lvAdapter);
        this.lv.addDoubleClickListener((IDoubleClickListener)this.lvAdapter);
        this.lv.setInput(this.getJSFLibraries());
        Button addButton = new Button(c, 0);
        addButton.setText(Messages.JSFLibraryContainerWizardPage_Add);
        addButton.setLayoutData((Object)new GridData(3));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryContainerWizardPage.this.openJSFLibraryWizard(null);
            }
        });
        this.setControl((Control)c);
    }

    private void openJSFLibraryWizard(Object element) {
        JSFLibraryWizard wizard = new JSFLibraryWizard();
        IWorkbench wb = PlatformUI.getWorkbench();
        wizard.init(wb, this.getStructuredElement(element));
        WizardDialog dialog = new WizardDialog(wb.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int ret = dialog.open();
        if (ret == 0) {
            this.lv.refresh();
        }
    }

    private IStructuredSelection getStructuredElement(Object element) {
        if (element != null) {
            boolean cfr_ignored_0 = element instanceof IStructuredSelection;
        }
        return null;
    }

    private TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 2850);
        table.setFont(parent.getFont());
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                JSFLibraryContainerWizardPage.this.validate();
            }
        });
        return tableViewer;
    }

    private Object getJSFLibraries() {
        this.elements = new ArrayList(10);
        this.elements.addAll(JSFCorePlugin.getDefault().getJSFLibraryRegistry().getAllJSFLibraries());
        return this.elements;
    }

    private void validate() {
    }

    private void doListSelected(SelectionChangedEvent event) {
    }

    private void doDoubleClick(DoubleClickEvent event) {
        this.openJSFLibraryWizard(this.lv.getSelection());
    }

    private class JSFLibrariesTableViewerAdapter
    implements IStructuredContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private JSFLibrariesTableViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return JSFLibraryContainerWizardPage.this.elements.toArray();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            JSFLibraryContainerWizardPage.this.doListSelected(event);
        }

        public void doubleClick(DoubleClickEvent event) {
            JSFLibraryContainerWizardPage.this.doDoubleClick(event);
        }
    }

    private class JSFLibrariesListLabelProvider
    implements ILabelProvider {
        Image libImg;

        private JSFLibrariesListLabelProvider() {
        }

        public Image getImage(Object element) {
            if (this.libImg == null) {
                ImageDescriptor libImgDesc = JSFUiPlugin.getImageDescriptor("obj16/library_obj.gif");
                this.libImg = libImgDesc.createImage();
            }
            return this.libImg;
        }

        public String getText(Object element) {
            if (element instanceof JSFLibrary) {
                JSFLibrary lib = (JSFLibrary)element;
                if (lib.isImplementation()) {
                    return String.valueOf(lib.getName()) + " [implementation]";
                }
                return lib.getName();
            }
            return null;
        }

        public void dispose() {
            if (this.libImg != null) {
                this.libImg.dispose();
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

