/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.utils;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.BooleanPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.BooleanPropertyAttributeType;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteralPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteralPropertyAttributeType;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Fault;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModelFactory;
import org.eclipse.vorto.core.api.model.model.ModelFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;

public class Utils {
    public static String getReturnType(ReturnType type) {
        if (type instanceof ReturnPrimitiveType) {
            PrimitiveType _returnType = ((ReturnPrimitiveType)type).getReturnType();
            return _returnType.getName();
        }
        if (type instanceof ReturnObjectType) {
            Type _returnType_1 = ((ReturnObjectType)type).getReturnType();
            return _returnType_1.getName();
        }
        return null;
    }

    public static String getPropertyType(Property property) {
        PropertyType _type = property.getType();
        if (_type instanceof PrimitivePropertyType) {
            PropertyType _type_1 = property.getType();
            PrimitiveType _type_2 = ((PrimitivePropertyType)_type_1).getType();
            return _type_2.getName();
        }
        PropertyType _type_3 = property.getType();
        if (_type_3 instanceof ObjectPropertyType) {
            PropertyType _type_4 = property.getType();
            Type _type_5 = ((ObjectPropertyType)_type_4).getType();
            return _type_5.getName();
        }
        return null;
    }

    public static InformationModel wrapFunctionBlock(FunctionblockModel fbModel) {
        InformationModel infomodel = InformationModelFactory.eINSTANCE.createInformationModel();
        String _category = fbModel.getCategory();
        infomodel.setCategory(_category);
        String _description = fbModel.getDescription();
        infomodel.setDescription(_description);
        String _displayname = fbModel.getDisplayname();
        infomodel.setDisplayname(_displayname);
        String _name = fbModel.getName();
        infomodel.setName(_name);
        String _namespace = fbModel.getNamespace();
        infomodel.setNamespace(_namespace);
        String _version = fbModel.getVersion();
        infomodel.setVersion(_version);
        FunctionblockProperty property = InformationModelFactory.eINSTANCE.createFunctionblockProperty();
        property.setType(fbModel);
        String _name_1 = fbModel.getName();
        String _lowerCase = _name_1.toLowerCase();
        property.setName(_lowerCase);
        EList _properties = infomodel.getProperties();
        _properties.add((Object)property);
        ModelReference reference = ModelFactory.eINSTANCE.createModelReference();
        String _namespace_1 = fbModel.getNamespace();
        String _plus = String.valueOf(_namespace_1) + ".";
        String _name_2 = fbModel.getName();
        String _plus_1 = String.valueOf(_plus) + _name_2;
        reference.setImportedNamespace(_plus_1);
        String _version_1 = fbModel.getVersion();
        reference.setVersion(_version_1);
        EList _references = infomodel.getReferences();
        _references.add((Object)reference);
        return infomodel;
    }

    public static boolean isSimpleNumeric(Property property) {
        PropertyType _type = property.getType();
        if (_type instanceof PrimitivePropertyType) {
            PropertyType _type_1 = property.getType();
            PrimitiveType primitiveType = ((PrimitivePropertyType)_type_1).getType();
            boolean _equals = Objects.equal((Object)primitiveType, (Object)PrimitiveType.INT);
            if (_equals) {
                return true;
            }
            boolean _equals_1 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.FLOAT);
            if (_equals_1) {
                return true;
            }
            boolean _equals_2 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.DOUBLE);
            if (_equals_2) {
                return true;
            }
            boolean _equals_3 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.LONG);
            if (_equals_3) {
                return true;
            }
            boolean _equals_4 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.SHORT);
            if (_equals_4) {
                return true;
            }
        }
        return false;
    }

    public static String getMinConstraint(Property property) {
        boolean _notEquals;
        boolean _and = false;
        ConstraintRule _constraintRule = property.getConstraintRule();
        EList _constraints = null;
        if (_constraintRule != null) {
            _constraints = _constraintRule.getConstraints();
        }
        boolean bl = _notEquals = !Objects.equal((Object)_constraints, null);
        if (!_notEquals) {
            _and = false;
        } else {
            int _size;
            boolean _greaterThan;
            ConstraintRule _constraintRule_1 = property.getConstraintRule();
            EList _constraints_1 = null;
            if (_constraintRule_1 != null) {
                _constraints_1 = _constraintRule_1.getConstraints();
            }
            _and = _greaterThan = (_size = _constraints_1.size()) > 0;
        }
        if (_and) {
            ConstraintRule _constraintRule_2 = property.getConstraintRule();
            EList _constraints_2 = null;
            if (_constraintRule_2 != null) {
                _constraints_2 = _constraintRule_2.getConstraints();
            }
            for (Constraint constraint : _constraints_2) {
                ConstraintIntervalType _type = constraint.getType();
                boolean _equals = Objects.equal((Object)_type, (Object)ConstraintIntervalType.MIN);
                if (!_equals) continue;
                return constraint.getConstraintValues();
            }
        }
        return "";
    }

    public static String getMaxConstraint(Property property) {
        boolean _notEquals;
        boolean _and = false;
        ConstraintRule _constraintRule = property.getConstraintRule();
        EList _constraints = null;
        if (_constraintRule != null) {
            _constraints = _constraintRule.getConstraints();
        }
        boolean bl = _notEquals = !Objects.equal((Object)_constraints, null);
        if (!_notEquals) {
            _and = false;
        } else {
            int _size;
            boolean _greaterThan;
            ConstraintRule _constraintRule_1 = property.getConstraintRule();
            EList _constraints_1 = null;
            if (_constraintRule_1 != null) {
                _constraints_1 = _constraintRule_1.getConstraints();
            }
            _and = _greaterThan = (_size = _constraints_1.size()) > 0;
        }
        if (_and) {
            ConstraintRule _constraintRule_2 = property.getConstraintRule();
            EList _constraints_2 = null;
            if (_constraintRule_2 != null) {
                _constraints_2 = _constraintRule_2.getConstraints();
            }
            for (Constraint constraint : _constraints_2) {
                ConstraintIntervalType _type = constraint.getType();
                boolean _equals = Objects.equal((Object)_type, (Object)ConstraintIntervalType.MAX);
                if (!_equals) continue;
                return constraint.getConstraintValues();
            }
        }
        return "";
    }

    public static String getMeasurementUnit(Property property) {
        boolean _notEquals;
        EnumLiteral literal = Utils.getEnumLiteralPropertyAttribute(property, EnumLiteralPropertyAttributeType.MEASUREMENT_UNIT);
        boolean bl = _notEquals = !Objects.equal((Object)literal, null);
        if (_notEquals) {
            return literal.getName();
        }
        return "";
    }

    public static boolean isReadable(Property property) {
        return Utils.getBooleanPropertyAttribute(property, BooleanPropertyAttributeType.READABLE);
    }

    public static boolean isWritable(Property property) {
        return Utils.getBooleanPropertyAttribute(property, BooleanPropertyAttributeType.WRITABLE);
    }

    public static boolean isEventable(Property property) {
        return Utils.getBooleanPropertyAttribute(property, BooleanPropertyAttributeType.EVENTABLE);
    }

    public static boolean getBooleanPropertyAttribute(Property property, BooleanPropertyAttributeType type) {
        EList _propertyAttributes_1;
        int _size;
        boolean _greaterThan;
        boolean _notEquals;
        boolean _and = false;
        EList _propertyAttributes = property.getPropertyAttributes();
        boolean bl = _notEquals = !Objects.equal((Object)_propertyAttributes, null);
        _and = !_notEquals ? false : (_greaterThan = (_size = (_propertyAttributes_1 = property.getPropertyAttributes()).size()) > 0);
        if (_and) {
            EList _propertyAttributes_2 = property.getPropertyAttributes();
            for (PropertyAttribute pA : _propertyAttributes_2) {
                boolean _isValue;
                if (!(pA instanceof BooleanPropertyAttribute)) continue;
                BooleanPropertyAttribute bPA = (BooleanPropertyAttribute)pA;
                boolean _and_1 = false;
                BooleanPropertyAttributeType _type = bPA.getType();
                boolean _equals = Objects.equal((Object)_type, (Object)type);
                _and_1 = !_equals ? false : (_isValue = bPA.isValue());
                if (!_and_1) continue;
                return true;
            }
        }
        return false;
    }

    public static EnumLiteral getEnumLiteralPropertyAttribute(Property property, EnumLiteralPropertyAttributeType type) {
        EList _propertyAttributes_1;
        int _size;
        boolean _greaterThan;
        boolean _notEquals;
        boolean _and = false;
        EList _propertyAttributes = property.getPropertyAttributes();
        boolean bl = _notEquals = !Objects.equal((Object)_propertyAttributes, null);
        _and = !_notEquals ? false : (_greaterThan = (_size = (_propertyAttributes_1 = property.getPropertyAttributes()).size()) > 0);
        if (_and) {
            EList _propertyAttributes_2 = property.getPropertyAttributes();
            for (PropertyAttribute pA : _propertyAttributes_2) {
                EnumLiteralPropertyAttribute bPA;
                EnumLiteralPropertyAttributeType _type;
                boolean _equals;
                if (!(pA instanceof EnumLiteralPropertyAttribute) || !(_equals = Objects.equal((Object)(_type = (bPA = (EnumLiteralPropertyAttribute)pA).getType()), (Object)type))) continue;
                return bPA.getValue();
            }
        }
        return null;
    }

    public static EList<Entity> getReferencedEntities(FunctionBlock fb) {
        BasicEList entities = new BasicEList();
        EList<Type> _referencedTypes = Utils.getReferencedTypes(fb);
        for (Type type : _referencedTypes) {
            boolean _contains;
            boolean _not;
            boolean _and = false;
            _and = !(type instanceof Entity) ? false : (_not = !(_contains = entities.contains((Object)((Entity)type))));
            if (!_and) continue;
            entities.add((Object)((Entity)type));
        }
        return entities;
    }

    public static EList<Enum> getReferencedEnums(FunctionBlock fb) {
        BasicEList enums = new BasicEList();
        EList<Type> _referencedTypes = Utils.getReferencedTypes(fb);
        for (Type type : _referencedTypes) {
            boolean _contains;
            boolean _not;
            boolean _and = false;
            _and = !(type instanceof Enum) ? false : (_not = !(_contains = enums.contains((Object)((Enum)type))));
            if (!_and) continue;
            enums.add((Object)((Enum)type));
        }
        return enums;
    }

    public static EList<Type> getReferencedTypes(Type type) {
        BasicEList types = new BasicEList();
        types.add((Object)type);
        if (type instanceof Entity) {
            Entity entityType = (Entity)type;
            EList _properties = entityType.getProperties();
            for (Property property : _properties) {
                EList<Type> _referencedTypes = Utils.getReferencedTypes(property);
                types.addAll(_referencedTypes);
            }
            Entity _superType = entityType.getSuperType();
            types.add((Object)_superType);
        }
        return types;
    }

    public static EList<Type> getReferencedTypes(Property property) {
        BasicEList types = new BasicEList();
        PropertyType _type = property.getType();
        if (_type instanceof ObjectPropertyType) {
            PropertyType _type_1 = property.getType();
            ObjectPropertyType objectType = (ObjectPropertyType)_type_1;
            Type _type_2 = objectType.getType();
            types.add((Object)_type_2);
            Type _type_3 = objectType.getType();
            if (_type_3 instanceof Entity) {
                Type _type_4 = objectType.getType();
                EList<Type> _referencedTypes = Utils.getReferencedTypes((Type)((Entity)_type_4));
                types.addAll(_referencedTypes);
            }
        }
        return types;
    }

    public static EList<Type> getReferencedTypes(FunctionBlock fb) {
        boolean _notEquals;
        BasicEList types = new BasicEList();
        boolean bl = _notEquals = !Objects.equal((Object)fb, null);
        if (_notEquals) {
            Fault _fault;
            boolean _notEquals_3;
            Configuration _configuration;
            boolean _notEquals_2;
            boolean _notEquals_1;
            Status _status = fb.getStatus();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_status, null);
            if (_notEquals_1) {
                Status _status_1 = fb.getStatus();
                EList _properties = _status_1.getProperties();
                for (Property property : _properties) {
                    EList<Type> _referencedTypes = Utils.getReferencedTypes(property);
                    types.addAll(_referencedTypes);
                }
            }
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)(_configuration = fb.getConfiguration()), null);
            if (_notEquals_2) {
                Configuration _configuration_1 = fb.getConfiguration();
                EList _properties_1 = _configuration_1.getProperties();
                for (Property property_1 : _properties_1) {
                    EList<Type> _referencedTypes_1 = Utils.getReferencedTypes(property_1);
                    types.addAll(_referencedTypes_1);
                }
            }
            boolean bl4 = _notEquals_3 = !Objects.equal((Object)(_fault = fb.getFault()), null);
            if (_notEquals_3) {
                Fault _fault_1 = fb.getFault();
                EList _properties_2 = _fault_1.getProperties();
                for (Property property_2 : _properties_2) {
                    EList<Type> _referencedTypes_2 = Utils.getReferencedTypes(property_2);
                    types.addAll(_referencedTypes_2);
                }
            }
            EList _operations = fb.getOperations();
            for (Operation op : _operations) {
                ReturnType _returnType = op.getReturnType();
                if (_returnType instanceof ReturnObjectType) {
                    ReturnType _returnType_1 = op.getReturnType();
                    Type _returnType_2 = ((ReturnObjectType)_returnType_1).getReturnType();
                    EList<Type> _referencedTypes_3 = Utils.getReferencedTypes(_returnType_2);
                    types.addAll(_referencedTypes_3);
                }
                EList _params = op.getParams();
                for (Param param : _params) {
                    if (!(param instanceof RefParam)) continue;
                    Type _type = ((RefParam)param).getType();
                    EList<Type> _referencedTypes_4 = Utils.getReferencedTypes(_type);
                    types.addAll(_referencedTypes_4);
                }
            }
        }
        return types;
    }
}

