/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.webui.tasks.templates;

import java.util.List;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.examples.webui.tasks.ModuleUtil;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ApplicationMainTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        return "Application.java";
    }

    public String getPath(InformationModel context) {
        return "webdevice.example/src/main/java/webdevice/example";
    }

    public String getContent(InformationModel context, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package webdevice.example;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.springframework.beans.factory.annotation.Autowired;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.boot.SpringApplication;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.boot.autoconfigure.SpringBootApplication;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.boot.builder.SpringApplicationBuilder;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.boot.context.web.SpringBootServletInitializer;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Bean;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Import;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.messaging.simp.SimpMessagingTemplate;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.scheduling.annotation.EnableScheduling;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.scheduling.annotation.Scheduled;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.stereotype.Service;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"import model.functionblocks.*;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@SpringBootApplication");
        _builder.newLine();
        _builder.append((Object)"@EnableScheduling");
        _builder.newLine();
        _builder.append((Object)"public class Application extends SpringBootServletInitializer {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Autowired");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private SimpMessagingTemplate template;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static void main(String[] args) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SpringApplication.run(Application.class, args);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return application.sources(Application.class);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* Uncomment if you have generated MQTT client code with the Vorto MQTT Code Generator");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Bean");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public IClientHandler myClientHandler() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new IClientHandler() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"public void onDeviceStatusReceived(Object statusEvent) {");
        _builder.newLine();
        List<FunctionblockModel> _functionBlocksUsingStatus = ModuleUtil.getFunctionBlocksUsingStatus(context);
        for (FunctionblockModel fbm : _functionBlocksUsingStatus) {
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"if (statusEvent instanceof ");
            String _name = fbm.getName();
            _builder.append((Object)_name, "\t\t\t\t");
            _builder.append((Object)"Status) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"template.convertAndSend(\"/topic/");
            String _name_1 = fbm.getName();
            _builder.append((Object)_name_1, "\t\t\t\t\t");
            _builder.append((Object)"Status\", statusEvent);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Service");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static class ScheduleTask {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"@Autowired");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"private SimpMessagingTemplate template;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// this sends deviceInfo status to websocket subscribers");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"@Scheduled(fixedRate = 5000)");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public void sendDeviceStatusEvents() {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// sends the message to /topic/message");
        _builder.newLine();
        List<FunctionblockModel> _functionBlocksUsingStatus_1 = ModuleUtil.getFunctionBlocksUsingStatus(context);
        for (FunctionblockModel fbm_1 : _functionBlocksUsingStatus_1) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"this.template.convertAndSend(\"/topic/");
            String _name_2 = fbm_1.getName();
            _builder.append((Object)_name_2, "\t\t\t");
            _builder.append((Object)"Status\", new ");
            String _name_3 = fbm_1.getName();
            _builder.append((Object)_name_3, "\t\t\t");
            _builder.append((Object)"Status()); //TODO: create instances with data");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

