/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.latex.tasks.template;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.examples.latex.tasks.template.LatexComplexPropertyTemplate;
import org.eclipse.vorto.codegen.examples.latex.tasks.template.LatexSimplePropertyConstraintTemplate;
import org.eclipse.vorto.codegen.examples.latex.tasks.template.LatexSimplePropertyTemplate;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.xtend2.lib.StringConcatenation;

public class LatexEntityTemplate
implements ITemplate<Entity> {
    private LatexSimplePropertyConstraintTemplate constraintTemplate;
    private LatexSimplePropertyTemplate simpleTemplate;
    private LatexComplexPropertyTemplate complexTemplate;

    public LatexEntityTemplate(LatexSimplePropertyConstraintTemplate constraintTemplate, LatexSimplePropertyTemplate simpleTemplate, LatexComplexPropertyTemplate complexTemplate) {
        this.constraintTemplate = constraintTemplate;
        this.simpleTemplate = simpleTemplate;
        this.complexTemplate = complexTemplate;
    }

    public String getContent(Entity entity, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\\subsection{");
        String _displayname = entity.getDisplayname();
        _builder.append((Object)_displayname, "");
        _builder.append((Object)"}");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _description = entity.getDescription();
        _builder.append((Object)_description, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"The properties of the data type ");
        String _displayname_1 = entity.getDisplayname();
        _builder.append((Object)_displayname_1, "\t");
        _builder.append((Object)"\\footnote{Name: ");
        String _name = entity.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)", Namespace: ");
        String _namespace = entity.getNamespace();
        _builder.append((Object)_namespace, "\t");
        _builder.append((Object)", Version: ");
        String _version = entity.getVersion();
        _builder.append((Object)_version, "\t");
        _builder.append((Object)".} are described below:\\\\\\\\");
        _builder.newLineIfNotEmpty();
        EList _properties = entity.getProperties();
        for (Property property : _properties) {
            boolean _isSimpleNumeric = Utils.isSimpleNumeric((Property)property);
            if (_isSimpleNumeric) {
                _builder.append((Object)"\t");
                String _content = this.constraintTemplate.getContent(property, invocationContext);
                _builder.append((Object)_content, "\t");
                _builder.newLineIfNotEmpty();
                continue;
            }
            PropertyType _type = property.getType();
            if (_type instanceof PrimitivePropertyType) {
                _builder.append((Object)"\t");
                String _content_1 = this.simpleTemplate.getContent(property, invocationContext);
                _builder.append((Object)_content_1, "\t");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t");
            String _content_2 = this.complexTemplate.getContent(property, invocationContext);
            _builder.append((Object)_content_2, "\t");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }
}

