/**
 * Copyright (c) 2014 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 * 
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 */
package org.eclipse.vorto.editor.infomodel.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.vorto.editor.infomodel.InformationModelRuntimeModule;
import org.eclipse.vorto.editor.infomodel.InformationModelStandaloneSetup;
import org.eclipse.vorto.editor.infomodel.ide.InformationModelIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class InformationModelIdeSetup extends InformationModelStandaloneSetup {
  @Override
  public Injector createInjector() {
    InformationModelRuntimeModule _informationModelRuntimeModule = new InformationModelRuntimeModule();
    InformationModelIdeModule _informationModelIdeModule = new InformationModelIdeModule();
    return Guice.createInjector(Modules2.mixin(_informationModelRuntimeModule, _informationModelIdeModule));
  }
}
