/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.cacheing;

import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.repository.Query;
import org.eclipse.virgo.repository.configuration.RemoteRepositoryConfiguration;
import org.eclipse.virgo.repository.internal.cacheing.CacheingQuery;
import org.eclipse.virgo.repository.internal.cacheing.cache.RepositoryCache;
import org.eclipse.virgo.repository.internal.cacheing.cache.RepositoryCacheFactory;
import org.eclipse.virgo.repository.internal.remote.RemoteRepository;

public final class CacheingRemoteRepository
extends RemoteRepository {
    private final Object monitor = new Object();
    private final RepositoryCacheFactory repositoryCacheFactory;
    private RepositoryCache cache;

    public CacheingRemoteRepository(RemoteRepositoryConfiguration configuration, EventLogger eventLogger, RepositoryCacheFactory repositoryCacheFactory) {
        super(configuration, eventLogger);
        this.repositoryCacheFactory = repositoryCacheFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start() {
        super.start();
        Object object = this.monitor;
        synchronized (object) {
            this.cache = this.repositoryCacheFactory.createRepositoryCache(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            this.cache = null;
        }
        super.stop();
    }

    @Override
    public Query createQuery(String key, String value) {
        Query uncachedQuery = super.createQuery(key, value);
        return this.createQuery(uncachedQuery);
    }

    @Override
    public Query createQuery(String key, String value, Map<String, Set<String>> properties) {
        Query uncachedQuery = super.createQuery(key, value, properties);
        return this.createQuery(uncachedQuery);
    }

    private Query createQuery(Query uncachedQuery) {
        RepositoryCache repositoryCache = this.getRepositoryCache();
        return repositoryCache == null ? uncachedQuery : CacheingRemoteRepository.createCacheingQuery(repositoryCache, uncachedQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryCache getRepositoryCache() {
        Object object = this.monitor;
        synchronized (object) {
            return this.cache;
        }
    }

    private static Query createCacheingQuery(RepositoryCache activeCache, Query uncachedQuery) {
        return new CacheingQuery(uncachedQuery, activeCache);
    }
}

