/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.io.UnsupportedEncodingException;

public class URI {
    public static String decode(String input, String charset) {
        if (input == null) {
            return null;
        }
        return URI.decode(input, 0, input.length(), charset);
    }

    public static String decode(String input, int begin, int end, String charset) {
        if (input == null) {
            return null;
        }
        int index = input.indexOf(37, begin);
        if (index == -1 || index >= end) {
            return input.substring(begin, end).replace('+', ' ');
        }
        int size = end - begin;
        StringBuffer result = new StringBuffer(size);
        byte[] bytes = new byte[size];
        int length = 0;
        int i = begin;
        while (i < end) {
            char c = input.charAt(i);
            if (c == '%') {
                int digit;
                if (i + 2 >= end) {
                    throw new IllegalArgumentException();
                }
                if ((digit = Character.digit(input.charAt(++i), 16)) == -1) {
                    throw new IllegalArgumentException();
                }
                int value = digit << 4;
                if ((digit = Character.digit(input.charAt(++i), 16)) == -1) {
                    throw new IllegalArgumentException();
                }
                bytes[length] = (byte)(value |= digit);
                ++length;
            } else {
                if (length > 0) {
                    result.append(URI.convert(bytes, 0, length, charset));
                    length = 0;
                }
                if (c == '+') {
                    c = ' ';
                }
                result.append(c);
            }
            ++i;
        }
        if (length > 0) {
            result.append(URI.convert(bytes, 0, length, charset));
            length = 0;
        }
        return result.toString();
    }

    public static String convert(byte[] input, int offset, int length, String charset) {
        if (charset != null) {
            try {
                return new String(input, offset, length, charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        try {
            return new String(input, offset, length, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(input, offset, length);
        }
    }
}

