/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.net.URI;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import org.apache.openejb.config.Deployment;
import org.apache.openejb.config.DeploymentFactory;
import org.apache.openejb.config.DeploymentImpl;
import org.apache.openejb.config.OpenEJBDeploymentManager;
import org.apache.openejb.util.URLs;

public class OpenEJBDeploymentFactory
implements javax.enterprise.deploy.spi.factories.DeploymentFactory {
    public static final String URI_SCHEME = "openejb";
    private static DeploymentFactory factory = new DeploymentImpl.DeploymentFactoryImpl();

    public static DeploymentFactory getFactory() {
        return factory;
    }

    public static void setFactory(DeploymentFactory factory) {
        OpenEJBDeploymentFactory.factory = factory;
    }

    public String getDisplayName() {
        return "OpenEJB";
    }

    public String getProductVersion() {
        return "3.0";
    }

    public boolean handlesURI(String uri) {
        URI fullUri = URLs.uri(uri);
        return URI_SCHEME.equals(fullUri.getScheme());
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Invalid URI: " + uri);
        }
        return new OpenEJBDeploymentManager();
    }

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        URI protocolUri = this.getProtocolUri(uri);
        if (protocolUri == null) {
            throw new DeploymentManagerCreationException("Invalid URI: " + uri);
        }
        try {
            Deployment deployment = factory.createDeployment(protocolUri, username, password);
            return new OpenEJBDeploymentManager(deployment);
        }
        catch (RuntimeException e) {
            DeploymentManagerCreationException creationException = new DeploymentManagerCreationException("Unexpected exception while creating deployment manager");
            creationException.initCause((Throwable)e);
            throw creationException;
        }
        catch (AssertionError e) {
            DeploymentManagerCreationException creationException = new DeploymentManagerCreationException("Assertion error while creating deployment manager");
            creationException.initCause((Throwable)((Object)e));
            throw creationException;
        }
    }

    private URI getProtocolUri(String uri) {
        URI fullUri = URLs.uri(uri);
        if (!URI_SCHEME.equals(fullUri.getScheme())) {
            return null;
        }
        return URLs.uri(fullUri.getSchemeSpecificPart());
    }
}

