/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.ui.templates.NewPluginProjectFromTemplateWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.pde.core.internal.cmd.SetupProjectOperation;
import org.eclipse.virgo.ide.ui.wizards.Messages;
import org.eclipse.virgo.ide.ui.wizards.NewPDEProjectWABPage;

public class NewPDEProjectWizard
extends NewPluginProjectFromTemplateWizard {
    public NewPDEProjectWizard() {
        this.setWindowTitle(Messages.NewPDEProjectWizard_title);
    }

    protected String getTemplateID() {
        return "org.eclipse.virgo.ide.ui.pdetemplate";
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            WizardNewProjectCreationPage newProjectCreationPage = (WizardNewProjectCreationPage)this.getPage("main");
            IProject project = newProjectCreationPage.getProjectHandle();
            IBundleProjectService service = (IBundleProjectService)PlatformUI.getWorkbench().getService(IBundleProjectService.class);
            String contextRoot = this.getContextRoot();
            final SetupProjectOperation operation = new SetupProjectOperation(project, contextRoot, service);
            try {
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, monitor);
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle(e.getStatus(), 3);
                        }
                    }
                });
            }
            catch (Exception e) {
                Status s = new Status(4, "org.eclipse.virgo.ide.ui", e.getMessage(), (Throwable)e);
                StatusManager.getManager().handle((IStatus)s, 3);
            }
        }
        return true;
    }

    private String getContextRoot() {
        NewPDEProjectWABPage wabPage = (NewPDEProjectWABPage)this.getPage(NewPDEProjectWABPage.class.getSimpleName());
        String contextRoot = wabPage.getContextRoot();
        return contextRoot;
    }
}

