/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.virgo.ide.eclipse.editors.DependenciesSection;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.par.Bundle;
import org.eclipse.virgo.ide.par.Par;
import org.eclipse.virgo.ide.ui.editors.ParUtils;
import org.eclipse.virgo.ide.ui.editors.ParXmlEditorPage;
import org.eclipse.virgo.ide.ui.editors.ProjectSelectionDialog;

public class ParDependenciesSection
extends DependenciesSection {
    private final ParXmlEditorPage page;
    private Par par;

    public ParDependenciesSection(ParXmlEditorPage page, Composite parent, String[] buttonLabels) {
        super((FormPage)page, parent, buttonLabels);
        this.page = page;
        this.initialize();
        this.getSection().setText("Nested Bundles");
        this.getSection().setDescription("Add or remove bundle dependencies to the PAR.");
    }

    protected void enableButtons() {
        if (this.getTableViewer() != null) {
            Object[] selected = ((IStructuredSelection)this.getTableViewer().getSelection()).toArray();
            int size = selected.length;
            EditableTablePart tablePart = this.getTablePart();
            tablePart.setButtonEnabled(this.getRemoveIndex(), size > 0);
        }
    }

    protected void entryModified(Object entry, String value) {
    }

    protected void handleAdd() {
        ArrayList<IProject> facetProjects = new ArrayList<IProject>(Arrays.asList(FacetUtils.getBundleProjects()));
        Iterator it = facetProjects.iterator();
        block0: while (it.hasNext()) {
            IProject workspaceProject = (IProject)it.next();
            for (Bundle bundle : this.par.getBundle()) {
                if (bundle.getSymbolicName() == null || !bundle.getSymbolicName().equals(ParUtils.getSymbolicName(workspaceProject))) continue;
                it.remove();
                continue block0;
            }
        }
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getSection().getShell());
        dialog.setElements(facetProjects.toArray(new IProject[0]));
        if (dialog.open() == 0) {
            IProject[] workspaceProjects;
            IProject[] iProjectArray = workspaceProjects = dialog.getSelectedProjects();
            int n = workspaceProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject workspaceProject = iProjectArray[n2];
                Collection newChildDescriptors = this.page.getModel().getNewChildDescriptors((Object)this.par, null);
                Object descriptor = newChildDescriptors.iterator().next();
                Command command = CreateChildCommand.create((EditingDomain)this.page.getModel(), (Object)this.par, descriptor, Collections.singleton(this.par));
                this.page.getModel().getCommandStack().execute(command);
                if (command.getResult() != null && !command.getResult().isEmpty()) {
                    Bundle project = (Bundle)command.getResult().iterator().next();
                    project.setSymbolicName(ParUtils.getSymbolicName(workspaceProject));
                }
                ++n2;
            }
        }
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
    }

    protected void handleDown() {
    }

    protected void handleOpenProperties() {
    }

    protected void handleRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        if (!selection.isEmpty()) {
            Command command = RemoveCommand.create((EditingDomain)this.page.getModel(), (Object)this.par, null, (Collection)selection.toList());
            this.page.getModel().getCommandStack().execute(command);
        }
    }

    protected void handleUp() {
    }

    protected void initialize() {
        this.getTableViewer().setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.page.getModel().getAdapterFactory()));
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.page.getModel().getAdapterFactory()));
        this.par = this.page.getPar();
        this.getTableViewer().setInput((Object)this.par);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.enableButtons();
    }
}

