/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.export;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.virgo.ide.export.AbstractProjectExportWizardPage;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCorePlugin;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class BundleExportWizardPage
extends AbstractProjectExportWizardPage {
    public BundleExportWizardPage(IStructuredSelection selection) {
        super("bundleExportWizardPage", selection);
        this.setTitle("JAR File Specification");
        this.setDescription("Define which bundle project should be exported into the JAR.");
    }

    protected ViewerFilter getTreeViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    return !root.isArchive() && !root.isExternal();
                }
                if (element instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)element;
                    try {
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)javaProject.getProject());
                        if (facetedProject != null) {
                            return facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"org.eclipse.virgo.server.bundle").getDefaultVersion());
                        }
                    }
                    catch (CoreException coreException) {}
                    return false;
                }
                return true;
            }
        };
    }

    protected ITreeContentProvider getTreeContentProvider() {
        return new StandardJavaElementContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof IJavaProject) {
                    return NO_CHILDREN;
                }
                return super.getChildren(element);
            }
        };
    }

    protected Object getInput() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    protected String getExtension() {
        return ".jar";
    }

    protected String getDestinationLabel() {
        return "JAR file:";
    }

    protected String getSymbolicName(BundleManifest bundleManifest) {
        if (bundleManifest.getBundleSymbolicName() != null) {
            return bundleManifest.getBundleSymbolicName().getSymbolicName();
        }
        return null;
    }

    protected String getVersion(BundleManifest bundleManifest) {
        return bundleManifest.getBundleVersion() != null ? bundleManifest.getBundleVersion().toString() : "";
    }

    protected BundleManifest getBundleManifest(IProject project) {
        if (project != null) {
            return BundleManifestCorePlugin.getBundleManifestManager().getBundleManifest(JavaCore.create((IProject)project));
        }
        return null;
    }
}

