/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase.AbstractIteratingExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;

public class IterateOverEDatatypeInstances
implements IIteratingSearchOperation {
    private final EDataType dataType;
    private final int position;
    private final EMFScope scope;

    public IterateOverEDatatypeInstances(int position, EDataType dataType, EMFScope scope) {
        this.position = position;
        this.dataType = dataType;
        this.scope = scope;
    }

    protected Stream<EAttribute> doGetEAttributes(EClass eclass, ISearchContext context) {
        Map cache = context.accessBackendLevelCache(this.getClass(), Map.class, CollectionsFactory::createMap);
        Tuple compositeKey = Tuples.staticArityFlatTupleOf((Object)this.dataType, (Object)eclass);
        return cache.computeIfAbsent(compositeKey, k -> eclass.getEAllAttributes().stream().filter(input -> Objects.equals(input.getEType(), this.dataType)).collect(Collectors.toSet())).stream();
    }

    public EDataType getDataType() {
        return this.dataType;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.position, this.scope);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    " + this.dataType.getName() + "(-" + variableMapping.apply(this.position) + ") iterating";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Collections.singletonList(this.position);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return new EDataTypeInSlotsKey(this.dataType);
    }

    private class Executor
    extends AbstractIteratingExtendOperationExecutor<Object> {
        public Executor(int position, EMFScope scope) {
            super(position, scope);
        }

        @Override
        public Iterator<? extends Object> getIterator(MatchingFrame frame, ISearchContext context) {
            return this.getModelContents().filter(EObject.class::isInstance).map(EObject.class::cast).map(input -> IterateOverEDatatypeInstances.this.doGetEAttributes(input.eClass(), context).map(attribute -> {
                if (attribute.isMany()) {
                    return ((List)input.eGet((EStructuralFeature)attribute)).stream();
                }
                Object o = input.eGet((EStructuralFeature)attribute);
                return o == null ? Stream.empty() : Stream.of(o);
            })).flatMap(i -> i).flatMap(i -> i).iterator();
        }

        @Override
        public ISearchOperation getOperation() {
            return IterateOverEDatatypeInstances.this;
        }
    }
}

