/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.sirius.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.viatra.query.patternlanguage.emf.sirius.util.FileSystemHelper;
import org.eclipse.viatra.query.patternlanguage.metamodel.code.generator.VqlCodeGenerator;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.PatternPackage;

public class GraphicalQueryProjectBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.viatra.query.patternlanguage.emf.sirius.vgqlbuilder";
    private static final String OUTPUT_FOLDER_NAME = "vgql-gen";
    private static final String SOURCE_FOLDER_NAME = "src";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        ResourceSetImpl set = new ResourceSetImpl();
        switch (kind) {
            case 15: {
                this.clean(monitor);
                break;
            }
            case 6: {
                this.getProject().getFolder(SOURCE_FOLDER_NAME).accept(arg_0 -> this.lambda$0((ResourceSet)set, arg_0));
                break;
            }
            default: {
                IPath sourceFolderPath = this.getProject().getFolder(SOURCE_FOLDER_NAME).getFullPath();
                this.getDelta(this.getProject()).accept(arg_0 -> this.lambda$1(sourceFolderPath, monitor, (ResourceSet)set, arg_0));
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().getFolder(OUTPUT_FOLDER_NAME).accept(resource -> {
            if (Objects.equals("vql", resource.getFileExtension())) {
                resource.delete(true, monitor);
            }
            return true;
        });
    }

    private void buildFile(ResourceSet set, IFile sourceFile) throws CoreException {
        IPath sourcePath = sourceFile.getFullPath();
        Resource resource = set.getResource(URI.createPlatformResourceURI((String)sourcePath.toString(), (boolean)true), true);
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof PatternPackage)) continue;
            PatternPackage pkg = (PatternPackage)next;
            IFile outputFile = this.getProject().getFile(this.getOutputPath(sourcePath));
            VqlCodeGenerator generator = new VqlCodeGenerator();
            ByteArrayInputStream contentStream = new ByteArrayInputStream(generator.generate(pkg).getBytes(StandardCharsets.UTF_8));
            if (outputFile.exists()) {
                outputFile.setContents((InputStream)contentStream, 2, (IProgressMonitor)new NullProgressMonitor());
            } else {
                FileSystemHelper.ensureParentsExists((IFolder)outputFile.getParent());
                outputFile.create((InputStream)contentStream, true, (IProgressMonitor)new NullProgressMonitor());
            }
            outputFile.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            it.prune();
        }
    }

    private IPath getOutputPath(IPath sourcePath) {
        IPath sourceFolderRelativePath = sourcePath.makeRelativeTo(this.getProject().getFolder(SOURCE_FOLDER_NAME).getFullPath());
        IPath outputFileName = sourceFolderRelativePath.removeFileExtension().addFileExtension("vql");
        IPath outputPath = this.getProject().getFolder(OUTPUT_FOLDER_NAME).getFullPath().append(outputFileName);
        return outputPath.makeRelativeTo(this.getProject().getFullPath());
    }

    private /* synthetic */ boolean lambda$0(ResourceSet resourceSet, IResource resource) throws CoreException {
        if (resource instanceof IFile && Objects.equals("vgql", resource.getFileExtension())) {
            this.buildFile(resourceSet, (IFile)resource);
        }
        return true;
    }

    private /* synthetic */ boolean lambda$1(IPath iPath, IProgressMonitor iProgressMonitor, ResourceSet resourceSet, IResourceDelta delta) throws CoreException {
        if (iPath.isPrefixOf(delta.getFullPath()) && delta.getResource() instanceof IFile && Objects.equals("vgql", delta.getResource().getFileExtension())) {
            switch (delta.getKind()) {
                case 2: 
                case 16: {
                    IResource outputFile = this.getProject().findMember(this.getOutputPath(delta.getFullPath()));
                    outputFile.delete(true, iProgressMonitor);
                    break;
                }
                default: {
                    this.buildFile(resourceSet, (IFile)delta.getResource());
                }
            }
        }
        return true;
    }
}

