/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.launch;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.debug.ui.activator.TransformationDebugUIActivator;

public class TransformationRemoteDebugTab
extends AbstractLaunchConfigurationTab {
    private static final String NOAGENTS = "No VIATRA Transformation Agents running on port ";
    private ComboViewer comboViewer;
    private Text transformationTypeText;
    private String projectName;
    private String typeName;
    private String selectedID;
    private Text portText;
    private String portID = "";

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group grpPort = new Group(composite, 0);
        grpPort.setText("Target Port");
        grpPort.setLayout((Layout)new GridLayout(2, false));
        grpPort.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.portText = new Text((Composite)grpPort, 2048);
        this.portText.setText(this.portID);
        this.portText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        final ControlDecoration portNumberDecorator = new ControlDecoration((Control)this.portText, 131200);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Image img = fieldDecoration.getImage();
        portNumberDecorator.setImage(img);
        portNumberDecorator.hide();
        this.portText.addModifyListener(e -> {
            try {
                Integer.parseInt(this.portText.getText());
                this.portID = this.portText.getText();
                portNumberDecorator.hide();
                this.setErrorMessage(null);
                this.getLaunchConfigurationDialog().updateMessage();
                this.getLaunchConfigurationDialog().updateButtons();
            }
            catch (NumberFormatException e2) {
                portNumberDecorator.setDescriptionText(String.valueOf(this.portText.getText()) + " is not a valid port number.");
                portNumberDecorator.show();
                this.setErrorMessage(String.valueOf(this.portText.getText()) + " is not a valid port number.");
                this.getLaunchConfigurationDialog().updateMessage();
                ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e2.getMessage(), (Throwable)e2);
            }
        });
        Button btnPortQuery = new Button((Composite)grpPort, 0);
        btnPortQuery.setText("Query Port");
        Group grpTargetTransformation = new Group(composite, 0);
        grpTargetTransformation.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        grpTargetTransformation.setText("Target VIATRA Transformation");
        grpTargetTransformation.setLayout((Layout)new GridLayout(1, false));
        this.comboViewer = new ComboViewer((Composite)grpTargetTransformation, 8);
        Combo combo = this.comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.comboViewer.addSelectionChangedListener(event -> {
            this.selectedID = (String)((StructuredSelection)this.comboViewer.getSelection()).getFirstElement();
            if (!this.selectedID.contains("0.15.0")) {
                this.setErrorMessage(String.valueOf(this.selectedID) + " does not match the current version VIATRA version");
                this.getLaunchConfigurationDialog().updateMessage();
            } else {
                this.setErrorMessage(null);
                this.getLaunchConfigurationDialog().updateMessage();
            }
            this.getLaunchConfigurationDialog().updateButtons();
        });
        Group transformationTypeGrp = new Group(composite, 0);
        transformationTypeGrp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        transformationTypeGrp.setLayout((Layout)new GridLayout(2, false));
        transformationTypeGrp.setText("VIATRA Transformation Class");
        this.transformationTypeText = new Text((Composite)transformationTypeGrp, 2056);
        this.transformationTypeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.transformationTypeText.addModifyListener(e -> {
            this.typeName = this.transformationTypeText.getText();
            this.getLaunchConfigurationDialog().updateButtons();
        });
        Button btnSearchButton = new Button((Composite)transformationTypeGrp, 0);
        btnSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSearchButtonSelected();
            }

            private void handleSearchButtonSelected() {
                try {
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (IRunnableContext)JDIDebugUIPlugin.getActiveWorkbenchWindow(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
                    dialog.setTitle("Select Transformation Class");
                    dialog.create();
                    if (dialog.open() == 1) {
                        return;
                    }
                    Object[] results = dialog.getResult();
                    IType type = (IType)results[0];
                    if (type != null) {
                        TransformationRemoteDebugTab.this.transformationTypeText.setText(type.getFullyQualifiedName());
                        TransformationRemoteDebugTab.this.typeName = type.getFullyQualifiedName();
                        TransformationRemoteDebugTab.this.projectName = type.getJavaProject().getElementName();
                        TransformationRemoteDebugTab.this.getLaunchConfigurationDialog().updateButtons();
                    }
                }
                catch (JavaModelException e) {
                    TransformationDebugUIActivator.getDefault().logException("An error occured during the creation of the VIATRA debugger wizard tab", e);
                }
            }
        });
        btnSearchButton.setText("Search");
        btnPortQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList filteredNames = Lists.newArrayList();
                try {
                    Integer.parseInt(TransformationRemoteDebugTab.this.portText.getText());
                    TransformationRemoteDebugTab.this.portID = TransformationRemoteDebugTab.this.portText.getText();
                    JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + TransformationRemoteDebugTab.this.portID + "/jmxrmi");
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (JMXConnector jmxc = JMXConnectorFactory.connect(url, null);){
                        MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
                        ArrayList queryNames = Lists.newArrayList(mbsc.queryNames(null, null));
                        for (ObjectName objectName : queryNames) {
                            if (!objectName.toString().contains("org.eclipse.viatra.transformation.debug.communication.impl:type=DebuggerTargetEndpoint")) continue;
                            filteredNames.add(objectName.toString());
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    if (!filteredNames.isEmpty()) {
                        TransformationRemoteDebugTab.this.comboViewer.setInput((Object)filteredNames);
                        TransformationRemoteDebugTab.this.comboViewer.setSelection((ISelection)new StructuredSelection(filteredNames.get(0)));
                        TransformationRemoteDebugTab.this.selectedID = (String)filteredNames.get(0);
                        portNumberDecorator.hide();
                        TransformationRemoteDebugTab.this.setErrorMessage(null);
                        TransformationRemoteDebugTab.this.getLaunchConfigurationDialog().updateMessage();
                        TransformationRemoteDebugTab.this.getLaunchConfigurationDialog().updateButtons();
                    }
                    TransformationRemoteDebugTab.this.getLaunchConfigurationDialog().updateButtons();
                }
                catch (IOException | NumberFormatException e2) {
                    ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e2.getMessage(), (Throwable)e2);
                    portNumberDecorator.setDescriptionText(TransformationRemoteDebugTab.NOAGENTS + TransformationRemoteDebugTab.this.portText.getText());
                    filteredNames.add(TransformationRemoteDebugTab.NOAGENTS + TransformationRemoteDebugTab.this.portText.getText());
                    TransformationRemoteDebugTab.this.comboViewer.setInput((Object)filteredNames);
                    TransformationRemoteDebugTab.this.comboViewer.setSelection((ISelection)new StructuredSelection(filteredNames.get(0)));
                    TransformationRemoteDebugTab.this.selectedID = (String)filteredNames.get(0);
                    TransformationRemoteDebugTab.this.setErrorMessage(TransformationRemoteDebugTab.NOAGENTS + TransformationRemoteDebugTab.this.portText.getText());
                    TransformationRemoteDebugTab.this.getLaunchConfigurationDialog().updateMessage();
                    portNumberDecorator.show();
                }
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.portID = Integer.toString(1099);
        if (this.portText != null) {
            this.portText.setText(this.portID);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.selectedID = configuration.getAttribute("org.eclipse.viatra.transformation.debug.launch.SelectedTarget", "");
            this.comboViewer.setInput((Object)Lists.newArrayList((Object[])new String[]{this.selectedID}));
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedID));
            this.typeName = configuration.getAttribute("org.eclipse.viatra.transformation.debug.launch.TransformationClass", "");
            this.projectName = configuration.getAttribute("org.eclipse.viatra.transformation.debug.launch.TransformationProject", "");
            this.transformationTypeText.setText(this.typeName);
            this.portID = configuration.getAttribute("org.eclipse.viatra.transformation.debug.launch.DebuggerPort", "1099");
            this.portText.setText(String.valueOf(this.portID));
        }
        catch (CoreException e) {
            ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return !this.selectedID.contains(NOAGENTS) && this.selectedID.contains("0.15.0") && !this.projectName.isEmpty();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.selectedID != null) {
            configuration.setAttribute("org.eclipse.viatra.transformation.debug.launch.SelectedTarget", this.selectedID);
            configuration.setAttribute("org.eclipse.viatra.transformation.debug.launch.TransformationClass", this.typeName);
            configuration.setAttribute("org.eclipse.viatra.transformation.debug.launch.TransformationProject", this.projectName);
            configuration.setAttribute("org.eclipse.viatra.transformation.debug.launch.DebuggerPort", this.portID);
            try {
                configuration.doSave();
            }
            catch (CoreException e) {
                ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getName() {
        return "VIATRA Remote Debug Parameters";
    }

    public Image getImage() {
        return TransformationDebugUIActivator.getDefault().getImageRegistry().get("viatra_debug_logo");
    }
}

