/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.eval.AbstractEvaluatorNode;
import org.eclipse.viatra.query.runtime.rete.eval.EvaluatorCore;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;

public class MemorylessEvaluatorNode
extends AbstractEvaluatorNode {
    public MemorylessEvaluatorNode(ReteContainer reteContainer, EvaluatorCore core) {
        super(reteContainer, core);
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        ArrayList<Tuple> parentTuples = new ArrayList<Tuple>();
        this.propagatePullInto(parentTuples, flush);
        for (Tuple parentTuple : parentTuples) {
            Iterable<Tuple> output = this.core.performEvaluation(parentTuple);
            if (output == null) continue;
            Iterator<Tuple> itr = output.iterator();
            while (itr.hasNext()) {
                collector.add(itr.next());
            }
        }
    }

    @Override
    public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
        Map parentTuples = CollectionsFactory.createMap();
        this.propagatePullIntoWithTimestamp(parentTuples, flush);
        for (Map.Entry entry : parentTuples.entrySet()) {
            Iterable<Tuple> output = this.core.performEvaluation((Tuple)entry.getKey());
            if (output == null) continue;
            Iterator<Tuple> itr = output.iterator();
            while (itr.hasNext()) {
                collector.put(itr.next(), (Timeline<Timestamp>)((Timeline)entry.getValue()));
            }
        }
    }

    @Override
    public void update(Direction direction, Tuple input, Timestamp timestamp) {
        Iterable<Tuple> output = this.core.performEvaluation(input);
        if (output != null) {
            this.propagateIterableUpdate(direction, output, timestamp);
        }
    }
}

