/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import java.util.Collection;
import java.util.StringJoiner;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.LaunchTargetUtils;

public interface ICBuildConfigurationProvider {
    public String getId();

    public ICBuildConfiguration getCBuildConfiguration(IBuildConfiguration var1, String var2) throws CoreException;

    public ICBuildConfiguration createCBuildConfiguration(IProject var1, IToolChain var2, String var3, ILaunchTarget var4, IProgressMonitor var5) throws CoreException;

    default public String getCBuildConfigName(IProject project, String toolName, IToolChain toolchain, String launchMode, ILaunchTarget launchTarget) {
        StringJoiner configName = new StringJoiner(".");
        configName.add(toolName);
        configName.add(launchMode);
        String os = toolchain.getProperty("os");
        if ("linux-container".equals(os)) {
            String osConfigName = toolchain.getProperty("linux-container-id").replaceAll("/", "_");
            configName.add(osConfigName);
        } else {
            String fragment = toolchain.getBuildConfigNameFragment();
            if (fragment != null && !fragment.isEmpty()) {
                configName.add(fragment);
            }
            configName.add(LaunchTargetUtils.sanitizeName((String)launchTarget.getId()));
        }
        return configName.toString();
    }

    default public Collection<IToolChain> getSupportedToolchains(Collection<IToolChain> toolchains) throws CoreException {
        return toolchains;
    }
}

