/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.EditorPluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;

public class EditorActionBuilder
extends PluginActionBuilder {
    private static final String TAG_CONTRIBUTION_TYPE = "editorContribution";

    @Override
    protected ActionDescriptor createActionDescriptor(IConfigurationElement element) {
        return new ActionDescriptor(element, 4);
    }

    @Override
    protected PluginActionBuilder.BasicContribution createContribution() {
        return new EditorContribution();
    }

    public IEditorActionBarContributor readActionExtensions(IEditorDescriptor desc) {
        ExternalContributor ext = null;
        this.readContributions(desc.getId(), TAG_CONTRIBUTION_TYPE, "editorActions");
        if (this.cache != null) {
            ext = new ExternalContributor(this.cache);
            this.cache = null;
        }
        return ext;
    }

    private static class EditorContribution
    extends PluginActionBuilder.BasicContribution {
        private EditorContribution() {
        }

        @Override
        public void dispose() {
            this.disposeActions();
            super.dispose();
        }

        public void editorChanged(IEditorPart editor) {
            if (this.actions != null) {
                for (ActionDescriptor ad : this.actions) {
                    EditorPluginAction action = (EditorPluginAction)ad.getAction();
                    action.editorChanged(editor);
                }
            }
        }
    }

    public static class ExternalContributor
    implements IEditorActionBarContributor {
        private ArrayList<Object> cache;

        public ExternalContributor(ArrayList<Object> cache) {
            this.cache = cache;
        }

        @Override
        public void dispose() {
            for (Object contribution : this.cache) {
                ((EditorContribution)contribution).dispose();
            }
        }

        public ActionDescriptor[] getExtendedActions() {
            ArrayList results = new ArrayList();
            for (Object contribution : this.cache) {
                EditorContribution ec = (EditorContribution)contribution;
                if (ec.actions == null) continue;
                results.addAll(ec.actions);
            }
            return results.toArray(new ActionDescriptor[results.size()]);
        }

        @Override
        public void init(IActionBars bars, IWorkbenchPage page) {
            for (Object contribution : this.cache) {
                ((EditorContribution)contribution).contribute(bars.getMenuManager(), false, bars.getToolBarManager(), true);
            }
        }

        @Override
        public void setActiveEditor(IEditorPart editor) {
            for (Object contribution : this.cache) {
                ((EditorContribution)contribution).editorChanged(editor);
            }
        }
    }
}

