/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.StringFragment;
import org.eclipse.jdt.core.dom.StringTemplateComponent;
import org.eclipse.jdt.internal.core.dom.util.DOMASTUtil;

public class StringTemplateExpression
extends Expression {
    private static final List PROPERTY_DESCRIPTORS;
    public static final ChildPropertyDescriptor TEMPLATE_PROCESSOR;
    public static final ChildPropertyDescriptor FIRST_STRING_FRAGMENT;
    public static final ChildListPropertyDescriptor STRING_TEMPLATE_COMPONENTS;
    public static final SimplePropertyDescriptor MULTI_LINE;
    private volatile Expression processor;
    private volatile StringFragment firstFragment;
    private boolean isMultiline = false;
    private final ASTNode.NodeList components = new ASTNode.NodeList(STRING_TEMPLATE_COMPONENTS);

    static {
        TEMPLATE_PROCESSOR = new ChildPropertyDescriptor(StringTemplateExpression.class, "processor", Expression.class, true, true);
        FIRST_STRING_FRAGMENT = new ChildPropertyDescriptor(StringTemplateExpression.class, "firstFragment", StringFragment.class, true, true);
        STRING_TEMPLATE_COMPONENTS = new ChildListPropertyDescriptor(StringTemplateExpression.class, "components", StringTemplateComponent.class, true);
        MULTI_LINE = new SimplePropertyDescriptor(StringTemplateExpression.class, "multiline", Boolean.TYPE, true);
        ArrayList propertyList = new ArrayList(2);
        StringTemplateExpression.createPropertyList(StringTemplateExpression.class, propertyList);
        StringTemplateExpression.addProperty(TEMPLATE_PROCESSOR, propertyList);
        StringTemplateExpression.addProperty(FIRST_STRING_FRAGMENT, propertyList);
        StringTemplateExpression.addProperty(MULTI_LINE, propertyList);
        StringTemplateExpression.addProperty(STRING_TEMPLATE_COMPONENTS, propertyList);
        PROPERTY_DESCRIPTORS = StringTemplateExpression.reapPropertyList(propertyList);
    }

    StringTemplateExpression(AST ast) {
        super(ast);
        this.supportedOnlyIn22();
    }

    public void setProcessor(Expression processor) {
        this.supportedOnlyIn22();
        if (processor == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.processor;
        this.preReplaceChild(oldChild, processor, TEMPLATE_PROCESSOR);
        this.processor = processor;
        this.postReplaceChild(oldChild, processor, TEMPLATE_PROCESSOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getProcessor() {
        this.supportedOnlyIn22();
        if (this.processor == null) {
            StringTemplateExpression stringTemplateExpression = this;
            synchronized (stringTemplateExpression) {
                if (this.processor == null) {
                    this.preLazyInit();
                    this.processor = this.postLazyInit(new SimpleName(this.ast), TEMPLATE_PROCESSOR);
                }
            }
        }
        return this.processor;
    }

    public void setFirstFragment(StringFragment firstFragment) {
        this.supportedOnlyIn22();
        if (firstFragment == null) {
            throw new IllegalArgumentException();
        }
        StringFragment oldChild = this.firstFragment;
        this.preReplaceChild(oldChild, firstFragment, FIRST_STRING_FRAGMENT);
        this.firstFragment = firstFragment;
        this.postReplaceChild(oldChild, firstFragment, FIRST_STRING_FRAGMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringFragment getFirstFragment() {
        this.supportedOnlyIn22();
        if (this.firstFragment == null) {
            StringTemplateExpression stringTemplateExpression = this;
            synchronized (stringTemplateExpression) {
                if (this.firstFragment == null) {
                    this.preLazyInit();
                    this.firstFragment = this.postLazyInit(new StringFragment(this.ast), FIRST_STRING_FRAGMENT);
                }
            }
        }
        return this.firstFragment;
    }

    public List<StringTemplateComponent> components() {
        this.supportedOnlyIn22();
        return this.components;
    }

    public static List propertyDescriptors(int apiLevel) {
        return null;
    }

    public static List propertyDescriptors(int apiLevel, boolean previewEnabled) {
        if (DOMASTUtil.isStringTemplateSupported(apiLevel, previewEnabled)) {
            return PROPERTY_DESCRIPTORS;
        }
        return null;
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return StringTemplateExpression.propertyDescriptors(apiLevel);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel, boolean previewEnabled) {
        return StringTemplateExpression.propertyDescriptors(apiLevel, previewEnabled);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == MULTI_LINE) {
            if (get) {
                return this.isMultiline();
            }
            this.setIsMultiline(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == TEMPLATE_PROCESSOR) {
            if (get) {
                return this.getProcessor();
            }
            this.setProcessor((Expression)child);
            return null;
        }
        if (property == FIRST_STRING_FRAGMENT) {
            if (get) {
                return this.getFirstFragment();
            }
            this.setFirstFragment((StringFragment)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == STRING_TEMPLATE_COMPONENTS) {
            return this.components();
        }
        return super.internalGetChildListProperty(property);
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public void setIsMultiline(boolean isMultitine) {
        this.preValueChange(MULTI_LINE);
        this.isMultiline = isMultitine;
        this.postValueChange(MULTI_LINE);
    }

    @Override
    int getNodeType0() {
        return 114;
    }

    @Override
    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        StringTemplateExpression result = new StringTemplateExpression(target);
        result.setProcessor((Expression)this.getProcessor().clone(target));
        result.setFirstFragment((StringFragment)this.getFirstFragment().clone(target));
        result.components().addAll(ASTNode.copySubtrees(target, this.components()));
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setIsMultiline(this.isMultiline());
        return result;
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getProcessor());
            this.acceptChild(visitor, this.getFirstFragment());
            this.acceptChildren(visitor, this.components);
        }
        visitor.endVisit(this);
    }

    @Override
    int memSize() {
        return 56;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.processor == null ? 0 : this.getProcessor().treeSize()) + (this.firstFragment == null ? 0 : this.getFirstFragment().treeSize()) + this.components.listSize();
    }
}

