/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Arrays;
import java.util.EventListener;
import java.util.stream.Stream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DPIZoomChangeRegistry;
import org.eclipse.swt.internal.ExceptionStash;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.WidgetSpy;
import org.eclipse.swt.internal.win32.INITCOMMONCONTROLSEX;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TRACKMOUSEEVENT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    private int zoom;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int LAYOUT_NEEDED = 32;
    static final int LAYOUT_CHANGED = 64;
    static final int LAYOUT_CHILD = 128;
    static final int THEME_BACKGROUND = 256;
    static final int DRAW_BACKGROUND = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int TRACK_MOUSE = 8192;
    static final int FOREIGN_HANDLE = 16384;
    static final int DRAG_DETECT = 32768;
    static final int MOVE_OCCURRED = 65536;
    static final int MOVE_DEFERRED = 131072;
    static final int RESIZE_OCCURRED = 262144;
    static final int RESIZE_DEFERRED = 524288;
    static final int IGNORE_WM_CHANGEUISTATE = 0x100000;
    static final int SKIN_NEEDED = 0x200000;
    static final int HAS_AUTO_DIRECTION = 0x400000;
    static final int MOUSE_OVER = 0x800000;
    static final int CUSTOM_DRAW_ITEM = 0x1000000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final char LRE = '\u202a';
    static final char RLE = '\u202b';
    static final int AUTO_TEXT_DIRECTION = 0x6000000;

    static {
        INITCOMMONCONTROLSEX icce = new INITCOMMONCONTROLSEX();
        icce.dwSize = INITCOMMONCONTROLSEX.sizeof;
        icce.dwICC = 65535;
        OS.InitCommonControlsEx(icce);
        DPIZoomChangeRegistry.registerHandler(Widget::handleDPIChange, Widget.class);
    }

    Widget() {
        this.notifyCreationTracker();
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.zoom = parent != null ? parent.getZoom() : DPIUtil.getDeviceZoom();
        this.display = parent.display;
        this.reskinWidget();
        this.notifyCreationTracker();
    }

    void _addListener(int eventType, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void _removeListener(int eventType, Listener listener) {
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(eventType, listener);
    }

    protected void addTypedListener(EventListener listener, int ... eventTypes) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            this._addListener(eventType, typedListener);
            ++n2;
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        this.addTypedListener(listener, 12);
    }

    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        return 0L;
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkOpened() {
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        parent.checkWidget();
        parent.checkOpened();
    }

    void maybeEnableDarkSystemTheme(long handle) {
        if (this.display.useDarkModeExplorerTheme) {
            OS.AllowDarkModeForWindow(handle, true);
            OS.SetWindowTheme(handle, Display.EXPLORER, null);
        }
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    boolean dragDetect(long hwnd, int x, int y, boolean filter, boolean[] detect, boolean[] consume) {
        if (consume != null) {
            consume[0] = false;
        }
        if (detect != null) {
            detect[0] = true;
        }
        POINT pt = new POINT();
        pt.x = x;
        pt.y = y;
        OS.ClientToScreen(hwnd, pt);
        return OS.DragDetect(hwnd, pt);
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    Widget findItem(long id) {
        return null;
    }

    char[] fixMnemonic(String string) {
        return this.fixMnemonic(string, false, false);
    }

    char[] fixMnemonic(String string, boolean spaces) {
        return this.fixMnemonic(string, spaces, false);
    }

    char[] fixMnemonic(String string, boolean spaces, boolean removeAppended) {
        char[] buffer = new char[string.length() + 1];
        string.getChars(0, string.length(), buffer, 0);
        int i = 0;
        int j = 0;
        while (i < buffer.length) {
            if (buffer[i] == '&') {
                if (i + 1 < buffer.length && buffer[i + 1] == '&') {
                    buffer[j++] = spaces ? 32 : buffer[i];
                    ++i;
                }
                ++i;
                continue;
            }
            if (buffer[i] == '(' && removeAppended && i + 4 == string.length() && buffer[i + 1] == '&' && buffer[i + 3] == ')') {
                if (spaces) {
                    buffer[j++] = 32;
                }
                i += 4;
                continue;
            }
            buffer[j++] = buffer[i++];
        }
        while (j < buffer.length) {
            buffer[j++] = '\u0000';
        }
        return buffer;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(eventType);
    }

    public <L extends EventListener> Stream<L> getTypedListeners(int eventType, Class<L> listenerType) {
        return Arrays.stream(this.getListeners(eventType)).filter(TypedListener.class::isInstance).map(l -> ((TypedListener)l).eventListener).filter(listenerType::isInstance).map(listenerType::cast);
    }

    Menu getMenu() {
        return null;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    public boolean isAutoDirection() {
        return (this.state & 0x400000) != 0;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void mapEvent(long hwnd, Event event) {
    }

    GC new_GC(GCData data) {
        return null;
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void release(boolean destroy) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ExceptionStash exceptions = new ExceptionStash();){
            if ((this.state & 0x1000) == 0) {
                this.state |= 0x1000;
                try {
                    this.sendEvent(12);
                }
                catch (Error | RuntimeException ex) {
                    exceptions.stash(ex);
                }
            }
            if ((this.state & 1) == 0) {
                try {
                    this.releaseChildren(destroy);
                }
                catch (Error | RuntimeException ex) {
                    exceptions.stash(ex);
                }
            }
            if ((this.state & 0x800) == 0) {
                this.state |= 0x800;
                if (destroy) {
                    this.releaseParent();
                    this.releaseWidget();
                    this.destroyWidget();
                } else {
                    this.releaseWidget();
                    this.releaseHandle();
                }
            }
            this.notifyDisposalTracker();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void releaseChildren(boolean destroy) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._removeListener(eventType, listener);
    }

    protected void removeListener(int eventType, SWTEventListener listener) {
        this.removeTypedListener(eventType, listener);
    }

    protected void removeTypedListener(int eventType, EventListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    public void reskin(int flags) {
        this.checkWidget();
        this.reskinWidget();
        if ((flags & 1) != 0) {
            this.reskinChildren(flags);
        }
    }

    void reskinChildren(int flags) {
    }

    void reskinWidget() {
        if ((this.state & 0x200000) != 0x200000) {
            this.state |= 0x200000;
            this.display.addSkinnableWidget(this);
        }
    }

    boolean sendDragEvent(int button, int x, int y) {
        Event event = new Event();
        event.button = button;
        event.setLocationInPixels(x, y);
        this.setInputState(event, 29);
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendDragEvent(int button, int stateMask, int x, int y) {
        Event event = new Event();
        event.button = button;
        event.setLocationInPixels(x, y);
        event.stateMask = stateMask;
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            display.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    void sendSelectionEvent(int type) {
        this.sendSelectionEvent(type, null, false);
    }

    void sendSelectionEvent(int type, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(type)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        this.setInputState(event, type);
        this.sendEvent(type, event, send);
    }

    boolean sendKeyEvent(int type, int msg, long wParam, long lParam) {
        Event event = new Event();
        if (!this.setKeyState(event, type, wParam, lParam)) {
            return true;
        }
        return this.sendKeyEvent(type, msg, wParam, lParam, event);
    }

    boolean sendKeyEvent(int type, int msg, long wParam, long lParam, Event event) {
        this.sendEvent(type, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendMouseEvent(int type, int button, long hwnd, long lParam) {
        return this.sendMouseEvent(type, button, this.display.getClickCount(type, button, hwnd, lParam), 0, false, hwnd, lParam);
    }

    boolean sendMouseEvent(int type, int button, int count, int detail, boolean send, long hwnd, long lParam) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        Event event = new Event();
        event.button = button;
        event.detail = detail;
        event.count = count;
        event.setLocationInPixels(OS.GET_X_LPARAM(lParam), OS.GET_Y_LPARAM(lParam));
        this.setInputState(event, type);
        this.mapEvent(hwnd, event);
        if (send) {
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(type, event);
        }
        return event.doit;
    }

    boolean sendMouseWheelEvent(int type, long hwnd, long wParam, long lParam) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        boolean vertical = type == 37;
        MouseWheelData wheelData = new MouseWheelData(vertical, null, wParam, this.display.scrollRemainderEvt);
        if (wheelData.count == 0) {
            return true;
        }
        if (!vertical) {
            wheelData.count = -wheelData.count;
        }
        POINT pt = new POINT();
        OS.POINTSTOPOINT(pt, lParam);
        OS.ScreenToClient(hwnd, pt);
        lParam = OS.MAKELPARAM(pt.x, pt.y);
        return this.sendMouseEvent(type, 0, wheelData.count, wheelData.detail, true, hwnd, lParam);
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
        if (key.equals("org.eclipse.swt.skin.class") || key.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    boolean sendFocusEvent(int type) {
        this.sendEvent(type);
        return true;
    }

    boolean setInputState(Event event, int type) {
        if (OS.GetKeyState(18) < 0) {
            event.stateMask |= 0x10000;
        }
        if (OS.GetKeyState(16) < 0) {
            event.stateMask |= 0x20000;
        }
        if (OS.GetKeyState(17) < 0) {
            event.stateMask |= 0x40000;
        }
        if (OS.GetKeyState(1) < 0) {
            event.stateMask |= 0x80000;
        }
        if (OS.GetKeyState(4) < 0) {
            event.stateMask |= 0x100000;
        }
        if (OS.GetKeyState(2) < 0) {
            event.stateMask |= 0x200000;
        }
        if (this.display.xMouse) {
            if (OS.GetKeyState(5) < 0) {
                event.stateMask |= 0x800000;
            }
            if (OS.GetKeyState(6) < 0) {
                event.stateMask |= 0x2000000;
            }
        }
        switch (type) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode != 262144) break;
                event.stateMask &= 0xFFFBFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode != 262144) break;
                event.stateMask |= 0x40000;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int type, long wParam, long lParam) {
        switch (this.display.lastAscii) {
            case 127: {
                if (this.display.lastKey != 8) break;
                this.display.lastAscii = 8;
                break;
            }
            case 10: {
                if (this.display.lastKey != 13) break;
                this.display.lastAscii = 13;
            }
        }
        if (this.display.lastKey == 13 && this.display.lastAscii == 13 && (lParam & 0x1000000L) != 0L) {
            this.display.lastKey = 0x1000050;
        }
        this.setLocationMask(event, type, wParam, lParam);
        if (this.display.lastVirtual) {
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (this.display.lastKey == 3) {
                this.display.lastAscii = 0;
            }
            event.keyCode = Display.translateKey(this.display.lastKey);
        } else {
            event.keyCode = this.display.lastKey;
        }
        event.character = (char)this.display.lastAscii;
        if (event.keyCode == 0 && event.character == '\u0000') {
            return false;
        }
        return this.setInputState(event, type);
    }

    int setLocationMask(Event event, int type, long wParam, long lParam) {
        int location = 0;
        if (this.display.lastVirtual) {
            switch (this.display.lastKey) {
                case 16: {
                    if (OS.GetKeyState(160) < 0) {
                        location = 16384;
                    }
                    if (OS.GetKeyState(161) >= 0) break;
                    location = 131072;
                    break;
                }
                case 144: {
                    location = 2;
                    break;
                }
                case 17: 
                case 18: {
                    location = (lParam & 0x1000000L) == 0L ? 16384 : 131072;
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 45: 
                case 46: {
                    if ((lParam & 0x1000000L) != 0L) break;
                    location = 2;
                }
            }
            if (this.display.numpadKey(this.display.lastKey) != 0) {
                location = 2;
            }
        } else if (this.display.lastKey == 0x1000050) {
            location = 2;
        }
        event.keyLocation = location;
        return location;
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        return false;
    }

    boolean showMenu(int x, int y) {
        return this.showMenu(x, y, 0);
    }

    boolean showMenu(int x, int y, int detail) {
        Event event = new Event();
        event.setLocationInPixels(x, y);
        event.detail = detail;
        if (event.detail == 1) {
            this.updateMenuLocation(event);
        }
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return false;
        }
        if (!event.doit) {
            return true;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            Point loc = event.getLocationInPixels();
            if (x != loc.x || y != loc.y) {
                menu.setLocation(event.getLocation());
            }
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }

    void updateMenuLocation(Event event) {
    }

    LRESULT wmCaptureChanged(long hwnd, long wParam, long lParam) {
        this.display.captureChanged = true;
        return null;
    }

    LRESULT wmChar(long hwnd, long wParam, long lParam) {
        this.display.lastAscii = (int)wParam;
        if (!this.sendKeyEvent(1, 258, wParam, lParam)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmContextMenu(long hwnd, long wParam, long lParam) {
        if (wParam != hwnd) {
            return null;
        }
        int x = 0;
        int y = 0;
        int detail = 0;
        if (lParam != -1L) {
            POINT pt = new POINT();
            OS.POINTSTOPOINT(pt, lParam);
            x = pt.x;
            y = pt.y;
            detail = 0;
            OS.ScreenToClient(hwnd, pt);
            RECT rect = new RECT();
            OS.GetClientRect(hwnd, rect);
            if (!OS.PtInRect(rect, pt)) {
                return null;
            }
        } else {
            int pos = OS.GetMessagePos();
            x = OS.GET_X_LPARAM(pos);
            y = OS.GET_Y_LPARAM(pos);
            detail = 1;
        }
        return this.showMenu(x, y, detail) ? LRESULT.ZERO : null;
    }

    LRESULT wmIMEChar(long hwnd, long wParam, long lParam) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = (int)wParam;
        display.lastDead = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, wParam, lParam)) {
            return LRESULT.ONE;
        }
        this.sendKeyEvent(2, 646, wParam, lParam);
        display.lastAscii = 0;
        display.lastKey = 0;
        return LRESULT.ONE;
    }

    int mapVirtualKey(int virtualKey) {
        if (48 <= virtualKey && virtualKey <= 57) {
            return virtualKey;
        }
        if (65 <= virtualKey && virtualKey <= 90) {
            return virtualKey;
        }
        return OS.MapVirtualKey(virtualKey, 2);
    }

    LRESULT wmKeyDown(long hwnd, long wParam, long lParam) {
        switch ((int)wParam) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((lParam & 0x40000000L) == 0L) break;
                return null;
            }
        }
        this.display.lastKey = 0;
        this.display.lastAscii = 0;
        this.display.lastDead = false;
        this.display.lastVirtual = false;
        int mapKey = this.mapVirtualKey((int)wParam);
        MSG msg = new MSG();
        int flags = 2;
        if (OS.PeekMessage(msg, hwnd, 259, 259, flags)) {
            this.display.lastDead = true;
            this.display.lastVirtual = mapKey == 0;
            this.display.lastKey = this.display.lastVirtual ? (int)wParam : mapKey;
            return null;
        }
        boolean isCharPending = false;
        if (OS.PeekMessage(msg, hwnd, 258, 258, flags)) {
            isCharPending = true;
        }
        if (this.isDisposed()) {
            return LRESULT.ONE;
        }
        boolean bl = this.display.lastVirtual = mapKey == 0 || this.display.numpadKey((int)wParam) != 0;
        if (this.display.lastVirtual) {
            this.display.lastKey = (int)wParam;
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (96 <= this.display.lastKey && this.display.lastKey <= 111) {
                this.display.lastAscii = this.display.numpadKey(this.display.lastKey);
            }
        } else {
            this.display.lastKey = (int)OS.CharLower(OS.LOWORD(mapKey));
            if (wParam == 3L) {
                this.display.lastVirtual = true;
            }
            if (OS.GetKeyState(17) < 0) {
                if (OS.GetKeyState(16) < 0) {
                    this.display.lastAscii = this.display.shiftedKey((int)wParam);
                    if (this.display.lastAscii == 0) {
                        this.display.lastAscii = mapKey;
                    }
                } else {
                    this.display.lastAscii = (int)OS.CharLower(OS.LOWORD(mapKey));
                }
                this.display.lastAscii = this.display.controlKey(this.display.lastAscii);
            }
        }
        if (isCharPending) {
            return null;
        }
        if (!this.sendKeyEvent(1, 256, wParam, lParam)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmKeyUp(long hwnd, long wParam, long lParam) {
        Display display = this.display;
        if (!this.hooks(2) && !display.filters(2)) {
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastDead = false;
            display.lastVirtual = false;
            return null;
        }
        int mapKey = OS.MapVirtualKey((int)wParam, 2);
        if (display.lastDead) {
            return null;
        }
        boolean bl = display.lastVirtual = mapKey == 0 || display.numpadKey((int)wParam) != 0;
        if (display.lastVirtual) {
            display.lastKey = (int)wParam;
        } else {
            if (wParam == 3L) {
                display.lastVirtual = true;
            }
            if (display.lastKey == 0) {
                display.lastAscii = 0;
                display.lastDead = false;
                return null;
            }
        }
        LRESULT result = null;
        if (!this.sendKeyEvent(2, 257, wParam, lParam)) {
            result = LRESULT.ONE;
        }
        display.lastAscii = 0;
        display.lastKey = 0;
        display.lastDead = false;
        display.lastVirtual = false;
        return result;
    }

    LRESULT wmKillFocus(long hwnd, long wParam, long lParam) {
        this.display.scrollRemainderEvt.x = 0;
        this.display.scrollRemainderEvt.y = 0;
        this.display.scrollRemainderBar.x = 0;
        this.display.scrollRemainderBar.y = 0;
        long code = this.callWindowProc(hwnd, 8, wParam, lParam);
        this.sendFocusEvent(16);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (code == 0L) {
            return LRESULT.ZERO;
        }
        return new LRESULT(code);
    }

    LRESULT wmLButtonDblClk(long hwnd, long wParam, long lParam) {
        LRESULT result = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 1, hwnd, lParam);
        result = this.sendMouseEvent(8, 1, hwnd, lParam) ? new LRESULT(this.callWindowProc(hwnd, 515, wParam, lParam)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != hwnd) {
            OS.SetCapture(hwnd);
        }
        return result;
    }

    LRESULT wmLButtonDown(long hwnd, long wParam, long lParam) {
        Display display = this.display;
        LRESULT result = null;
        int x = OS.GET_X_LPARAM(lParam);
        int y = OS.GET_Y_LPARAM(lParam);
        boolean[] consume = null;
        boolean[] detect = null;
        boolean dragging = false;
        boolean mouseDown = true;
        int count = display.getClickCount(3, 1, hwnd, lParam);
        if (count == 1 && (this.state & 0x8000) != 0 && this.hooks(29)) {
            detect = new boolean[1];
            consume = new boolean[1];
            dragging = this.dragDetect(hwnd, x, y, true, detect, consume);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            mouseDown = OS.GetKeyState(1) < 0;
        }
        display.captureChanged = false;
        boolean dispatch = this.sendMouseEvent(3, 1, count, 0, false, hwnd, lParam);
        result = dispatch && (consume == null || !consume[0]) ? new LRESULT(this.callWindowProc(hwnd, 513, wParam, lParam)) : LRESULT.ZERO;
        if (mouseDown && !display.captureChanged && !this.isDisposed() && OS.GetCapture() != hwnd) {
            OS.SetCapture(hwnd);
        }
        if (dragging) {
            this.sendDragEvent(1, x, y);
        } else if (detect != null && detect[0] && OS.GetKeyState(27) >= 0) {
            OS.SendMessage(hwnd, 514, wParam, lParam);
        }
        return result;
    }

    LRESULT wmLButtonUp(long hwnd, long wParam, long lParam) {
        Display display = this.display;
        LRESULT result = null;
        result = this.sendMouseEvent(4, 1, hwnd, lParam) ? new LRESULT(this.callWindowProc(hwnd, 514, wParam, lParam)) : LRESULT.ZERO;
        int mask = 19;
        if (display.xMouse) {
            mask |= 0x60;
        }
        if ((wParam & (long)mask) == 0L && OS.GetCapture() == hwnd) {
            OS.ReleaseCapture();
        }
        return result;
    }

    LRESULT wmMButtonDblClk(long hwnd, long wParam, long lParam) {
        LRESULT result = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 2, hwnd, lParam);
        result = this.sendMouseEvent(8, 2, hwnd, lParam) ? new LRESULT(this.callWindowProc(hwnd, 521, wParam, lParam)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != hwnd) {
            OS.SetCapture(hwnd);
        }
        return result;
    }

    LRESULT wmMButtonDown(long hwnd, long wParam, long lParam) {
        LRESULT result = null;
        Display display = this.display;
        display.captureChanged = false;
        result = this.sendMouseEvent(3, 2, hwnd, lParam) ? new LRESULT(this.callWindowProc(hwnd, 519, wParam, lParam)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != hwnd) {
            OS.SetCapture(hwnd);
        }
        return result;
    }

    LRESULT wmMButtonUp(long hwnd, long wParam, long lParam) {
        Display display = this.display;
        LRESULT result = null;
        result = this.sendMouseEvent(4, 2, hwnd, lParam) ? new LRESULT(this.callWindowProc(hwnd, 520, wParam, lParam)) : LRESULT.ZERO;
        int mask = 19;
        if (display.xMouse) {
            mask |= 0x60;
        }
        if ((wParam & (long)mask) == 0L && OS.GetCapture() == hwnd) {
            OS.ReleaseCapture();
        }
        return result;
    }

    LRESULT wmMouseHover(long hwnd, long wParam, long lParam) {
        if (!this.sendMouseEvent(32, 0, hwnd, lParam)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT wmMouseLeave(long hwnd, long wParam, long lParam) {
        this.state &= 0xFF7FFFFF;
        if (!this.hooks(7) && !this.filters(7)) {
            return null;
        }
        int pos = OS.GetMessagePos();
        POINT pt = new POINT();
        OS.POINTSTOPOINT(pt, pos);
        OS.ScreenToClient(hwnd, pt);
        lParam = OS.MAKELPARAM(pt.x, pt.y);
        if (!this.sendMouseEvent(7, 0, hwnd, lParam)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT wmMouseMove(long hwnd, long wParam, long lParam) {
        LRESULT result = null;
        Display display = this.display;
        int pos = OS.GetMessagePos();
        if (pos != display.lastMouse || display.captureChanged) {
            boolean mouseHover;
            boolean trackMouse = (this.state & 0x2000) != 0;
            boolean mouseEnter = this.hooks(6) || display.filters(6);
            boolean mouseExit = this.hooks(7) || display.filters(7);
            boolean bl = mouseHover = this.hooks(32) || display.filters(32);
            if (trackMouse || mouseEnter || mouseExit || mouseHover) {
                TRACKMOUSEEVENT lpEventTrack = new TRACKMOUSEEVENT();
                lpEventTrack.cbSize = TRACKMOUSEEVENT.sizeof;
                lpEventTrack.dwFlags = 3;
                lpEventTrack.hwndTrack = hwnd;
                OS.TrackMouseEvent(lpEventTrack);
                if (mouseEnter && (this.state & 0x800000) == 0) {
                    MSG msg = new MSG();
                    int flags = 10420227;
                    while (OS.PeekMessage(msg, 0L, 675, 675, flags)) {
                        OS.TranslateMessage(msg);
                        OS.DispatchMessage(msg);
                    }
                    this.sendMouseEvent(6, 0, hwnd, lParam);
                }
                this.state |= 0x800000;
            }
            if (pos != display.lastMouse) {
                display.lastMouse = pos;
                if (!this.sendMouseEvent(5, 0, hwnd, lParam)) {
                    result = LRESULT.ZERO;
                }
            }
        }
        display.captureChanged = false;
        return result;
    }

    LRESULT wmMouseWheel(long hwnd, long wParam, long lParam) {
        return this.sendMouseWheelEvent(37, hwnd, wParam, lParam) ? null : LRESULT.ZERO;
    }

    LRESULT wmMouseHWheel(long hwnd, long wParam, long lParam) {
        return this.sendMouseWheelEvent(38, hwnd, wParam, lParam) ? null : LRESULT.ZERO;
    }

    LRESULT wmNCPaint(long hwnd, long wParam, long lParam) {
        return null;
    }

    LRESULT wmPaint(long hwnd, long wParam, long lParam) {
        if (!this.hooks(9) && !this.filters(9)) {
            return null;
        }
        long rgn = OS.CreateRectRgn(0, 0, 0, 0);
        OS.GetUpdateRgn(hwnd, rgn, false);
        long result = this.callWindowProc(hwnd, 15, wParam, lParam);
        GCData data = new GCData();
        data.hwnd = hwnd;
        GC gc = this.new_GC(data);
        if (gc != null) {
            OS.HideCaret(hwnd);
            RECT rect = new RECT();
            OS.GetRgnBox(rgn, rect);
            int width = rect.right - rect.left;
            int height = rect.bottom - rect.top;
            if (width != 0 && height != 0) {
                long hDC = gc.handle;
                OS.SelectClipRgn(hDC, rgn);
                OS.SetMetaRgn(hDC);
                Event event = new Event();
                event.gc = gc;
                event.setBoundsInPixels(new Rectangle(rect.left, rect.top, width, height));
                this.sendEvent(9, event);
                event.gc = null;
            }
            gc.dispose();
            OS.ShowCaret(hwnd);
        }
        OS.DeleteObject(rgn);
        if (result == 0L) {
            return LRESULT.ZERO;
        }
        return new LRESULT(result);
    }

    LRESULT wmPrint(long hwnd, long wParam, long lParam) {
        int bits;
        if ((lParam & 2L) != 0L && OS.IsAppThemed() && ((bits = OS.GetWindowLong(hwnd, -20)) & 0x200) != 0) {
            long code = this.callWindowProc(hwnd, 791, wParam, lParam);
            RECT rect = new RECT();
            OS.GetWindowRect(hwnd, rect);
            rect.right -= rect.left;
            rect.bottom -= rect.top;
            rect.top = 0;
            rect.left = 0;
            int border = OS.GetSystemMetrics(45);
            OS.ExcludeClipRect(wParam, border, border, rect.right - border, rect.bottom - border);
            OS.DrawThemeBackground(this.display.hEditTheme(), wParam, 1, 1, rect, null);
            return new LRESULT(code);
        }
        return null;
    }

    LRESULT wmRButtonDblClk(long hwnd, long wParam, long lParam) {
        LRESULT result = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 3, hwnd, lParam);
        result = this.sendMouseEvent(8, 3, hwnd, lParam) ? new LRESULT(this.callWindowProc(hwnd, 518, wParam, lParam)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != hwnd) {
            OS.SetCapture(hwnd);
        }
        return result;
    }

    LRESULT wmRButtonDown(long hwnd, long wParam, long lParam) {
        LRESULT result = null;
        Display display = this.display;
        display.captureChanged = false;
        result = this.sendMouseEvent(3, 3, hwnd, lParam) ? new LRESULT(this.callWindowProc(hwnd, 516, wParam, lParam)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != hwnd) {
            OS.SetCapture(hwnd);
        }
        return result;
    }

    LRESULT wmRButtonUp(long hwnd, long wParam, long lParam) {
        Display display = this.display;
        LRESULT result = null;
        if (this.sendMouseEvent(4, 3, hwnd, lParam)) {
            result = new LRESULT(this.callWindowProc(hwnd, 517, wParam, lParam));
        } else {
            OS.DefWindowProc(hwnd, 517, wParam, lParam);
            result = LRESULT.ZERO;
        }
        int mask = 19;
        if (display.xMouse) {
            mask |= 0x60;
        }
        if ((wParam & (long)mask) == 0L && OS.GetCapture() == hwnd) {
            OS.ReleaseCapture();
        }
        return result;
    }

    LRESULT wmSetFocus(long hwnd, long wParam, long lParam) {
        long code = this.callWindowProc(hwnd, 7, wParam, lParam);
        this.sendFocusEvent(15);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (code == 0L) {
            return LRESULT.ZERO;
        }
        return new LRESULT(code);
    }

    LRESULT wmSysChar(long hwnd, long wParam, long lParam) {
        Display display = this.display;
        display.lastAscii = (int)wParam;
        if (!this.hooks(1) && !display.filters(1)) {
            return null;
        }
        boolean oldKeyHit = display.mnemonicKeyHit;
        display.mnemonicKeyHit = true;
        long result = this.callWindowProc(hwnd, 262, wParam, lParam);
        boolean consumed = false;
        if (!display.mnemonicKeyHit) {
            consumed = !this.sendKeyEvent(1, 262, wParam, lParam);
        }
        display.mnemonicKeyHit = oldKeyHit;
        return (consumed |= display.mnemonicKeyHit) ? LRESULT.ONE : new LRESULT(result);
    }

    LRESULT wmSysKeyDown(long hwnd, long wParam, long lParam) {
        if (wParam != 121L && (lParam & 0x20000000L) == 0L) {
            return null;
        }
        switch ((int)wParam) {
            case 115: {
                long hwndShell = hwnd;
                while (OS.GetParent(hwndShell) != 0L) {
                    if (OS.GetWindow(hwndShell, 4) != 0L) break;
                    hwndShell = OS.GetParent(hwndShell);
                }
                int bits = OS.GetWindowLong(hwndShell, -16);
                if ((bits & 0x80000) == 0) break;
                return null;
            }
        }
        switch ((int)wParam) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((lParam & 0x40000000L) == 0L) break;
                return null;
            }
        }
        this.display.lastKey = 0;
        this.display.lastAscii = 0;
        this.display.lastDead = false;
        this.display.lastVirtual = false;
        int mapKey = this.mapVirtualKey((int)wParam);
        MSG msg = new MSG();
        int flags = 2;
        if (OS.PeekMessage(msg, hwnd, 263, 263, flags)) {
            this.display.lastDead = true;
            this.display.lastVirtual = mapKey == 0;
            this.display.lastKey = this.display.lastVirtual ? (int)wParam : mapKey;
            return null;
        }
        boolean isCharPending = false;
        if (OS.PeekMessage(msg, hwnd, 262, 262, flags)) {
            isCharPending = true;
        }
        if (this.isDisposed()) {
            return LRESULT.ONE;
        }
        boolean bl = this.display.lastVirtual = mapKey == 0 || this.display.numpadKey((int)wParam) != 0;
        if (this.display.lastVirtual) {
            this.display.lastKey = (int)wParam;
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (96 <= this.display.lastKey && this.display.lastKey <= 111) {
                this.display.lastAscii = this.display.numpadKey(this.display.lastKey);
            }
        } else {
            this.display.lastKey = (int)OS.CharLower(OS.LOWORD(mapKey));
        }
        if (isCharPending) {
            return null;
        }
        if (!this.sendKeyEvent(1, 260, wParam, lParam)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmSysKeyUp(long hwnd, long wParam, long lParam) {
        return this.wmKeyUp(hwnd, wParam, lParam);
    }

    LRESULT wmXButtonDblClk(long hwnd, long wParam, long lParam) {
        LRESULT result = null;
        Display display = this.display;
        display.captureChanged = false;
        int button = OS.HIWORD(wParam) == 1 ? 4 : 5;
        this.sendMouseEvent(3, button, hwnd, lParam);
        result = this.sendMouseEvent(8, button, hwnd, lParam) ? new LRESULT(this.callWindowProc(hwnd, 525, wParam, lParam)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != hwnd) {
            OS.SetCapture(hwnd);
        }
        return result;
    }

    LRESULT wmXButtonDown(long hwnd, long wParam, long lParam) {
        LRESULT result = null;
        Display display = this.display;
        display.captureChanged = false;
        display.xMouse = true;
        int button = OS.HIWORD(wParam) == 1 ? 4 : 5;
        result = this.sendMouseEvent(3, button, hwnd, lParam) ? new LRESULT(this.callWindowProc(hwnd, 523, wParam, lParam)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != hwnd) {
            OS.SetCapture(hwnd);
        }
        return result;
    }

    LRESULT wmXButtonUp(long hwnd, long wParam, long lParam) {
        Display display = this.display;
        LRESULT result = null;
        int button = OS.HIWORD(wParam) == 1 ? 4 : 5;
        result = this.sendMouseEvent(4, button, hwnd, lParam) ? new LRESULT(this.callWindowProc(hwnd, 524, wParam, lParam)) : LRESULT.ZERO;
        int mask = 19;
        if (display.xMouse) {
            mask |= 0x60;
        }
        if ((wParam & (long)mask) == 0L && OS.GetCapture() == hwnd) {
            OS.ReleaseCapture();
        }
        return result;
    }

    void notifyCreationTracker() {
        if (WidgetSpy.isEnabled) {
            WidgetSpy.getInstance().widgetCreated(this);
        }
    }

    void notifyDisposalTracker() {
        if (WidgetSpy.isEnabled) {
            WidgetSpy.getInstance().widgetDisposed(this);
        }
    }

    int getZoom() {
        return this.zoom;
    }

    void setZoom(int zoom) {
        this.zoom = zoom;
    }

    private static void handleDPIChange(Widget widget, int newZoom, float scalingFactor) {
        widget.setZoom(newZoom);
    }

    class MouseWheelData {
        int count;
        int detail;

        MouseWheelData(boolean isVertical, ScrollBar scrollBar, long wParam, Point remainder) {
            int delta = OS.GET_WHEEL_DELTA_WPARAM(wParam);
            if (isVertical) {
                int[] wheelSpeed = new int[1];
                OS.SystemParametersInfo(104, 0, wheelSpeed, 0);
                if (wheelSpeed[0] == -1) {
                    this.detail = 2;
                } else {
                    delta *= wheelSpeed[0];
                    this.detail = 1;
                }
            } else {
                int[] wheelSpeed = new int[1];
                OS.SystemParametersInfo(108, 0, wheelSpeed, 0);
                delta *= wheelSpeed[0];
                this.detail = 0;
            }
            if (scrollBar != null) {
                delta = this.detail == 2 ? (delta *= scrollBar.getPageIncrement()) : (delta *= scrollBar.getIncrement());
            }
            if (isVertical) {
                if ((delta ^ remainder.y) >= 0) {
                    delta += remainder.y;
                }
                remainder.y = delta % 120;
            } else {
                if ((delta ^ remainder.x) >= 0) {
                    delta += remainder.x;
                }
                remainder.x = delta % 120;
            }
            this.count = delta / 120;
        }
    }
}

