/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.filter;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterEditUtils;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterViewer;

class FilterDropTargetAdapter
extends DropTargetAdapter {
    private FilterViewer fViewer;

    public FilterDropTargetAdapter(FilterViewer viewer) {
        this.fViewer = viewer;
    }

    private static boolean isAncestor(ITmfFilterTreeNode droppedNode, ITmfFilterTreeNode node) {
        ITmfFilterTreeNode tmp = node;
        while (tmp != null) {
            ITmfFilterTreeNode n = tmp.getParent();
            if (n == droppedNode) {
                return true;
            }
            tmp = n;
        }
        return false;
    }

    public void dropAccept(DropTargetEvent event) {
        ITmfFilterTreeNode treeNodeToDrop = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            treeNodeToDrop = FilterEditUtils.getTransferredTreeNode();
        }
        if (treeNodeToDrop == null) {
            event.detail = 0;
            return;
        }
        if (event.item instanceof TreeItem) {
            ITmfFilterTreeNode node;
            Object data = event.item.getData();
            if (data instanceof ITmfFilterTreeNode && (node = (ITmfFilterTreeNode)data).getValidChildren().contains(treeNodeToDrop.getNodeName())) {
                if (FilterDropTargetAdapter.isAncestor(treeNodeToDrop, node) && event.detail != 1) {
                    event.detail = 0;
                }
                return;
            }
        } else {
            if (!"FILTER".equals(treeNodeToDrop.getNodeName())) {
                event.detail = 0;
            }
            return;
        }
        event.detail = 0;
    }

    public void drop(DropTargetEvent event) {
        ITmfFilterTreeNode treeNodeToDrop = FilterEditUtils.getTransferredTreeNode();
        if (event.item instanceof TreeItem) {
            ITmfFilterTreeNode node;
            Object data = event.item.getData();
            if (data instanceof ITmfFilterTreeNode && (node = (ITmfFilterTreeNode)data).getValidChildren().contains(treeNodeToDrop.getNodeName())) {
                treeNodeToDrop = treeNodeToDrop.clone();
                node.addChild(treeNodeToDrop);
                this.fViewer.refresh();
                this.fViewer.setSelection(treeNodeToDrop, true);
                return;
            }
        } else if ("FILTER".equals(treeNodeToDrop.getNodeName())) {
            ITmfFilterTreeNode root = this.fViewer.getInput();
            treeNodeToDrop = treeNodeToDrop.clone();
            root.addChild(treeNodeToDrop);
            this.fViewer.refresh();
            this.fViewer.setSelection(treeNodeToDrop, true);
            return;
        }
    }
}

