/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.log;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerTest {
    private StringOutputStream fLog;
    private Logger fLogger;
    private StreamHandler fStreamHandler;

    private static String eventUnifyId(String event) {
        return event.replaceFirst("\\\"id\\\"\\:\\\"0x[0-9A-Fa-f]+\\\"", "\"id\":\"0x1234\"");
    }

    @Before
    public void before() {
        this.fLogger = Logger.getAnonymousLogger();
        this.fLog = new StringOutputStream();
        this.fStreamHandler = new StreamHandler(this.fLog, new SimpleFormatter());
        this.fStreamHandler.setLevel(Level.FINER);
        this.fLogger.setLevel(Level.ALL);
        this.fLogger.addHandler(this.fStreamHandler);
    }

    private static void assertLogMessage(String message, String expectedLevel, String expectedPhase, String expectedName) {
        String[] parts = message.split(":", 2);
        Assert.assertEquals((Object)expectedLevel, (Object)parts[0]);
        JsonObject json = JsonParser.parseString((String)parts[1].trim()).getAsJsonObject();
        Assert.assertEquals((Object)expectedPhase, (Object)json.get("ph").getAsString());
        Assert.assertTrue((json.get("tid").getAsInt() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((json.get("pid").getAsInt() > 0 ? 1 : 0) != 0);
        if (expectedName != null) {
            Assert.assertEquals((Object)expectedName, (Object)json.get("name").getAsString());
        }
    }

    @Test
    public void testHelloWorld() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(logger, Level.INFO, "world", new Object[0]);){
            new Object();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "INFO", "B", "world");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "INFO", "E", null);
    }

    @Test
    public void testNesting() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(logger, Level.INFO, "foo", new Object[0]);){
            new Object();
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TraceCompassLogUtils.ScopeLog log1 = new TraceCompassLogUtils.ScopeLog(logger, Level.INFO, "bar", new Object[0]);){
                new Object();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "INFO", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "INFO", "B", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "INFO", "E", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "INFO", "E", null);
    }

    @Test
    public void testNestingFiltered() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(logger, Level.FINE, "foo", new Object[0]);){
            new Object();
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TraceCompassLogUtils.ScopeLog log1 = new TraceCompassLogUtils.ScopeLog(logger, Level.FINER, "bar", new Object[0]);){
                new Object();
                Throwable throwable3 = null;
                Object var9_14 = null;
                try (TraceCompassLogUtils.ScopeLog log2 = new TraceCompassLogUtils.ScopeLog(logger, Level.FINEST, "baz", new Object[0]);){
                    new Object();
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "FINE", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "FINER", "B", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "FINER", "E", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "FINE", "E", null);
    }

    @Test
    public void testNestingLogLevels() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(logger, Level.WARNING, "foo", new Object[0]);){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TraceCompassLogUtils.ScopeLog log1 = new TraceCompassLogUtils.ScopeLog(logger, Level.FINE, "bar", new Object[0]);){
                new Object();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "WARNING", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "FINE", "B", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "FINE", "E", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "WARNING", "E", null);
    }

    @Test
    public void testNestingWithData() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(logger, Level.WARNING, "foo", new Object[0]);){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TraceCompassLogUtils.ScopeLog log1 = new TraceCompassLogUtils.ScopeLog(logger, Level.FINE, "bar", new Object[0]);){
                log1.addData("return", (Object)false);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "WARNING", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "FINE", "B", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "FINE", "E", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "WARNING", "E", null);
    }

    @Test
    public void testFlowFiltered() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.FINE, "foo", new Object[0]).setCategory("mycat").build();){
            new Object();
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TraceCompassLogUtils.FlowScopeLog log1 = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.FINER, "bar", new Object[]{"big", "ben"}).setParentScope(log).build();){
                new Object();
                Throwable throwable3 = null;
                Object var9_14 = null;
                try (TraceCompassLogUtils.FlowScopeLog log2 = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.FINEST, "baz", new Object[0]).setParentScope(log1).build();){
                    new Object();
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "FINE", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "FINE", "s", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "FINER", "B", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "FINER", "t", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(4), "FINER", "E", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(5), "FINE", "E", null);
    }

    @Test
    public void testFlowLogLevels() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.WARNING, "foo", new Object[0]).setCategory("mydog").build();){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TraceCompassLogUtils.FlowScopeLog log1 = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.FINE, "bar", new Object[0]).setParentScope(log).build();){
                log1.step("barked", new Object[0]);
                new Object();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "WARNING", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "WARNING", "s", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "FINE", "B", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "FINE", "t", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(4), "FINE", "t", "barked");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(5), "FINE", "E", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(6), "WARNING", "E", null);
    }

    @Test
    public void testFlowWithUnsetParent() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.WARNING, "foo", new Object[0]).setCategory("mydog").build();){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TraceCompassLogUtils.FlowScopeLog log1 = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.FINE, "bar", new Object[0]).setCategoryAndId("mydog", log.getId()).build();){
                log1.step("barked", new Object[0]);
                new Object();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "WARNING", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "WARNING", "s", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "FINE", "B", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "FINE", "t", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(4), "FINE", "t", "barked");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(5), "FINE", "E", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(6), "WARNING", "E", null);
    }

    @Test
    public void testFlowWithData() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.WARNING, "foo", new Object[0]).setCategory("myspider").build();){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TraceCompassLogUtils.FlowScopeLog log1 = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.FINE, "bar", new Object[0]).setParentScope(log).build();){
                log1.addData("return", (Object)false);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "WARNING", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "WARNING", "s", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "FINE", "B", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "FINE", "t", "bar");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(4), "FINE", "E", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(5), "WARNING", "E", null);
    }

    @Test
    public void testFlowBuilderNoExtra() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.WARNING, "foo", new Object[0]).build();){
            new Object();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "WARNING", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "WARNING", "s", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "WARNING", "E", null);
    }

    @Test(expected=IllegalStateException.class)
    public void testFlowBuilderCatThenParent() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.WARNING, "foo", new Object[0]).setCategory("myspider").build();){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TraceCompassLogUtils.FlowScopeLog log1 = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.FINE, "bar", new Object[0]).setParentScope(log).setCategory("myspider").build();){
                new Object();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testFlowBuilderParentThenCat() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.WARNING, "foo", new Object[0]).setCategory("myspider").build();){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (TraceCompassLogUtils.FlowScopeLog log1 = new TraceCompassLogUtils.FlowScopeLogBuilder(logger, Level.FINE, "bar", new Object[0]).setCategory("myspider").setParentScope(log).build();){
                new Object();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testAttributes() {
        TraceCompassLogUtils.ScopeLog log;
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_6 = null;
        try {
            log = new TraceCompassLogUtils.ScopeLog(logger, Level.WARNING, "foo", new Object[]{"Pen:Pineapple", "Apple:Pen"});
            try {
                new Object();
            }
            finally {
                if (log != null) {
                    log.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            log = new TraceCompassLogUtils.ScopeLog(logger, Level.WARNING, "foo", new Object[]{"Pen:Pineapple:Apple:Pen"});
            try {
                new Object();
            }
            finally {
                if (log != null) {
                    log.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            log = new TraceCompassLogUtils.ScopeLog(logger, Level.WARNING, "foo", new Object[]{"pen", "pineapple", "apple", "pen", "number_of_badgers", 12});
            try {
                new Object();
            }
            finally {
                if (log != null) {
                    log.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "WARNING", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "WARNING", "E", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "WARNING", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "WARNING", "E", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(4), "WARNING", "B", "foo");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(5), "WARNING", "E", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAttributeFail3Args() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(logger, Level.WARNING, "foo", new Object[]{"Pen:Pineapple", "Apple", "Pen"});){
            new Object();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAttributeFailRepeatedArgs() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(logger, Level.WARNING, "foo", new Object[]{"badger", "badger", "badger", "badger"});){
            new Object();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testNestingException() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(logger, Level.INFO, "foo", new Object[0]);
                try {
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try {
                        TraceCompassLogUtils.ScopeLog log1 = new TraceCompassLogUtils.ScopeLog(logger, Level.INFO, "bar", new Object[0]);
                        try {
                            new Object();
                            throw new Exception("test");
                        }
                        catch (Throwable throwable3) {
                            if (log1 != null) {
                                log1.close();
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable5) {
                    if (log != null) {
                        log.close();
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"test", (Object)e.getMessage());
            this.fStreamHandler.flush();
            LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "INFO", "B", "foo");
            LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "INFO", "B", "bar");
            LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "INFO", "E", null);
            LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "INFO", "E", null);
            return;
        }
    }

    @Test
    public void testObjectLifespan() throws Throwable {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        LivingObject first = new LivingObject(logger);
        LivingObject second = new LivingObject(logger);
        Assert.assertNotNull((Object)first);
        Assert.assertNotNull((Object)second);
        first.finalize();
        second.finalize();
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "FINE", "N", "LivingObject");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "FINE", "N", "LivingObject");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "FINE", "D", "LivingObject");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "FINE", "D", "LivingObject");
    }

    @Test
    public void testCollectionLifespan() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        ArrayList<String> avengers = new ArrayList<String>();
        int uniqueID = TraceCompassLogUtils.traceObjectCreation((Logger)logger, (Level)Level.FINE, avengers);
        avengers.add("Cap");
        avengers.add("Arrow");
        avengers.add("Thor");
        avengers.add("Iron");
        TraceCompassLogUtils.traceObjectDestruction((Logger)logger, (Level)Level.FINE, avengers, (int)uniqueID);
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "FINE", "N", "ArrayList");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "FINE", "D", "ArrayList");
    }

    @Test
    public void testInstant() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        TraceCompassLogUtils.traceInstant((Logger)logger, (Level)Level.FINE, (String)"hello", (Object[])new Object[]{"foo", "bar"});
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "FINE", "i", "hello");
    }

    @Test
    public void testAsyncMessages() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        TraceCompassLogUtils.traceAsyncStart((Logger)logger, (Level)Level.FINE, (String)"network connect", (String)"net", (int)10, (Object[])new Object[0]);
        TraceCompassLogUtils.traceAsyncStart((Logger)logger, (Level)Level.FINER, (String)"network lookup", (String)"net", (int)10, (Object[])new Object[0]);
        TraceCompassLogUtils.traceAsyncNested((Logger)logger, (Level)Level.FINER, (String)"network cache", (String)"net", (int)10, (Object[])new Object[0]);
        TraceCompassLogUtils.traceAsyncStart((Logger)logger, (Level)Level.FINER, null, null, (int)0, (Object[])new Object[0]);
        TraceCompassLogUtils.traceAsyncEnd((Logger)logger, (Level)Level.FINER, null, null, (int)0, (Object[])new Object[0]);
        TraceCompassLogUtils.traceAsyncEnd((Logger)logger, (Level)Level.FINER, (String)"network lookup", (String)"net", (int)10, (Object[])new Object[]{"OK"});
        TraceCompassLogUtils.traceAsyncEnd((Logger)logger, (Level)Level.FINE, (String)"network connect", (String)"net", (int)10, (Object[])new Object[]{"OK"});
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "FINE", "b", "network connect");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "FINER", "b", "network lookup");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "FINER", "n", "network cache");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(3), "FINER", "b", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(4), "FINER", "e", null);
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(5), "FINER", "e", "network lookup");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(6), "FINE", "e", "network connect");
    }

    @Test
    public void testNullArguments() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        TraceCompassLogUtils.traceInstant((Logger)logger, (Level)Level.INFO, (String)"test null value", (Object[])new Object[]{"nullvalue", null});
        TraceCompassLogUtils.traceInstant((Logger)logger, (Level)Level.INFO, (String)"test null key", (Object[])new Object[]{null, "value"});
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "INFO", "i", "test null value");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "INFO", "i", "test null key");
    }

    @Test
    public void testCounter() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        TraceCompassLogUtils.traceCounter((Logger)logger, (Level)Level.FINER, (String)"counter", (Object[])new Object[]{"cats", 0});
        TraceCompassLogUtils.traceCounter((Logger)logger, (Level)Level.FINER, (String)"counter", (Object[])new Object[]{"cats", 10});
        TraceCompassLogUtils.traceCounter((Logger)logger, (Level)Level.FINER, (String)"counter", (Object[])new Object[]{"cats", 0});
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "FINER", "C", "counter");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "FINER", "C", "counter");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(2), "FINER", "C", "counter");
    }

    @Test
    public void testMarker() {
        Logger logger = this.fLogger;
        Assert.assertNotNull((Object)logger);
        TraceCompassLogUtils.traceMarker((Logger)logger, (Level)Level.CONFIG, (String)"instant", (long)0L, (Object[])new Object[0]);
        TraceCompassLogUtils.traceMarker((Logger)logger, (Level)Level.CONFIG, (String)"colored", (long)15L, (Object[])new Object[]{"color", 179031261});
        this.fStreamHandler.flush();
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(0), "CONFIG", "R", "instant");
        LoggerTest.assertLogMessage(this.fLog.getMessages().get(1), "CONFIG", "R", "colored");
    }

    private static final class LivingObject {
        private final @NonNull Logger fLog;

        public LivingObject(@NonNull Logger logger) {
            this.fLog = logger;
            TraceCompassLogUtils.traceObjectCreation((Logger)this.fLog, (Level)Level.FINE, (Object)this);
        }

        protected void finalize() throws Throwable {
            TraceCompassLogUtils.traceObjectDestruction((Logger)this.fLog, (Level)Level.FINE, (Object)this);
            super.finalize();
        }
    }

    private static class StringOutputStream
    extends OutputStream {
        private List<String> fMessages = new ArrayList<String>();
        private StringBuilder sb = new StringBuilder();
        private boolean secondLine = false;
        private boolean start = true;

        private StringOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 13) {
                return;
            }
            if (b != 10) {
                if (this.secondLine) {
                    if (this.start) {
                        this.sb.append((char)b);
                    }
                    if (b == 44) {
                        this.start = true;
                    }
                }
            } else if (this.secondLine) {
                this.fMessages.add(LoggerTest.eventUnifyId(this.sb.toString()));
                this.sb = new StringBuilder();
                this.secondLine = false;
            } else {
                this.secondLine = true;
            }
        }

        public List<String> getMessages() {
            return this.fMessages;
        }
    }
}

