/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Cursor
extends Resource {
    private long handle;
    private static final int DEFAULT_ZOOM = 100;
    private HashMap<Integer, CursorHandle> zoomLevelToHandle = new HashMap();
    private final CursorHandleProvider cursorHandleProvider;

    public Cursor(Device device, int style) {
        super(device);
        this.cursorHandleProvider = new StyleCursorHandleProvider(style);
        this.handle = this.cursorHandleProvider.createHandle(this.device, 100).getHandle();
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        super(device);
        this.cursorHandleProvider = new ImageDataWithMaskCursorHandleProvider(source, mask, hotspotX, hotspotY);
        this.handle = this.cursorHandleProvider.createHandle(this.device, 100).getHandle();
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    private static CursorHandle setupCursorFromImageData(ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(4);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        source = ImageData.convertMask(source);
        byte[] sourceData = ImageData.convertPad(source.data, source.width, source.height, source.depth, source.scanlinePad, 2);
        byte[] maskData = ImageData.convertPad(mask.data, mask.width, mask.height, mask.depth, mask.scanlinePad, 2);
        long hInst = OS.GetModuleHandle(null);
        long handle = OS.CreateCursor(hInst, hotspotX, hotspotY, source.width, source.height, sourceData, maskData);
        if (handle == 0L) {
            SWT.error(2);
        }
        return new CustomCursorHandle(handle);
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        super(device);
        this.cursorHandleProvider = new ImageDataCursorHandleProvider(source, hotspotX, hotspotY);
        this.handle = this.cursorHandleProvider.createHandle(this.device, 100).getHandle();
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    private static CursorHandle setupCursorFromImageData(Device device, ImageData source, int hotspotX, int hotspotY) {
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        long hBitmap = 0L;
        long hMask = 0L;
        if (source.maskData == null && source.transparentPixel == -1 && (source.alpha != -1 || source.alphaData != null)) {
            PaletteData palette = source.palette;
            PaletteData newPalette = new PaletteData(65280, 0xFF0000, -16777216);
            ImageData img = new ImageData(source.width, source.height, 32, newPalette);
            if (palette.isDirect) {
                ImageData.blit(source.data, source.depth, source.bytesPerLine, source.getByteOrder(), source.width, source.height, palette.redMask, palette.greenMask, palette.blueMask, img.data, img.depth, img.bytesPerLine, img.getByteOrder(), img.width, img.height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                int i = 0;
                while (i < rgbs.length) {
                    RGB rgb = rgbs[i];
                    if (rgb != null) {
                        srcReds[i] = (byte)rgb.red;
                        srcGreens[i] = (byte)rgb.green;
                        srcBlues[i] = (byte)rgb.blue;
                    }
                    ++i;
                }
                ImageData.blit(source.width, source.height, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), srcReds, srcGreens, srcBlues, img.data, img.depth, img.bytesPerLine, img.getByteOrder(), newPalette.redMask, newPalette.greenMask, newPalette.blueMask);
            }
            hBitmap = Image.createDIB(source.width, source.height, 32);
            if (hBitmap == 0L) {
                SWT.error(2);
            }
            BITMAP dibBM = new BITMAP();
            OS.GetObject(hBitmap, BITMAP.sizeof, dibBM);
            byte[] srcData = img.data;
            if (source.alpha != -1) {
                int i = 3;
                while (i < srcData.length) {
                    srcData[i] = (byte)source.alpha;
                    i += 4;
                }
            } else if (source.alphaData != null) {
                int sp = 3;
                int ap = 0;
                while (sp < srcData.length) {
                    srcData[sp] = source.alphaData[ap];
                    sp += 4;
                    ++ap;
                }
            }
            OS.MoveMemory(dibBM.bmBits, srcData, srcData.length);
            hMask = OS.CreateBitmap(source.width, source.height, 1, 1, new byte[((source.width + 7) / 8 + 3) / 4 * 4 * source.height]);
            if (hMask == 0L) {
                SWT.error(2);
            }
        } else {
            ImageData mask = source.getTransparencyMask();
            long[] result = Image.initIcon(device, source, mask);
            hBitmap = result[0];
            hMask = result[1];
        }
        ICONINFO info = new ICONINFO();
        info.fIcon = false;
        info.hbmColor = hBitmap;
        info.hbmMask = hMask;
        info.xHotspot = hotspotX;
        info.yHotspot = hotspotY;
        long handle = OS.CreateIconIndirect(info);
        OS.DeleteObject(hBitmap);
        OS.DeleteObject(hMask);
        if (handle == 0L) {
            SWT.error(2);
        }
        return new IconCursorHandle(handle);
    }

    public Cursor(Device device, ImageDataProvider imageDataProvider, int hotspotX, int hotspotY) {
        super(device);
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        this.cursorHandleProvider = new ImageDataProviderCursorHandleProvider(imageDataProvider, hotspotX, hotspotY);
        this.handle = this.cursorHandleProvider.createHandle(this.device, 100).getHandle();
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public static Long win32_getHandle(Cursor cursor, int zoom) {
        if (cursor.isDisposed()) {
            return cursor.handle;
        }
        if (cursor.zoomLevelToHandle.get(zoom) != null) {
            return cursor.zoomLevelToHandle.get(zoom).getHandle();
        }
        CursorHandle handle = cursor.cursorHandleProvider.createHandle(cursor.device, zoom);
        cursor.setHandleForZoomLevel(handle, zoom);
        return cursor.zoomLevelToHandle.get(zoom).getHandle();
    }

    private void setHandleForZoomLevel(CursorHandle handle, Integer zoom) {
        if (this.handle == 0L) {
            this.handle = handle.getHandle();
        }
        if (zoom != null && !this.zoomLevelToHandle.containsKey(zoom)) {
            this.zoomLevelToHandle.put(zoom, handle);
        }
    }

    @Override
    void destroy() {
        this.device.deregisterResourceWithZoomSupport(this);
        this.destroyHandle();
    }

    private void destroyHandle() {
        for (CursorHandle handle : this.zoomLevelToHandle.values()) {
            handle.destroy();
        }
        this.zoomLevelToHandle.clear();
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    @Override
    void destroyHandlesExcept(Set<Integer> zoomLevels) {
        this.zoomLevelToHandle.entrySet().removeIf(entry -> {
            Integer zoom = (Integer)entry.getKey();
            if (!zoomLevels.contains(zoom) && zoom != DPIUtil.getZoomForAutoscaleProperty(100)) {
                ((CursorHandle)entry.getValue()).destroy();
                return true;
            }
            return false;
        });
    }

    private static abstract class CursorHandle {
        private final long handle;

        public CursorHandle(long handle) {
            this.handle = handle;
        }

        long getHandle() {
            return this.handle;
        }

        abstract void destroy();
    }

    private static interface CursorHandleProvider {
        public CursorHandle createHandle(Device var1, int var2);
    }

    private static class CustomCursorHandle
    extends CursorHandle {
        public CustomCursorHandle(long handle) {
            super(handle);
        }

        @Override
        void destroy() {
            OS.DestroyCursor(this.getHandle());
        }
    }

    private static abstract class HotspotAwareCursorHandleProvider
    implements CursorHandleProvider {
        private final int hotspotX;
        private final int hotspotY;

        public HotspotAwareCursorHandleProvider(int hotspotX, int hotspotY) {
            this.hotspotX = hotspotX;
            this.hotspotY = hotspotY;
        }

        protected final int getHotpotXInPixels(int zoom) {
            return Win32DPIUtils.pointToPixel(this.hotspotX, zoom);
        }

        protected final int getHotpotYInPixels(int zoom) {
            return Win32DPIUtils.pointToPixel(this.hotspotY, zoom);
        }
    }

    private static class IconCursorHandle
    extends CursorHandle {
        public IconCursorHandle(long handle) {
            super(handle);
        }

        @Override
        void destroy() {
            OS.DestroyIcon(this.getHandle());
        }
    }

    private static class ImageDataCursorHandleProvider
    extends HotspotAwareCursorHandleProvider {
        protected final ImageData source;

        public ImageDataCursorHandleProvider(ImageData source, int hotspotX, int hotspotY) {
            super(hotspotX, hotspotY);
            this.source = source;
        }

        @Override
        public CursorHandle createHandle(Device device, int zoom) {
            ImageData scaledSource = DPIUtil.scaleImageData(device, this.source, zoom, 100);
            return Cursor.setupCursorFromImageData(device, scaledSource, this.getHotpotXInPixels(zoom), this.getHotpotYInPixels(zoom));
        }
    }

    private static class ImageDataProviderCursorHandleProvider
    extends HotspotAwareCursorHandleProvider {
        private final ImageDataProvider provider;

        public ImageDataProviderCursorHandleProvider(ImageDataProvider provider, int hotspotX, int hotspotY) {
            super(hotspotX, hotspotY);
            this.provider = provider;
        }

        @Override
        public CursorHandle createHandle(Device device, int zoom) {
            ImageData source;
            if (zoom == 100) {
                source = this.provider.getImageData(100);
            } else {
                Image tempImage = new Image(device, this.provider);
                source = tempImage.getImageData(zoom);
                tempImage.dispose();
            }
            return Cursor.setupCursorFromImageData(device, source, this.getHotpotXInPixels(zoom), this.getHotpotYInPixels(zoom));
        }
    }

    private static class ImageDataWithMaskCursorHandleProvider
    extends ImageDataCursorHandleProvider {
        private final ImageData mask;

        public ImageDataWithMaskCursorHandleProvider(ImageData source, ImageData mask, int hotspotX, int hotspotY) {
            super(source, hotspotX, hotspotY);
            this.mask = mask;
        }

        @Override
        public CursorHandle createHandle(Device device, int zoom) {
            ImageData scaledSource = DPIUtil.scaleImageData(device, this.source, zoom, 100);
            ImageData scaledMask = this.mask != null ? DPIUtil.scaleImageData(device, this.mask, zoom, 100) : null;
            return Cursor.setupCursorFromImageData(scaledSource, scaledMask, this.getHotpotXInPixels(zoom), this.getHotpotYInPixels(zoom));
        }
    }

    private static class StyleCursorHandleProvider
    implements CursorHandleProvider {
        private final int style;

        public StyleCursorHandleProvider(int style) {
            this.style = style;
        }

        @Override
        public CursorHandle createHandle(Device device, int zoom) {
            return StyleCursorHandleProvider.setupCursorFromStyle(this.style);
        }

        private static final CursorHandle setupCursorFromStyle(int style) {
            long lpCursorName = 0L;
            switch (style) {
                case 21: {
                    lpCursorName = 32649L;
                    break;
                }
                case 0: {
                    lpCursorName = 32512L;
                    break;
                }
                case 1: {
                    lpCursorName = 32514L;
                    break;
                }
                case 2: {
                    lpCursorName = 32515L;
                    break;
                }
                case 3: {
                    lpCursorName = 32650L;
                    break;
                }
                case 4: {
                    lpCursorName = 32651L;
                    break;
                }
                case 5: {
                    lpCursorName = 32646L;
                    break;
                }
                case 6: {
                    lpCursorName = 32643L;
                    break;
                }
                case 7: {
                    lpCursorName = 32645L;
                    break;
                }
                case 8: {
                    lpCursorName = 32642L;
                    break;
                }
                case 9: {
                    lpCursorName = 32644L;
                    break;
                }
                case 10: {
                    lpCursorName = 32645L;
                    break;
                }
                case 11: {
                    lpCursorName = 32645L;
                    break;
                }
                case 12: {
                    lpCursorName = 32644L;
                    break;
                }
                case 13: {
                    lpCursorName = 32644L;
                    break;
                }
                case 14: {
                    lpCursorName = 32643L;
                    break;
                }
                case 15: {
                    lpCursorName = 32642L;
                    break;
                }
                case 16: {
                    lpCursorName = 32643L;
                    break;
                }
                case 17: {
                    lpCursorName = 32642L;
                    break;
                }
                case 18: {
                    lpCursorName = 32516L;
                    break;
                }
                case 19: {
                    lpCursorName = 32513L;
                    break;
                }
                case 20: {
                    lpCursorName = 32648L;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            long handle = OS.LoadCursor(0L, lpCursorName);
            if (handle == 0L) {
                SWT.error(2);
            }
            return new CustomCursorHandle(handle);
        }
    }
}

