/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.trace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelUtils;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.lttng2.common.core.trace.ILttngTrace;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.ContextPidAspect;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.ContextTidAspect;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.Lttng26EventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.Lttng27EventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.Lttng28EventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.Lttng29EventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.LttngEventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.PerfEventLayout;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventType;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfUtils;

public class LttngKernelTrace
extends CtfTmfTrace
implements IKernelTrace,
ILttngTrace {
    private static final @NonNull Collection<ITmfEventAspect<?>> LTTNG_KERNEL_ASPECTS;
    private static final int CONFIDENCE = 100;
    private OriginTracer fOriginTracer = null;
    private @NonNull Collection<ITmfEventAspect<?>> fAspects = ImmutableSet.copyOf(LTTNG_KERNEL_ASPECTS);

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)CtfTmfTrace.CTF_ASPECTS);
        builder.addAll((Iterable)KernelUtils.getKernelAspects());
        LTTNG_KERNEL_ASPECTS = builder.build();
    }

    public @NonNull IKernelAnalysisEventLayout getKernelEventLayout() {
        OriginTracer tracer = this.fOriginTracer;
        if (tracer == null) {
            throw new IllegalStateException("Cannot get the layout of a non-initialized trace!");
        }
        return tracer.fLayout;
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        ContextTidAspect tidAspect;
        super.initTrace(resource, path, eventType);
        this.fOriginTracer = this.getTracerFromEnv();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(LTTNG_KERNEL_ASPECTS);
        builder.addAll((Iterable)this.createCounterAspects((ITmfTraceWithPreDefinedEvents)this));
        ContextPidAspect pidAspect = ContextPidAspect.getAspect(this);
        if (pidAspect != null) {
            builder.add((Object)pidAspect);
        }
        if ((tidAspect = ContextTidAspect.getAspect(this)) != null) {
            builder.add((Object)tidAspect);
        }
        this.fAspects = builder.build();
    }

    private OriginTracer getTracerFromEnv() {
        String tracerName = CtfUtils.getTracerName((CtfTmfTrace)this);
        int tracerMajor = CtfUtils.getTracerMajorVersion((CtfTmfTrace)this);
        int tracerMinor = CtfUtils.getTracerMinorVersion((CtfTmfTrace)this);
        if ("perf".equals(tracerName)) {
            return OriginTracer.PERF;
        }
        if ("lttng-modules".equals(tracerName) && tracerMajor >= 2) {
            if (tracerMinor >= 9) {
                return OriginTracer.LTTNG29;
            }
            if (tracerMinor >= 8) {
                return OriginTracer.LTTNG28;
            }
            if (tracerMinor >= 7) {
                return OriginTracer.LTTNG27;
            }
            if (tracerMinor >= 6) {
                return OriginTracer.LTTNG26;
            }
        }
        return OriginTracer.LTTNG;
    }

    public IStatus validate(IProject project, String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            Map environment = ((CtfTraceValidationStatus)status).getEnvironment();
            String domain = (String)environment.get("domain");
            if (domain == null || !domain.equals("\"kernel\"")) {
                return new Status(4, "org.eclipse.tracecompass.lttng2.kernel.core", Messages.LttngKernelTrace_DomainError);
            }
            return new TraceValidationStatus(100, "org.eclipse.tracecompass.lttng2.kernel.core");
        }
        return status;
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return this.fAspects;
    }

    public @NonNull Set<@NonNull CtfTmfEventType> getContainedEventTypes() {
        return super.getContainedEventTypes();
    }

    private static enum OriginTracer {
        LTTNG(LttngEventLayout.getInstance()),
        LTTNG26(Lttng26EventLayout.getInstance()),
        LTTNG27(Lttng27EventLayout.getInstance()),
        LTTNG28(Lttng28EventLayout.getInstance()),
        LTTNG29(Lttng29EventLayout.getInstance()),
        PERF(PerfEventLayout.getInstance());

        private final @NonNull IKernelAnalysisEventLayout fLayout;

        private OriginTracer(IKernelAnalysisEventLayout layout) {
            this.fLayout = layout;
        }
    }
}

