/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.ui.project.handlers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.OpenDebugConfigurations;
import org.eclipse.debug.internal.ui.actions.OpenRunConfigurations;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LaunchAsEaseScriptHandler
extends AbstractHandler {
    private static final String TYPE_PARAMETER = "org.eclipse.tracecompass.incubator.scripting.ui.commandparameter.launch_as_ease_script.type";
    private static final String MODE_PARAMETER = "org.eclipse.tracecompass.incubator.scripting.ui.commandparameter.launch_as_ease_script.mode";
    private @Nullable TreeSelection fSelection = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fSelection = null;
        if (selection instanceof TreeSelection) {
            this.fSelection = (TreeSelection)selection;
            for (Object element : this.fSelection) {
                if (element instanceof TmfCommonProjectElement || element instanceof IFile) continue;
                return false;
            }
        }
        return !selection.isEmpty();
    }

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        TreeSelection selection = this.fSelection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null || event == null || selection == null) {
            return null;
        }
        List allShortCuts = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchShortcuts();
        if (allShortCuts == null) {
            return null;
        }
        block0: for (Object element : selection.toList()) {
            IFile resource = null;
            if (element instanceof IFile) {
                resource = (IFile)element;
            } else if (element instanceof TmfCommonProjectElement) {
                TmfCommonProjectElement trace = (TmfCommonProjectElement)element;
                if (trace instanceof TmfTraceElement) {
                    trace = ((TmfTraceElement)trace).getElementUnderTraceFolder();
                }
                resource = trace.getResource();
            }
            String type = event.getParameter(TYPE_PARAMETER);
            String mode = event.getParameter(MODE_PARAMETER);
            if (resource == null) continue;
            StructuredSelection s = new StructuredSelection(Arrays.asList(resource));
            if (type.equals("org.eclipse.tracecompass.incubator.scripting.ui.launch-dialog")) {
                OpenRunConfigurations r;
                if (mode.equals("run")) {
                    r = new OpenRunConfigurations();
                    r.run(null);
                }
                if (!mode.equals("debug")) continue;
                r = new OpenDebugConfigurations();
                r.run(null);
                continue;
            }
            for (LaunchShortcutExtension launchShortcutExtension : allShortCuts) {
                if (!type.equals(launchShortcutExtension.getId())) continue;
                launchShortcutExtension.launch((ISelection)s, mode);
                continue block0;
            }
        }
        return null;
    }
}

