/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.parser;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SuperReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredType;
import org.eclipse.wst.jsdt.internal.compiler.parser.TerminalTokens;

public class RecoveredMethod
extends RecoveredElement
implements TerminalTokens {
    public AbstractMethodDeclaration methodDeclaration;
    public RecoveredType[] localTypes;
    public int localTypeCount;
    public RecoveredBlock methodBody;
    public boolean discardBody = true;

    public RecoveredMethod(AbstractMethodDeclaration methodDeclaration, RecoveredElement parent, int bracketBalance, Parser parser) {
        super(parent, bracketBalance, parser);
        this.methodDeclaration = methodDeclaration;
        boolean bl = this.foundOpeningBrace = !this.bodyStartsAtHeaderEnd();
        if (this.foundOpeningBrace) {
            ++this.bracketBalance;
        }
    }

    @Override
    public RecoveredElement add(Block nestedBlockDeclaration, int bracketBalanceValue) {
        if (this.methodDeclaration.declarationSourceEnd > 0 && nestedBlockDeclaration.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(nestedBlockDeclaration, bracketBalanceValue);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        this.methodBody = new RecoveredBlock(nestedBlockDeclaration, (RecoveredElement)this, bracketBalanceValue);
        if (nestedBlockDeclaration.sourceEnd == 0) {
            return this.methodBody;
        }
        return this;
    }

    @Override
    public RecoveredElement add(FieldDeclaration fieldDeclaration, int bracketBalanceValue) {
        char[][] fieldTypeName;
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (fieldTypeName = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(fieldTypeName[0], TypeBinding.VOID.sourceName())) {
            if (this.parent == null) {
                return this;
            }
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, bracketBalanceValue);
        }
        if (this.methodDeclaration.declarationSourceEnd > 0 && fieldDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(fieldDeclaration, bracketBalanceValue);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return this;
    }

    @Override
    public RecoveredElement add(LocalDeclaration localDeclaration, int bracketBalanceValue) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && localDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(localDeclaration, bracketBalanceValue);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement currentBlock = this.add(block, 1);
            if (this.bracketBalance > 0) {
                int i = 0;
                while (i < this.bracketBalance - 1) {
                    currentBlock = currentBlock.add(new Block(0), 1);
                    ++i;
                }
                this.bracketBalance = 1;
            }
            return currentBlock.add(localDeclaration, bracketBalanceValue);
        }
        return this.methodBody.add(localDeclaration, bracketBalanceValue, true);
    }

    @Override
    public RecoveredElement add(Statement statement, int bracketBalanceValue) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && statement.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(statement, bracketBalanceValue);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement currentBlock = this.add(block, 1);
            if (this.bracketBalance > 0) {
                int i = 0;
                while (i < this.bracketBalance - 1) {
                    currentBlock = currentBlock.add(new Block(0), 1);
                    ++i;
                }
                this.bracketBalance = 1;
            }
            return currentBlock.add(statement, bracketBalanceValue);
        }
        return this.methodBody.add(statement, bracketBalanceValue, true);
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int bracketBalanceValue) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(typeDeclaration, bracketBalanceValue);
        }
        if ((typeDeclaration.bits & 0x100) != 0 || this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated) {
            if (this.methodBody == null) {
                Block block = new Block(0);
                block.sourceStart = this.methodDeclaration.bodyStart;
                this.add(block, 1);
            }
            return this.methodBody.add(typeDeclaration, bracketBalanceValue, true);
        }
        if (this.localTypes == null) {
            this.localTypes = new RecoveredType[5];
            this.localTypeCount = 0;
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new RecoveredType[2 * this.localTypeCount];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        RecoveredType element = new RecoveredType(typeDeclaration, (RecoveredElement)this, bracketBalanceValue);
        this.localTypes[this.localTypeCount++] = element;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return element;
    }

    public boolean bodyStartsAtHeaderEnd() {
        return this.methodDeclaration.bodyStart == this.methodDeclaration.sourceEnd + 1;
    }

    @Override
    public ASTNode parseTree() {
        return this.methodDeclaration;
    }

    @Override
    public int sourceEnd() {
        return this.methodDeclaration.declarationSourceEnd;
    }

    @Override
    public String toString(int tab) {
        StringBuffer result = new StringBuffer(this.tabString(tab));
        result.append("Recovered method:\n");
        this.methodDeclaration.print(tab + 1, result);
        if (this.localTypes != null) {
            int i = 0;
            while (i < this.localTypeCount) {
                result.append("\n");
                result.append(this.localTypes[i].toString(tab + 1));
                ++i;
            }
        }
        if (this.methodBody != null) {
            result.append("\n");
            result.append(this.methodBody.toString(tab + 1));
        }
        return result.toString();
    }

    @Override
    public void updateBodyStart(int bodyStart) {
        this.foundOpeningBrace = true;
        this.methodDeclaration.bodyStart = bodyStart;
    }

    public AbstractMethodDeclaration updatedMethodDeclaration() {
        Block block;
        if (this.methodBody != null && (block = this.methodBody.updatedBlock()) != null) {
            this.methodDeclaration.statements = block.statements;
            if (this.methodDeclaration.isConstructor()) {
                ConstructorDeclaration constructor = (ConstructorDeclaration)this.methodDeclaration;
                if (this.methodDeclaration.statements != null && this.methodDeclaration.statements[0] instanceof ExplicitConstructorCall) {
                    constructor.constructorCall = (ExplicitConstructorCall)this.methodDeclaration.statements[0];
                    int length = this.methodDeclaration.statements.length;
                    this.methodDeclaration.statements = new Statement[length - 1];
                    System.arraycopy(this.methodDeclaration.statements, 1, this.methodDeclaration.statements, 0, length - 1);
                }
                if (constructor.constructorCall == null) {
                    constructor.constructorCall = SuperReference.implicitSuperConstructorCall();
                }
            }
        }
        if (this.localTypeCount > 0) {
            this.methodDeclaration.bits |= 2;
        }
        return this.methodDeclaration;
    }

    @Override
    public void updateFromParserState() {
        if (this.bodyStartsAtHeaderEnd() && this.parent != null) {
            Parser parser = this.parser();
            if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                if (this.methodDeclaration.sourceEnd == parser.rParenPos) {
                    boolean canConsume;
                    int length = parser.astLengthStack[parser.astLengthPtr];
                    int astPtr = parser.astPtr - length;
                    boolean bl = canConsume = astPtr >= 0;
                    if (canConsume) {
                        if (!(parser.astStack[astPtr] instanceof AbstractMethodDeclaration)) {
                            canConsume = false;
                        }
                        int i = 1;
                        int max = length + 1;
                        while (i < max) {
                            if (!(parser.astStack[astPtr + i] instanceof TypeReference)) {
                                canConsume = false;
                            }
                            ++i;
                        }
                    }
                    if (!canConsume) {
                        parser.listLength = 0;
                    }
                } else {
                    if (parser.currentToken == 8 || parser.currentToken == 24) {
                        int n = parser.astLengthPtr;
                        parser.astLengthStack[n] = parser.astLengthStack[n] - 1;
                        --parser.astPtr;
                        --parser.listLength;
                        parser.currentToken = 0;
                    }
                    int argLength = parser.astLengthStack[parser.astLengthPtr];
                    int argStart = parser.astPtr - argLength + 1;
                    boolean needUpdateRParenPos = parser.rParenPos < parser.lParenPos;
                    int count = 0;
                    while (count < argLength) {
                        ASTNode aNode = parser.astStack[argStart + count];
                        if (aNode instanceof Argument) {
                            Object argTypeName;
                            Argument argument = (Argument)aNode;
                            Object object = argTypeName = argument.type != null ? (Object)argument.type.getTypeName() : new char[][]{};
                            if ((argument.modifiers & 0xFFFFFFEF) != 0 || ((char[][])argTypeName).length == 1 && CharOperation.equals(argTypeName[0], TypeBinding.VOID.sourceName())) {
                                parser.astLengthStack[parser.astLengthPtr] = count;
                                parser.astPtr = argStart + count - 1;
                                parser.listLength = count;
                                parser.currentToken = 0;
                                break;
                            }
                            if (needUpdateRParenPos) {
                                parser.rParenPos = argument.sourceEnd + 1;
                            }
                        } else {
                            parser.astLengthStack[parser.astLengthPtr] = count;
                            parser.astPtr = argStart + count - 1;
                            parser.listLength = count;
                            parser.currentToken = 0;
                            break;
                        }
                        ++count;
                    }
                    if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                        boolean canConsume;
                        int length = parser.astLengthStack[parser.astLengthPtr];
                        int astPtr = parser.astPtr - length;
                        boolean bl = canConsume = astPtr >= 0;
                        if (canConsume) {
                            if (!(parser.astStack[astPtr] instanceof AbstractMethodDeclaration)) {
                                canConsume = false;
                            }
                            int i = 1;
                            int max = length + 1;
                            while (i < max) {
                                if (!(parser.astStack[astPtr + i] instanceof Argument)) {
                                    canConsume = false;
                                }
                                ++i;
                            }
                        }
                        if (canConsume) {
                            parser.consumeMethodHeaderRightParen();
                            if (parser.currentElement == this) {
                                this.methodDeclaration.sourceEnd = this.methodDeclaration.arguments[this.methodDeclaration.arguments.length - 1].sourceEnd;
                                parser.lastCheckPoint = this.methodDeclaration.bodyStart = this.methodDeclaration.sourceEnd + 1;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        RecoveredElement recoveredElement = super.updateOnClosingBrace(braceStart, braceEnd);
        if (recoveredElement != this) {
            this.parser().recoverAST(this);
        }
        return recoveredElement;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int braceStart, int braceEnd) {
        if (this.bracketBalance == 0) {
            switch (this.parser().lastIgnoredToken) {
                case -1: 
                case 116: {
                    break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        return super.updateOnOpeningBrace(braceStart, braceEnd);
    }

    @Override
    public void updateParseTree() {
        this.updatedMethodDeclaration();
    }

    @Override
    public void updateSourceEndIfNecessary(int braceStart, int braceEnd) {
        if (this.methodDeclaration.declarationSourceEnd == 0) {
            if (this.parser().rBraceSuccessorStart >= braceEnd) {
                this.methodDeclaration.declarationSourceEnd = this.parser().rBraceEnd;
                this.methodDeclaration.bodyEnd = this.parser().rBraceStart;
            } else {
                this.methodDeclaration.declarationSourceEnd = braceEnd;
                this.methodDeclaration.bodyEnd = braceStart - 1;
            }
        }
    }

    @Override
    public ProgramElement updatedASTNode() {
        return this.updatedMethodDeclaration();
    }
}

