/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.criticalpath;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.IDataPalette;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.OSCriticalPathPalette;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.QualitativePaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;

public class CriticalPathAggregatedPalette
implements IDataPalette {
    private static final int NUM_COLORS = 8;
    private static final String DEFAULT_PREFIX = "process";
    private static final Map<String, OutputElementStyle> STYLES;
    private static final Map<String, OutputElementStyle> STYLE_MAP;
    private static @Nullable CriticalPathAggregatedPalette fInstance;

    static {
        STYLE_MAP = Collections.synchronizedMap(new HashMap());
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.putAll(OSCriticalPathPalette.getStyles());
        QualitativePaletteProvider palette = new QualitativePaletteProvider.Builder().setNbColors(8).build();
        int i = 0;
        for (RGBAColor color : palette.get()) {
            builder.put((Object)(DEFAULT_PREFIX + String.valueOf(i)), (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)(DEFAULT_PREFIX + String.valueOf(i)), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()), (Object)"opacity", (Object)Float.valueOf((float)color.getAlpha() / 255.0f))));
            ++i;
        }
        STYLES = builder.build();
        fInstance = null;
    }

    private CriticalPathAggregatedPalette() {
    }

    public static CriticalPathAggregatedPalette getInstance() {
        CriticalPathAggregatedPalette instance = fInstance;
        if (instance == null) {
            fInstance = instance = new CriticalPathAggregatedPalette();
        }
        return instance;
    }

    public OutputElementStyle getStyleFor(Object object) {
        if (object instanceof WeightedTree) {
            WeightedTree tree = (WeightedTree)object;
            Object treeObject = tree.getObject();
            if (treeObject instanceof OSEdgeContextState.OSEdgeContextEnum) {
                return STYLE_MAP.computeIfAbsent(((OSEdgeContextState.OSEdgeContextEnum)treeObject).name(), OutputElementStyle::new);
            }
            return STYLE_MAP.computeIfAbsent(DEFAULT_PREFIX + String.valueOf(Math.floorMod(treeObject.hashCode(), 8)), OutputElementStyle::new);
        }
        return STYLE_MAP.computeIfAbsent(DEFAULT_PREFIX + String.valueOf(Math.floorMod(object.hashCode(), 8)), OutputElementStyle::new);
    }

    public Map<String, OutputElementStyle> getStyles() {
        return STYLES;
    }
}

