/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.internal.views.log.AbstractEntry;
import org.eclipse.ui.internal.views.log.LogSession;
import org.eclipse.ui.internal.views.log.Messages;

public class LogEntry
extends AbstractEntry {
    public static final String SPACE = " ";
    public static final String F_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateTimeFormatter GREGORIAN_SDF = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH).withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter LOCAL_SDF = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    private String pluginId;
    private int severity;
    private int code;
    private String fDateString;
    private Date fDate;
    private String message;
    private String stack;
    private LogSession session;

    public LogEntry() {
    }

    public LogEntry(IStatus status) {
        this(status, null);
    }

    public LogEntry(IStatus status, LogSession session) {
        this.processStatus(status, session);
    }

    public LogSession getSession() {
        if (this.session == null && this.parent != null && this.parent instanceof LogEntry) {
            return ((LogEntry)((Object)this.parent)).getSession();
        }
        return this.session;
    }

    void setSession(LogSession session) {
        this.session = session;
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    public int getCode() {
        return this.code;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStack() {
        return this.stack;
    }

    public String getFormattedDate() {
        if (this.fDateString == null) {
            this.fDateString = LOCAL_SDF.format(this.getDate().toInstant());
        }
        return this.fDateString;
    }

    public Date getDate() {
        if (this.fDate == null) {
            this.fDate = new Date(0L);
        }
        return this.fDate;
    }

    public String getSeverityText() {
        switch (this.severity) {
            case 4: {
                return Messages.LogView_severity_error;
            }
            case 2: {
                return Messages.LogView_severity_warning;
            }
            case 1: {
                return Messages.LogView_severity_info;
            }
            case 0: {
                return Messages.LogView_severity_ok;
            }
        }
        return "?";
    }

    public String toString() {
        return this.getSeverityText();
    }

    @Override
    public String getLabel(Object obj) {
        return this.getSeverityText();
    }

    public void processEntry(String line) throws IllegalArgumentException {
        StringTokenizer stok = new StringTokenizer(line, SPACE);
        this.severity = 0;
        this.code = 0;
        StringBuilder dateBuffer = new StringBuilder();
        int tokens = stok.countTokens();
        String token = null;
        int i = 0;
        while (i < tokens) {
            token = stok.nextToken();
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    this.pluginId = token;
                    break;
                }
                case 2: {
                    try {
                        this.severity = Integer.parseInt(token);
                    }
                    catch (NumberFormatException nfe) {
                        this.appendToken(dateBuffer, token);
                    }
                    break;
                }
                case 3: {
                    try {
                        this.code = Integer.parseInt(token);
                    }
                    catch (NumberFormatException nfe) {
                        this.appendToken(dateBuffer, token);
                    }
                    break;
                }
                default: {
                    this.appendToken(dateBuffer, token);
                }
            }
            ++i;
        }
        String stringToParse = dateBuffer.toString();
        try {
            Date date = Date.from(Instant.from(GREGORIAN_SDF.parse(stringToParse)));
            if (date != null) {
                this.fDate = date;
                this.fDateString = LOCAL_SDF.format(this.fDate.toInstant());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse '" + String.valueOf(dateBuffer) + "'", e);
        }
    }

    void appendToken(StringBuilder buffer, String token) {
        if (buffer.length() > 0) {
            buffer.append(SPACE);
        }
        buffer.append(token);
    }

    public int processSubEntry(String line) throws IllegalArgumentException {
        StringTokenizer stok = new StringTokenizer(line, SPACE);
        StringBuilder dateBuffer = new StringBuilder();
        int depth = 0;
        String token = null;
        int tokens = stok.countTokens();
        int i = 0;
        while (i < tokens) {
            token = stok.nextToken();
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    try {
                        depth = Integer.parseInt(token);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Failed to parse '" + token + "'", e);
                    }
                }
                case 2: {
                    this.pluginId = token;
                    break;
                }
                case 3: {
                    try {
                        this.severity = Integer.parseInt(token);
                    }
                    catch (NumberFormatException nfe) {
                        this.appendToken(dateBuffer, token);
                    }
                    break;
                }
                case 4: {
                    try {
                        this.code = Integer.parseInt(token);
                    }
                    catch (NumberFormatException nfe) {
                        this.appendToken(dateBuffer, token);
                    }
                    break;
                }
                default: {
                    this.appendToken(dateBuffer, token);
                }
            }
            ++i;
        }
        try {
            Date date = Date.from(Instant.from(GREGORIAN_SDF.parse(dateBuffer.toString())));
            if (date != null) {
                this.fDate = date;
                this.fDateString = LOCAL_SDF.format(this.fDate.toInstant());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse '" + String.valueOf(dateBuffer) + "'", e);
        }
        return depth;
    }

    void setStack(String stack) {
        this.stack = stack;
    }

    void setMessage(String message) {
        this.message = message;
    }

    private void processStatus(IStatus status, LogSession session) {
        IStatus[] schildren;
        this.pluginId = status.getPlugin();
        this.severity = status.getSeverity();
        this.code = status.getCode();
        this.fDate = new Date();
        this.fDateString = LOCAL_SDF.format(this.fDate.toInstant());
        this.message = status.getMessage();
        this.session = session;
        Throwable throwable = status.getException();
        if (throwable != null) {
            StringWriter swriter = new StringWriter();
            Throwable throwable2 = null;
            Object var6_7 = null;
            try (PrintWriter pwriter = new PrintWriter(swriter);){
                throwable.printStackTrace(pwriter);
                pwriter.flush();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            this.stack = swriter.toString();
        }
        if ((schildren = status.getChildren()).length > 0) {
            IStatus[] iStatusArray = schildren;
            int n = schildren.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                this.addChild(new LogEntry(element, session));
                ++n2;
            }
        }
    }

    @Override
    public void write(PrintWriter writer) {
        if (this.session != null) {
            writer.println(this.session.getSessionData());
        }
        writer.println(this.pluginId);
        writer.println(this.getSeverityText());
        if (this.fDate != null) {
            writer.println(this.getDate());
        }
        if (this.message != null) {
            writer.println(this.getMessage());
        }
        if (this.stack != null) {
            writer.println();
            writer.println(this.stack);
        }
    }
}

