/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.preferences;

import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.tests.core.RSECoreTestCase;
import org.eclipse.rse.ui.SystemPreferencesManager;

public class PreferencesTest
extends RSECoreTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testActiveProfiles() {
        if (this.isTestDisabled()) {
            return;
        }
        RSEPreferencesManager.addActiveProfile((String)"bogus01");
        RSEPreferencesManager.addActiveProfile((String)"bogus02");
        String[] profiles = RSEPreferencesManager.getActiveProfiles();
        PreferencesTest.assertTrue((profiles.length >= 2 ? 1 : 0) != 0);
        PreferencesTest.assertEquals((String)"bogus02", (String)profiles[RSEPreferencesManager.getActiveProfilePosition((String)"bogus02")]);
        PreferencesTest.assertEquals((String)"bogus01", (String)profiles[RSEPreferencesManager.getActiveProfilePosition((String)"bogus01")]);
        RSEPreferencesManager.renameActiveProfile((String)"bogus02", (String)"bogus99");
        profiles = RSEPreferencesManager.getActiveProfiles();
        PreferencesTest.assertEquals((String)"bogus99", (String)profiles[RSEPreferencesManager.getActiveProfilePosition((String)"bogus99")]);
        RSEPreferencesManager.deleteActiveProfile((String)"bogus01");
        RSEPreferencesManager.deleteActiveProfile((String)"bogus99");
        PreferencesTest.assertEquals((int)-1, (int)RSEPreferencesManager.getActiveProfilePosition((String)"bogus02"));
        PreferencesTest.assertEquals((int)-1, (int)RSEPreferencesManager.getActiveProfilePosition((String)"bogus01"));
        PreferencesTest.assertEquals((int)-1, (int)RSEPreferencesManager.getActiveProfilePosition((String)"bogus99"));
    }

    public void testUserIds() {
        if (this.isTestDisabled()) {
            return;
        }
        RSEPreferencesManager.setUserId((String)"a.b.c", (String)"bogusUser");
        PreferencesTest.assertEquals((String)"bogusUser", (String)RSEPreferencesManager.getUserId((String)"a.b.c"));
        RSEPreferencesManager.clearUserId((String)"a.b.c");
        PreferencesTest.assertNull((Object)RSEPreferencesManager.getUserId((String)"a.b.c"));
    }

    public void testDefaultUserIds() {
        if (this.isTestDisabled()) {
            return;
        }
        IRSECoreRegistry registry = RSECorePlugin.getTheCoreRegistry();
        IRSESystemType systemTypeDeprecated = registry.getSystemType("Local");
        IRSESystemType systemType = registry.getSystemTypeById("org.eclipse.rse.systemtype.local");
        PreferencesTest.assertEquals((Object)systemType, (Object)systemTypeDeprecated);
        String oldValue = RSEPreferencesManager.getDefaultUserId((IRSESystemType)systemType);
        RSEPreferencesManager.setDefaultUserId((IRSESystemType)systemType, (String)"bogus1");
        PreferencesTest.assertEquals((String)"bogus1", (String)RSEPreferencesManager.getDefaultUserId((IRSESystemType)systemType));
        IRSESystemType localType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.local");
        RSEPreferencesManager.setDefaultUserId((IRSESystemType)localType, (String)"bogus2");
        PreferencesTest.assertEquals((String)"bogus2", (String)RSEPreferencesManager.getDefaultUserId((IRSESystemType)systemType));
        RSEPreferencesManager.setDefaultUserId((IRSESystemType)systemType, (String)oldValue);
        PreferencesTest.assertEquals((String)oldValue, (String)RSEPreferencesManager.getDefaultUserId((IRSESystemType)systemType));
    }

    public void testShowLocalConnection() {
        if (this.isTestDisabled()) {
            return;
        }
        PreferencesTest.assertTrue((boolean)SystemPreferencesManager.getShowLocalConnection());
    }
}

