/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.local;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.connectorservice.local.LocalConnectorService;
import org.eclipse.rse.internal.connectorservice.local.LocalConnectorServiceManager;
import org.eclipse.rse.internal.services.local.ILocalService;
import org.eclipse.rse.internal.services.local.shells.LocalShellService;
import org.eclipse.rse.internal.subsystems.shells.local.model.LocalServiceCommandShell;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IServiceCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystemConfiguration;

public class LocalShellSubSystemConfiguration
extends ShellServiceSubSystemConfiguration {
    public String getCommandSeparator() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("win")) {
            return "&";
        }
        return ";";
    }

    public boolean isFactoryFor(Class subSystemType) {
        boolean isFor = ShellServiceSubSystem.class.equals((Object)subSystemType);
        return isFor;
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        LocalConnectorService connectorService = (LocalConnectorService)this.getConnectorService(host);
        ShellServiceSubSystem subsys = new ShellServiceSubSystem(host, (IConnectorService)connectorService, this.getShellService(host));
        return subsys;
    }

    public boolean supportsFilters() {
        return false;
    }

    public boolean supportsSubSystemConnect() {
        return false;
    }

    public IConnectorService getConnectorService(IHost host) {
        return LocalConnectorServiceManager.getInstance().getConnectorService(host, this.getServiceImplType());
    }

    public IShellService createShellService(IHost host) {
        return new LocalShellService();
    }

    public boolean supportsCommands() {
        return true;
    }

    public boolean canRunCommand() {
        return true;
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        LocalConnectorServiceManager.getInstance().setConnectorService(host, this.getServiceImplType(), connectorService);
    }

    public Class getServiceImplType() {
        return ILocalService.class;
    }

    public IServiceCommandShell createRemoteCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        return new LocalServiceCommandShell(cmdSS, hostShell);
    }
}

