/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseCopyAction;
import org.eclipse.rse.ui.dialogs.SystemRenameSingleDialog;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.filters.SystemFilterUIHelpers;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.swt.widgets.Shell;

public class SystemFilterCopyFilterAction
extends SystemBaseCopyAction {
    private String promptString = null;
    private SystemSimpleContentElement initialSelectionElement = null;
    private SystemSimpleContentElement root = null;

    public SystemFilterCopyFilterAction(Shell parent) {
        super(parent, SystemResources.ACTION_COPY_FILTER_LABEL, 0);
        this.setToolTipText(SystemResources.ACTION_COPY_FILTER_TOOLTIP);
        this.promptString = SystemResources.RESID_COPY_PROMPT;
    }

    protected void reset() {
        super.reset();
        this.initialSelectionElement = null;
        this.root = null;
    }

    public void setHelpContextId(String id) {
        this.setHelp(id);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            Object selectedObject = e.next();
            if (selectedObject instanceof SystemSimpleContentElement) {
                selectedObject = ((SystemSimpleContentElement)selectedObject).getData();
            }
            if (this.checkObjectType(selectedObject)) continue;
            enable = false;
        }
        return enable;
    }

    public boolean checkObjectType(Object selectedObject) {
        if (selectedObject instanceof ISystemFilter) {
            ISystemFilter fs = (ISystemFilter)selectedObject;
            return !fs.isNonChangable();
        }
        if (selectedObject instanceof ISystemFilterReference) {
            ISystemFilter fs = ((ISystemFilterReference)selectedObject).getReferencedFilter();
            return !fs.isNonChangable();
        }
        return false;
    }

    public boolean isValidTargetParent(SystemSimpleContentElement selectedElement) {
        if (selectedElement == null) {
            return false;
        }
        Object data = selectedElement.getData();
        return data instanceof ISystemFilterPool;
    }

    protected String checkForCollision(Shell shell, IProgressMonitor monitor, Object targetContainer, Object oldObject, String oldName) {
        ISystemFilterPool newPool = (ISystemFilterPool)targetContainer;
        String newName = oldName;
        ISystemFilter match = newPool.getSystemFilter(oldName);
        if (match != null) {
            SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(shell, true, (Object)match, null);
            dlg.open();
            newName = !dlg.wasCancelled() ? dlg.getNewName() : null;
        }
        return newName;
    }

    protected boolean doCopy(Object targetContainer, Object oldObject, String newName, IProgressMonitor monitor) throws Exception {
        Object data;
        ISystemFilter oldFilter = (ISystemFilter)oldObject;
        ISystemFilterPool oldFilterPool = oldFilter.getParentFilterPool();
        ISystemFilterPoolManager oldMgr = oldFilterPool.getSystemFilterPoolManager();
        ISystemFilterPool newPool = (ISystemFilterPool)targetContainer;
        ISystemFilter newFilter = oldMgr.copySystemFilter(newPool, oldFilter, newName);
        if (this.root != null && newFilter != null && (data = this.root.getData()) != null && data instanceof TreeViewer) {
            ((TreeViewer)data).refresh();
        }
        return newFilter != null;
    }

    protected SystemSimpleContentElement getTreeModel() {
        ISystemFilter firstFilter = this.getFirstSelectedFilter();
        ISystemFilterPoolManagerProvider provider = firstFilter.getProvider();
        return this.getPoolMgrTreeModel(provider, firstFilter.getSystemFilterPoolManager());
    }

    protected SystemSimpleContentElement getTreeInitialSelection() {
        return this.initialSelectionElement;
    }

    public void setPromptString(String promptString) {
        this.promptString = promptString;
    }

    protected String getPromptString() {
        return this.promptString;
    }

    protected SystemMessage getCopyingMessage() {
        return RSEUIPlugin.getPluginMessage("RSEG1077");
    }

    protected SystemMessage getCopyingMessage(String oldName) {
        return RSEUIPlugin.getPluginMessage("RSEG1078").makeSubstitution((Object)oldName);
    }

    protected Object[] getOldObjects() {
        return this.getSelectedFilters();
    }

    protected String[] getOldNames() {
        ISystemFilter[] filters = this.getSelectedFilters();
        String[] names = new String[filters.length];
        int idx = 0;
        while (idx < filters.length) {
            names[idx] = filters[idx].getName();
            ++idx;
        }
        return names;
    }

    protected ISystemFilter[] getSelectedFilters() {
        IStructuredSelection selection = this.getSelection();
        ISystemFilter[] filters = new ISystemFilter[selection.size()];
        Iterator i = selection.iterator();
        int idx = 0;
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof SystemSimpleContentElement) {
                next = ((SystemSimpleContentElement)next).getData();
            }
            filters[idx++] = next instanceof ISystemFilterReference ? ((ISystemFilterReference)next).getReferencedFilter() : (ISystemFilter)next;
        }
        return filters;
    }

    protected ISystemFilter getFirstSelectedFilter() {
        Object first = this.getFirstSelection();
        if (first instanceof SystemSimpleContentElement) {
            this.root = ((SystemSimpleContentElement)first).getRoot();
            first = ((SystemSimpleContentElement)first).getData();
        }
        if (first == null) {
            return null;
        }
        if (first instanceof ISystemFilterReference) {
            return ((ISystemFilterReference)first).getReferencedFilter();
        }
        if (first instanceof ISystemFilter) {
            return (ISystemFilter)first;
        }
        return null;
    }

    protected SystemSimpleContentElement getPoolMgrTreeModel(ISystemFilterPoolManagerProvider poolMgrProvider, ISystemFilterPoolManager poolMgr) {
        SystemSimpleContentElement veryRootElement = new SystemSimpleContentElement("Root", (Object)null, null, null);
        veryRootElement.setRenamable(false);
        veryRootElement.setDeletable(false);
        ISystemFilterPoolManager[] mgrs = poolMgrProvider.getSystemFilterPoolManagers();
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)poolMgrProvider.getAdapter(ISubSystemConfigurationAdapter.class);
        ImageDescriptor image = adapter.getSystemFilterPoolManagerImage();
        if (mgrs == null || mgrs.length == 0) {
            return veryRootElement;
        }
        Vector<SystemSimpleContentElement> veryRootChildren = new Vector<SystemSimpleContentElement>();
        int idx = 0;
        while (idx < mgrs.length) {
            SystemSimpleContentElement mgrElement = new SystemSimpleContentElement(mgrs[idx].getName(), (Object)mgrs[idx], veryRootElement, null);
            mgrElement.setRenamable(false);
            mgrElement.setDeletable(false);
            mgrElement.setImageDescriptor(image);
            Vector elements = new Vector();
            SystemFilterCopyFilterAction.populateFilterPoolContentElementVector(poolMgrProvider, mgrs[idx], elements, mgrElement);
            mgrElement.setChildren(elements);
            veryRootChildren.addElement(mgrElement);
            if (mgrs[idx] == poolMgr) {
                this.initialSelectionElement = mgrElement;
            }
            ++idx;
        }
        veryRootElement.setChildren(veryRootChildren);
        return veryRootElement;
    }

    protected static void populateFilterPoolContentElementVector(ISystemFilterPoolManagerProvider poolMgrProvider, ISystemFilterPoolManager mgr, Vector elements, SystemSimpleContentElement parentElement) {
        ISystemFilterPool[] pools = mgr.getSystemFilterPools();
        int idx = 0;
        while (idx < pools.length) {
            ISystemFilterPool pool = pools[idx];
            SystemSimpleContentElement cElement = new SystemSimpleContentElement(pool.getName(), (Object)pool, parentElement, null);
            cElement.setImageDescriptor(SystemFilterUIHelpers.getFilterPoolImage(poolMgrProvider, pool));
            elements.addElement(cElement);
            ++idx;
        }
    }
}

