/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.processes.dstore;

import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorServiceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.services.dstore.processes.DStoreProcessService;
import org.eclipse.rse.internal.subsystems.processes.dstore.DStoreProcessAdapter;
import org.eclipse.rse.services.dstore.IDStoreService;
import org.eclipse.rse.services.processes.IProcessService;
import org.eclipse.rse.subsystems.processes.core.subsystem.IHostProcessToRemoteProcessAdapter;
import org.eclipse.rse.subsystems.processes.servicesubsystem.ProcessServiceSubSystem;
import org.eclipse.rse.subsystems.processes.servicesubsystem.ProcessServiceSubSystemConfiguration;

public class DStoreProcessSubSystemConfiguration
extends ProcessServiceSubSystemConfiguration {
    protected IHostProcessToRemoteProcessAdapter _hostProcessAdapter;

    public boolean isFactoryFor(Class subSystemType) {
        boolean isFor = ProcessServiceSubSystem.class.equals((Object)subSystemType);
        return isFor;
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        DStoreConnectorService connectorService = (DStoreConnectorService)this.getConnectorService(host);
        ProcessServiceSubSystem subsys = new ProcessServiceSubSystem(host, (IConnectorService)connectorService, this.getProcessService(host), this.getHostProcessAdapter());
        return subsys;
    }

    public boolean supportsFileTypes() {
        return false;
    }

    public boolean supportsSearch() {
        return false;
    }

    public boolean supportsEnvironmentVariablesPropertyPage() {
        return false;
    }

    public boolean supportsFilters() {
        return true;
    }

    public IProcessService createProcessService(IHost host) {
        DStoreConnectorService connectorService = (DStoreConnectorService)this.getConnectorService(host);
        return new DStoreProcessService((IDataStoreProvider)connectorService);
    }

    public IHostProcessToRemoteProcessAdapter getHostProcessAdapter() {
        if (this._hostProcessAdapter == null) {
            this._hostProcessAdapter = new DStoreProcessAdapter();
        }
        return this._hostProcessAdapter;
    }

    public IConnectorService getConnectorService(IHost host) {
        return DStoreConnectorServiceManager.getInstance().getConnectorService(host, this.getServiceImplType());
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        DStoreConnectorServiceManager.getInstance().setConnectorService(host, this.getServiceImplType(), connectorService);
    }

    public Class getServiceImplType() {
        return IDStoreService.class;
    }
}

