/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.examples.daytime.subsystems;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.examples.daytime.Activator;
import org.eclipse.rse.examples.daytime.model.DaytimeResource;
import org.eclipse.rse.examples.daytime.service.IDaytimeService;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.model.ISystemRegistryUI;
import org.eclipse.swt.widgets.Display;

public class DaytimeSubSystem
extends SubSystem {
    private IDaytimeService fDaytimeService;
    static /* synthetic */ Class class$0;

    public DaytimeSubSystem(IHost host, IConnectorService connectorService, IDaytimeService daytimeService) {
        super(host, connectorService);
        this.fDaytimeService = daytimeService;
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        final ISystemRegistryUI sr = RSEUIPlugin.getTheSystemRegistryUI();
        final SystemResourceChangeEvent event = new SystemResourceChangeEvent((Object)this, 105, null);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                sr.postEvent((ISystemResourceChangeEvent)event);
            }
        });
    }

    public boolean hasChildren() {
        return this.isConnected();
    }

    public IDaytimeService getDaytimeService() {
        return this.fDaytimeService;
    }

    public Object[] getChildren() {
        if (this.isConnected()) {
            try {
                String daytime = this.fDaytimeService.getTimeOfDay();
                DaytimeResource node = new DaytimeResource((ISubSystem)this);
                node.setDaytime(daytime);
                return new Object[]{node};
            }
            catch (Exception e) {
                String msgTxt = NLS.bind((String)CommonMessages.MSG_CONNECT_FAILED, (Object)this.getHostName());
                SimpleSystemMessage msg = new SimpleSystemMessage(Activator.PLUGIN_ID, "RSEG1056", 4, msgTxt, (Throwable)e);
                SystemMessageObject msgobj = new SystemMessageObject((SystemMessage)msg, 0, (Object)this);
                return new Object[]{msgobj};
            }
        }
        return new Object[0];
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        super.uninitializeSubSystem(monitor);
    }

    public Class getServiceType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.examples.daytime.service.IDaytimeService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void switchServiceFactory(ISubSystemConfiguration factory) {
    }
}

