/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.codehaus.jdt.groovy.integration.internal.GroovyLanguageSupport;
import org.codehaus.jdt.groovy.internal.compiler.GroovyClassLoaderFactory;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyErrorCollectorForJDT;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.IGroovyDebugRequestor;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.CharArraySequence;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ReadManager;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.BatchCompilerRequestor;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;

public class GroovyParser {
    public Object requestor;
    private JDTResolver resolver;
    public final ProblemReporter problemReporter;
    public static IGroovyDebugRequestor debugRequestor;
    private final Supplier<CompilationUnit> unitFactory;
    private CompilationUnit compilationUnit;
    private CompilerOptions compilerOptions;
    private static Map<String, ScriptFolderSelector> scriptFolderSelectorCache;
    private static final Pattern GROOVY_SOURCE_DISCRIMINATOR;
    private static final Pattern STC_EXTENSION_DISCRIMINATOR;

    static {
        scriptFolderSelectorCache = new ConcurrentHashMap<String, ScriptFolderSelector>();
        GROOVY_SOURCE_DISCRIMINATOR = Pattern.compile("\\A(/\\*.*?\\*/\\s*)?package\\s+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\s*\\.\\s*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*\\s++(?!;)", 32);
        STC_EXTENSION_DISCRIMINATOR = Pattern.compile("^(?:unresolvedVariable|unresolvedProperty|unresolvedAttribute|methodNotFound|ambiguousMethods|onMethodSelection|incompatibleAssignment|incompatibleReturnType|(?:before|after)(?:MethodCall|VisitMethod|VisitClass))\\b", 8);
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public static void clearCache(String projectName) {
        scriptFolderSelectorCache.remove(projectName);
        GroovyClassLoaderFactory.clearCache(projectName);
    }

    public static char[] getContents(ICompilationUnit compilationUnit, ReadManager readManager) {
        return Optional.ofNullable(readManager != null ? readManager.getContents(compilationUnit) : compilationUnit.getContents()).orElse(CharOperation.NO_CHAR);
    }

    public static boolean isGroovyParserEligible(ICompilationUnit compilationUnit, ReadManager readManager) {
        char[] contents;
        String fileName;
        if (compilationUnit instanceof BasicCompilationUnit) {
            if (ContentTypeUtils.isGroovyLikeFileName(((BasicCompilationUnit)compilationUnit).sourceName)) {
                return true;
            }
        } else if (compilationUnit instanceof PossibleMatch) {
            return ((PossibleMatch)compilationUnit).isInterestingSourceFile();
        }
        if (ContentTypeUtils.isGroovyLikeFileName(fileName = CharOperation.charToString(compilationUnit.getFileName()))) {
            return true;
        }
        return !ContentTypeUtils.isJavaLikeButNotGroovyLikeFileName(fileName) && GROOVY_SOURCE_DISCRIMINATOR.matcher(new CharArraySequence(contents = GroovyParser.getContents(compilationUnit, readManager))).find();
    }

    public GroovyParser(CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean allowTransforms, boolean isReconcile) {
        this(null, compilerOptions, problemReporter, allowTransforms, isReconcile);
    }

    public GroovyParser(Object requestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean allowTransforms, boolean isReconcile) {
        this.requestor = requestor;
        this.compilerOptions = compilerOptions;
        this.problemReporter = problemReporter;
        GroovyClassLoaderFactory loaderFactory = new GroovyClassLoaderFactory(compilerOptions, requestor instanceof Compiler ? ((Compiler)requestor).lookupEnvironment : null);
        this.unitFactory = () -> {
            CompilerConfiguration compilerConfiguration = GroovyLanguageSupport.newCompilerConfiguration(compilerOptions, problemReporter);
            GroovyClassLoader[] classLoaders = loaderFactory.getGroovyClassLoaders(compilerConfiguration);
            if (allowTransforms && isReconcile) {
                HashSet<String> xforms = new HashSet<String>();
                xforms.add("org.spockframework.compiler.SpockTransform");
                xforms.add("org.apache.groovy.contracts.ast.ClosureExpressionEvaluationASTTransformation");
                Optional.ofNullable(compilerConfiguration.getDisabledGlobalASTTransformations()).ifPresent(xforms::addAll);
                compilerConfiguration.setDisabledGlobalASTTransformations(xforms);
            }
            CompilationUnit unit = new CompilationUnit(compilerConfiguration, null, classLoaders[0], classLoaders[1], allowTransforms, null);
            this.resolver = new JDTResolver(unit);
            unit.setResolveVisitor(this.resolver);
            unit.tweak(isReconcile);
            return unit;
        };
    }

    public void reset() {
        try {
            try {
                if (this.compilationUnit != null && this.compilerOptions.groovyProjectName == null) {
                    this.compilationUnit.getTransformLoader().close();
                    this.compilationUnit.getClassLoader().close();
                }
            }
            catch (Exception exception) {
                this.compilationUnit = null;
                this.resolver = null;
            }
        }
        finally {
            this.compilationUnit = null;
            this.resolver = null;
        }
    }

    public GroovyCompilationUnitDeclaration dietParse(char[] contents, String fileName, CompilationResult compilationResult) {
        IPath location;
        Path filePath;
        boolean isInJar = fileName.indexOf(124) > 0;
        boolean isScript = false;
        IResource eclipseFile = null;
        if (!isInJar && (filePath = new Path(fileName)).segmentCount() >= 2 && ResourcesPlugin.getPlugin() != null && (location = (eclipseFile = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath)).getLocation()) != null) {
            fileName = location.toFile().getAbsolutePath();
            IProject project = eclipseFile.getProject();
            isScript = scriptFolderSelectorCache.computeIfAbsent(project.getName(), key -> new ScriptFolderSelector(project)).isScript(eclipseFile);
        }
        if (this.problemReporter.referenceContext == null) {
            this.problemReporter.referenceContext = new ReferenceContextImpl(compilationResult);
        }
        if (this.compilationUnit == null) {
            if (isInJar || isScript || eclipseFile != null && eclipseFile.getProject().isAccessible() && !JavaCore.create(eclipseFile.getProject()).isOnClasspath(eclipseFile)) {
                if (isScript && STC_EXTENSION_DISCRIMINATOR.matcher(new CharArraySequence(contents)).find()) {
                    this.compilerOptions.buildGroovyFiles |= 4;
                }
                this.compilerOptions.groovyCompilerConfigScript = null;
            }
            this.compilationUnit = this.unitFactory.get();
        }
        SourceUnit sourceUnit = this.compilationUnit.addSource(new EclipseSourceUnit((IFile)eclipseFile, fileName, contents, this.compilationUnit.getConfiguration(), null, new GroovyErrorCollectorForJDT(this.compilationUnit.getConfiguration()), this.resolver));
        if (this.requestor instanceof Compiler) {
            Main main;
            Compiler compiler = (Compiler)this.requestor;
            if (compiler.requestor instanceof AbstractImageBuilder) {
                SourceFile sourceFile;
                AbstractImageBuilder builder = (AbstractImageBuilder)compiler.requestor;
                if (builder.notifier != null) {
                    this.compilationUnit.setProgressListener(GroovyParser.newProgressListener(builder.notifier));
                }
                if (eclipseFile != null && (sourceFile = (SourceFile)builder.fromIFile((IFile)eclipseFile)) != null) {
                    this.compilationUnit.getConfiguration().setTargetDirectory(sourceFile.getOutputLocation().toFile());
                }
            } else if (compiler.requestor instanceof BatchCompilerRequestor && (main = (Main)ReflectionUtils.getPrivateField(BatchCompilerRequestor.class, "compiler", compiler.requestor)) != null && main.destinationPath != null && main.destinationPath != "none") {
                this.compilationUnit.getConfiguration().setTargetDirectory(main.destinationPath);
            }
        }
        compilationResult.lineSeparatorPositions = GroovyUtils.getSourceLineSeparatorsIn(contents);
        GroovyCompilationUnitDeclaration gcuDeclaration = new GroovyCompilationUnitDeclaration(this.problemReporter, compilationResult, contents.length, this.compilationUnit, sourceUnit, this.compilerOptions);
        gcuDeclaration.processToPhase(3);
        if (gcuDeclaration.getModuleNode() != null) {
            gcuDeclaration.populateCompilationUnitDeclaration();
            TypeDeclaration[] typeDeclarationArray = gcuDeclaration.types;
            int n = gcuDeclaration.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration decl = typeDeclarationArray[n2];
                this.resolver.record((GroovyTypeDeclaration)decl);
                ++n2;
            }
        }
        if (isScript) {
            gcuDeclaration.tagAsScript();
        }
        if (debugRequestor != null) {
            debugRequestor.acceptCompilationUnitDeclaration(gcuDeclaration);
        }
        return gcuDeclaration;
    }

    private static CompilationUnit.ProgressListener newProgressListener(final BuildNotifier notifier) {
        final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return new CompilationUnit.ProgressListener(){

            @Override
            public void parseComplete(int phase, String sourceUnitName) {
                try {
                    IFile sourceUnitFile = root.getFileForLocation(new Path(sourceUnitName));
                    notifier.subTask("Parsing groovy sources in " + sourceUnitFile.getParent().getFullPath());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                notifier.checkCancelWithinCompiler();
            }

            @Override
            public void generateComplete(int phase, ClassNode classNode) {
                try {
                    IFile sourceUnitFile = root.getFileForLocation(new Path(classNode.getModule().getContext().getName()));
                    notifier.subTask("Writing groovy classes for " + sourceUnitFile.getParent().getFullPath());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                notifier.checkCancelWithinCompiler();
            }
        };
    }

    private static class ReferenceContextImpl
    implements ReferenceContext {
        private boolean hasErrors;
        private final CompilationResult compilationResult;

        ReferenceContextImpl(CompilationResult compilationResult) {
            this.compilationResult = compilationResult;
        }

        @Override
        public boolean hasErrors() {
            return this.hasErrors;
        }

        @Override
        public void tagAsHavingErrors() {
            this.hasErrors = true;
        }

        @Override
        public void tagAsHavingIgnoredMandatoryErrors(int problemId) {
        }

        @Override
        public CompilationResult compilationResult() {
            return this.compilationResult;
        }

        @Override
        public CompilationUnitDeclaration getCompilationUnitDeclaration() {
            return null;
        }

        @Override
        public void abort(int abortLevel, CategorizedProblem problem) {
            switch (abortLevel) {
                case 8: {
                    throw new AbortType(this.compilationResult, problem);
                }
                case 16: {
                    throw new AbortMethod(this.compilationResult, problem);
                }
            }
            throw new AbortCompilationUnit(this.compilationResult, problem);
        }
    }
}

