/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.classloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;

public final class IoUtil {
    private IoUtil() {
    }

    public static byte[] getBytes(InputStream inputStream) throws IOException {
        try {
            byte[] bytes;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int count = inputStream.read(buffer);
            while (count >= 0) {
                out.write(buffer, 0, count);
                count = inputStream.read(buffer);
            }
            byte[] byArray = bytes = out.toByteArray();
            return byArray;
        }
        finally {
            IoUtil.close(inputStream);
        }
    }

    public static void flush(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class EmptyInputStream
    extends InputStream {
        public int read() {
            return -1;
        }

        public int read(byte[] b, int off, int len) {
            return -1;
        }

        public long skip(long n) {
            return 0L;
        }
    }
}

