/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.maven;

import com.microsoft.java.maven.GetPosHandler;
import com.microsoft.java.maven.PosInfo;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.CodeStyleConfiguration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AddDependencyHandler {
    private static WorkspaceEdit importEdit(AddDependencyParams params, ICompilationUnit unit, CompilationUnit astRoot) throws CoreException {
        CompilationUnitChange cuChange = new CompilationUnitChange("", unit);
        ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
        importRewrite.addImport(params.fullClassName);
        cuChange.setEdit(importRewrite.rewriteImports(null));
        return ChangeUtil.convertToWorkspaceEdit((Change)cuChange);
    }

    private static WorkspaceEdit replaceEdit(AddDependencyParams params, ICompilationUnit unit) throws JavaModelException {
        HashMap<String, List<TextEdit>> textEdits = new HashMap<String, List<TextEdit>>();
        textEdits.put(unit.getCorrespondingResource().getLocationURI().toString(), Arrays.asList(new TextEdit(new Range(new Position(params.line, params.character), new Position(params.line, params.character + params.length)), params.fullClassName.substring(params.fullClassName.lastIndexOf(46) + 1))));
        return new WorkspaceEdit(textEdits);
    }

    private static PosInfo getPosInfo(String pomPath, String targetDependency) {
        PosInfo posInfo = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            GetPosHandler posHandler = new GetPosHandler();
            posHandler.setTargetDependency(targetDependency);
            reader.setContentHandler(posHandler);
            reader.parse(pomPath);
            posInfo = posHandler.getPosInfo();
            return posInfo;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            return null;
        }
    }

    private static WorkspaceEdit pomEdit(AddDependencyParams params, ICompilationUnit unit) throws JavaModelException {
        IPath path = unit.getJavaProject().getCorrespondingResource().getLocation().append("pom.xml");
        String[] info = params.artifactInfo.replaceAll(" ", "").split(":");
        if (info.length < 3) {
            return new WorkspaceEdit();
        }
        PosInfo posInfo = AddDependencyHandler.getPosInfo(path.toString(), info[0] + ":" + info[1]);
        String linesep = System.lineSeparator();
        Object newtext = "";
        String pomUriString = unit.getJavaProject().getCorrespondingResource().getLocationURI().toString() + "/pom.xml";
        HashMap<CallSite, List<Object>> textEdits = new HashMap<CallSite, List<Object>>();
        if (posInfo != null) {
            if (!posInfo.needAddDependency.booleanValue()) {
                textEdits.put((CallSite)((Object)pomUriString), new ArrayList());
            } else if (!posInfo.alreadyHasDependencies.booleanValue()) {
                newtext = linesep + StringUtils.repeat((String)" ", (int)2) + "<dependencies>" + linesep + StringUtils.repeat((String)" ", (int)4) + "<dependency>" + linesep + StringUtils.repeat((String)" ", (int)6) + "<groupId>" + info[0] + "</groupId>" + linesep + StringUtils.repeat((String)" ", (int)6) + "<artifactId>" + info[1] + "</artifactId>" + linesep + StringUtils.repeat((String)" ", (int)6) + "<version>" + info[2] + "</version>" + linesep + StringUtils.repeat((String)" ", (int)4) + "</dependency>" + linesep + StringUtils.repeat((String)" ", (int)2) + "</dependencies>" + linesep;
                textEdits.put((CallSite)((Object)pomUriString), (List<Object>)Arrays.asList(new TextEdit(new Range(posInfo.pos, posInfo.pos), (String)newtext)));
            } else {
                int space = posInfo.pos.getCharacter();
                newtext = linesep + StringUtils.repeat((String)" ", (int)(space + 2)) + "<dependency>" + linesep + StringUtils.repeat((String)" ", (int)(space + 4)) + "<groupId>" + info[0] + "</groupId>" + linesep + StringUtils.repeat((String)" ", (int)(space + 4)) + "<artifactId>" + info[1] + "</artifactId>" + linesep + StringUtils.repeat((String)" ", (int)(space + 4)) + "<version>" + info[2] + "</version>" + linesep + StringUtils.repeat((String)" ", (int)(space + 2)) + "</dependency>" + linesep + StringUtils.repeat((String)" ", (int)space);
                textEdits.put((CallSite)((Object)pomUriString), (List<Object>)Arrays.asList(new TextEdit(new Range(posInfo.pos, posInfo.pos), (String)newtext)));
            }
            return new WorkspaceEdit(textEdits);
        }
        return new WorkspaceEdit();
    }

    public static List<WorkspaceEdit> addDependency(AddDependencyParams params, IProgressMonitor monitor) throws CoreException, JavaModelException {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)params.uri);
        CompilationUnit astRoot = ASTResolving.createQuickFixAST((ICompilationUnit)unit, null);
        return Arrays.asList(AddDependencyHandler.replaceEdit(params, unit), AddDependencyHandler.importEdit(params, unit, astRoot), AddDependencyHandler.pomEdit(params, unit));
    }

    public static class AddDependencyParams {
        final String fullClassName;
        final String artifactInfo;
        final String uri;
        final int line;
        final int character;
        final int length;

        public AddDependencyParams(String fullClassName, String artifactInfo, String uri, int line, int character, int length) {
            this.fullClassName = fullClassName;
            this.artifactInfo = artifactInfo;
            this.uri = uri;
            this.line = line;
            this.character = character;
            this.length = length;
        }
    }
}

