/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenamePackageChange
extends AbstractJavaElementRenameChange {
    private Map<IResource, Long> fCompilationUnitStamps;
    private final boolean fRenameSubpackages;

    private static IPath createPath(String packageName) {
        return new Path(packageName.replace('.', '/'));
    }

    public RenamePackageChange(IPackageFragment pack, String newName, boolean renameSubpackages) {
        this(pack.getPath(), pack.getElementName(), newName, -1L, null, renameSubpackages);
        Assert.isTrue((!pack.isReadOnly() ? 1 : 0) != 0, (String)"package must not be read only");
    }

    private RenamePackageChange(IPath resourcePath, String oldName, String newName, long stampToRestore, Map<IResource, Long> compilationUnitStamps, boolean renameSubpackages) {
        super(resourcePath, oldName, newName, stampToRestore);
        this.fCompilationUnitStamps = compilationUnitStamps;
        this.fRenameSubpackages = renameSubpackages;
        this.setValidationMethod(2);
    }

    private void addStamps(Map<IResource, Long> stamps, ICompilationUnit[] units) {
        ICompilationUnit[] iCompilationUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit unit = iCompilationUnitArray[n2];
            IResource resource = unit.getResource();
            long stamp = -1L;
            if (resource != null && (stamp = resource.getModificationStamp()) != -1L) {
                stamps.put(resource, stamp);
            }
            ++n2;
        }
    }

    @Override
    protected IPath createNewPath() {
        IPackageFragment oldPackage = this.getPackage();
        IPath oldPackageName = RenamePackageChange.createPath(oldPackage.getElementName());
        IPath newPackageName = RenamePackageChange.createPath(this.getNewName());
        return this.getResourcePath().removeLastSegments(oldPackageName.segmentCount()).append(newPackageName);
    }

    protected IPath createNewPath(IPackageFragment oldPackage) {
        IPath oldPackagePath = RenamePackageChange.createPath(oldPackage.getElementName());
        IPath newPackagePath = RenamePackageChange.createPath(this.getNewName(oldPackage));
        return oldPackage.getPath().removeLastSegments(oldPackagePath.segmentCount()).append(newPackagePath);
    }

    @Override
    protected Change createUndoChange(long stampToRestore) throws CoreException {
        IPackageFragment pack = this.getPackage();
        if (pack == null) {
            return new NullChange();
        }
        HashMap<IResource, Long> stamps = new HashMap<IResource, Long>();
        if (!this.fRenameSubpackages) {
            this.addStamps(stamps, pack.getCompilationUnits());
        } else {
            IPackageFragment[] iPackageFragmentArray = JavaElementUtil.getPackageAndSubpackages(pack);
            int n = iPackageFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment currentPackage = iPackageFragmentArray[n2];
                this.addStamps(stamps, currentPackage.getCompilationUnits());
                ++n2;
            }
        }
        return new RenamePackageChange(this.createNewPath(), this.getNewName(), this.getOldName(), stampToRestore, stamps, this.fRenameSubpackages);
    }

    @Override
    protected void doRename(IProgressMonitor pm) throws CoreException {
        IPackageFragment pack = this.getPackage();
        if (pack == null) {
            return;
        }
        if (!this.fRenameSubpackages) {
            this.renamePackage(pack, pm, this.createNewPath(), this.getNewName());
        } else {
            IPackageFragment[] allPackages = JavaElementUtil.getPackageAndSubpackages(pack);
            Arrays.sort(allPackages, (o1, o2) -> {
                String p1 = o1.getElementName();
                String p2 = o2.getElementName();
                return p1.compareTo(p2);
            });
            int count = allPackages.length;
            pm.beginTask("", count);
            boolean insideOut = this.getNewName().startsWith(this.getOldName());
            try {
                int i = 0;
                while (i < count) {
                    IPackageFragment currentPackage = allPackages[insideOut ? count - i - 1 : i];
                    this.renamePackage(currentPackage, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1), this.createNewPath(currentPackage), this.getNewName(currentPackage));
                    ++i;
                }
            }
            finally {
                pm.done();
            }
        }
    }

    public String getName() {
        String msg = this.fRenameSubpackages ? RefactoringCoreMessages.RenamePackageChange_name_with_subpackages : RefactoringCoreMessages.RenamePackageChange_name;
        Object[] keys = new String[]{BasicElementLabels.getJavaElementName(this.getOldName()), BasicElementLabels.getJavaElementName(this.getNewName())};
        return Messages.format(msg, keys);
    }

    private String getNewName(IPackageFragment subpackage) {
        return this.getNewName() + subpackage.getElementName().substring(this.getOldName().length());
    }

    private IPackageFragment getPackage() {
        return (IPackageFragment)this.getModifiedElement();
    }

    public boolean getRenameSubpackages() {
        return this.fRenameSubpackages;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        pm.beginTask("", 2);
        try {
            result = new RefactoringStatus();
            IJavaElement element = (IJavaElement)this.getModifiedElement();
            result.merge(super.isValid((IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (element != null && element.exists() && element instanceof IPackageFragment) {
                IPackageFragment pack = (IPackageFragment)element;
                if (this.fRenameSubpackages) {
                    IPackageFragment[] allPackages = JavaElementUtil.getPackageAndSubpackages(pack);
                    SubMonitor subPm = SubMonitor.convert((IProgressMonitor)pm, (int)1);
                    subPm.beginTask("", allPackages.length);
                    IPackageFragment[] iPackageFragmentArray = allPackages;
                    int n = allPackages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragment pckg = iPackageFragmentArray[n2];
                        RenamePackageChange.checkIfModifiable((RefactoringStatus)result, (IResource)pckg.getResource(), (int)2);
                        if (result.hasFatalError()) {
                            RefactoringStatus refactoringStatus = result;
                            return refactoringStatus;
                        }
                        this.isValid(result, pckg, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)subPm, (int)1));
                        ++n2;
                    }
                } else {
                    this.isValid(result, pack, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
                }
            }
        }
        finally {
            pm.done();
        }
        return result;
    }

    private void isValid(RefactoringStatus result, IPackageFragment pack, IProgressMonitor pm) throws JavaModelException {
        ICompilationUnit[] units = pack.getCompilationUnits();
        pm.beginTask("", units.length);
        ICompilationUnit[] iCompilationUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit unit = iCompilationUnitArray[n2];
            pm.subTask(Messages.format(RefactoringCoreMessages.RenamePackageChange_checking_change, JavaElementLabelsCore.getElementLabel((IJavaElement)pack, 0x200009L)));
            RenamePackageChange.checkIfModifiable((RefactoringStatus)result, (IResource)unit.getResource(), (int)3);
            pm.worked(1);
            ++n2;
        }
        pm.done();
    }

    private void renamePackage(IPackageFragment pack, IProgressMonitor pm, IPath newPath, String newName) throws JavaModelException, CoreException {
        IPackageFragment newPack;
        if (!pack.exists()) {
            return;
        }
        pack.rename(newName, false, pm);
        if (this.fCompilationUnitStamps != null && (newPack = (IPackageFragment)JavaCore.create((IFolder)ResourcesPlugin.getWorkspace().getRoot().getFolder(newPath))).exists()) {
            ICompilationUnit[] iCompilationUnitArray = newPack.getCompilationUnits();
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                Long stamp;
                ICompilationUnit unit = iCompilationUnitArray[n2];
                IResource resource = unit.getResource();
                if (resource != null && (stamp = this.fCompilationUnitStamps.get(resource)) != null) {
                    resource.revertModificationStamp(stamp.longValue());
                }
                ++n2;
            }
        }
    }
}

