/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.LocalVariableLocator;
import org.eclipse.jdt.internal.core.search.matching.LocalVariablePattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.VariablePattern;

public class DOMLocalVariableLocator
extends DOMPatternLocator {
    private LocalVariableLocator locator;
    private List<LocalVariable> foundDeclarations = new ArrayList<LocalVariable>();

    public DOMLocalVariableLocator(LocalVariableLocator lcl) {
        super((SearchPattern)lcl.pattern);
        this.locator = lcl;
    }

    private LocalVariable getLocalVariable() {
        VariablePattern variablePattern = this.locator.pattern;
        if (variablePattern instanceof LocalVariablePattern) {
            LocalVariablePattern lvp = (LocalVariablePattern)variablePattern;
            return lvp.localVariable;
        }
        return null;
    }

    @Override
    public LocatorResponse match(Name node, NodeSetWrapper nodeSet, MatchLocator locator) {
        Class childType;
        StructuralPropertyDescriptor descriptor = node.getLocationInParent();
        if (descriptor instanceof ChildPropertyDescriptor) {
            ChildPropertyDescriptor single = (ChildPropertyDescriptor)descriptor;
            v0 = single.getChildType();
        } else if (descriptor instanceof ChildListPropertyDescriptor) {
            ChildListPropertyDescriptor list = (ChildListPropertyDescriptor)descriptor;
            v0 = list.getElementType();
        } else {
            v0 = childType = null;
        }
        if ((childType == Expression.class || descriptor == QualifiedName.QUALIFIER_PROPERTY) && node instanceof SimpleName) {
            SimpleName simple = (SimpleName)node;
            if (Objects.equals(this.getLocalVariable() == null ? null : this.getLocalVariable().getElementName(), simple.getIdentifier())) {
                if (!this.locator.pattern.readAccess && DOMLocalVariableLocator.isRead(node)) {
                    return DOMLocalVariableLocator.toResponse(0);
                }
                if (!this.locator.pattern.writeAccess && DOMLocalVariableLocator.isWrite(node)) {
                    return DOMLocalVariableLocator.toResponse(0);
                }
                return DOMLocalVariableLocator.toResponse(2);
            }
        }
        return DOMLocalVariableLocator.toResponse(0);
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (!(binding instanceof IVariableBinding)) {
            return DOMLocalVariableLocator.toResponse(0);
        }
        IJavaElement bindingElement = binding.getJavaElement();
        LocalVariable localVar = this.getLocalVariable();
        if (localVar != null && bindingElement instanceof LocalVariable) {
            LocalVariable resolvedVarElement = (LocalVariable)bindingElement;
            if (Objects.equals(localVar.getElementName(), resolvedVarElement.getElementName()) && localVar.nameStart == resolvedVarElement.nameStart) {
                if (this.locator.pattern.findReferences) {
                    return new LocatorResponse(3, false, node, false, false);
                }
                if (this.locator.pattern.findDeclarations) {
                    boolean isDecl = this.hasVariableDeclarationAncestor(node);
                    if (isDecl && !this.alreadyFound(localVar)) {
                        this.foundDeclarations.add(localVar);
                        return new LocatorResponse(3, false, node, false, false);
                    }
                    return DOMLocalVariableLocator.toResponse(0);
                }
            }
        }
        return DOMLocalVariableLocator.toResponse(0);
    }

    private boolean hasVariableDeclarationAncestor(ASTNode node) {
        for (ASTNode working = node; working != null; working = working.getParent()) {
            if (!(working instanceof VariableDeclaration)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LocatorResponse match(VariableDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        LocalVariable lvFromPattern;
        int defaultLevelOnMatch;
        int n = defaultLevelOnMatch = this.locator.pattern.mustResolve ? 2 : 3;
        if (this.locator.pattern.findReferences && this.locator.pattern.writeAccess && !this.locator.pattern.readAccess && node.getInitializer() != null && this.locator.matchesName(this.locator.pattern.name, node.getName().getIdentifier().toCharArray())) {
            return DOMLocalVariableLocator.toResponse(defaultLevelOnMatch, false);
        }
        if (this.locator.pattern.findDeclarations && this.locator.matchesName(this.locator.pattern.name, node.getName().getIdentifier().toCharArray()) && (lvFromPattern = this.getLocalVariable()) != null) {
            if (node.getStartPosition() == lvFromPattern.declarationSourceStart) {
                return DOMLocalVariableLocator.toResponse(defaultLevelOnMatch, false);
            }
            if (node.getName().getStartPosition() == lvFromPattern.nameStart) {
                return new LocatorResponse(defaultLevelOnMatch, true, (ASTNode)node.getName(), false, false);
            }
        }
        return DOMLocalVariableLocator.toResponse(0, false);
    }

    @Override
    public void reportSearchMatch(MatchLocator locator, ASTNode node, SearchMatch match) throws CoreException {
        SearchMatch matchToReport = match;
        if (this.locator.pattern.findDeclarations && this.hasVariableDeclarationAncestor(node)) {
            LocalVariable localVariable = this.getLocalVariable();
            int offset = localVariable.nameStart;
            int length = localVariable.nameEnd - offset + 1;
            LocalVariable element = localVariable;
            matchToReport = locator.newDeclarationMatch((IJavaElement)element, null, match.getAccuracy(), offset, length);
        }
        if (matchToReport != null) {
            super.reportSearchMatch(locator, node, matchToReport);
        }
    }

    private boolean alreadyFound(LocalVariable matchToReport) {
        boolean found = this.foundDeclarations.stream().filter(x -> matchToReport.toString().equals(x.toString())).findFirst().isPresent();
        return found;
    }

    public static boolean isRead(Name name) {
        if (name.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
            name = (QualifiedName)name.getParent();
        }
        if (name.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
            Assignment assign = (Assignment)name.getParent();
            return assign.getOperator() != Assignment.Operator.ASSIGN;
        }
        return true;
    }

    public static boolean isWrite(Name name) {
        if (name.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
            name = (QualifiedName)name.getParent();
        }
        return Set.of(Assignment.LEFT_HAND_SIDE_PROPERTY, PostfixExpression.OPERAND_PROPERTY, PrefixExpression.OPERAND_PROPERTY).contains(name.getLocationInParent());
    }
}

