/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class Timer {
    Map<String, Duration> durations = new HashMap<String, Duration>();
    Deque<Map.Entry<String, Instant>> started = new LinkedList<Map.Entry<String, Instant>>();

    public void reportDuration(String id, Runnable r) {
        Instant before = Instant.now();
        r.run();
        Duration d = Duration.between(before, Instant.now());
        System.err.println(id + " current:" + d.toMillis() + " total:" + this.durations.compute(id, (string, prev) -> prev == null ? d : prev.plus(d)).toMillis());
    }

    public <T> T reportDuration(String id, Supplier<T> r) {
        Instant before = Instant.now();
        T res = r.get();
        Duration d = Duration.between(before, Instant.now());
        System.err.println(id + " current:" + d.toMillis() + " total:" + this.durations.compute(id, (string, prev) -> prev == null ? d : prev.plus(d)).toMillis());
        return res;
    }

    public void start(String id) {
        this.started.push(new AbstractMap.SimpleEntry<String, Instant>(id, Instant.now()));
    }

    public void stopCurrent() {
        if (!this.started.isEmpty()) {
            Map.Entry<String, Instant> entry = this.started.pop();
            String current = entry.getKey();
            Duration d = Duration.between(entry.getValue(), Instant.now());
            System.err.println(current + " current:" + d.toMillis() + " total:" + this.durations.compute(current, (string, prev) -> prev == null ? d : prev.plus(d)).toMillis());
        }
    }

    public void stopLast(String id) {
        Map.Entry e = this.started.reversed().stream().filter(entry -> Objects.equals(id, entry.getKey())).findFirst().orElse(null);
        if (e != null) {
            this.started.remove(e);
            String current = (String)e.getKey();
            Duration d = Duration.between((Temporal)e.getValue(), Instant.now());
            System.err.println(current + " current:" + d.toMillis() + " total:" + this.durations.compute(current, (string, prev) -> prev == null ? d : prev.plus(d)).toMillis());
        }
    }
}

