/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.DocCommentParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Position;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.lang.model.type.TypeKind;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EitherOrMultiPattern;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.GuardedPattern;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImplicitTypeDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.JavadocConverter;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.Pattern;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.RecordPattern;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.TypePattern;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.internal.codeassist.DOMCodeSelector;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;

class JavacConverter {
    private static final String MISSING_IDENTIFIER = "$missing$";
    private static final String ERROR = "<error>";
    private static final String FAKE_IDENTIFIER = new String(RecoveryScanner.FAKE_IDENTIFIER);
    public final AST ast;
    final JCTree.JCCompilationUnit javacCompilationUnit;
    private final Context context;
    final Map<ASTNode, JCTree> domToJavac = new HashMap<ASTNode, JCTree>();
    final String rawText;
    final Set<JCDiagnostic> javadocDiagnostics = new HashSet<JCDiagnostic>();
    private final java.util.List<JavadocConverter> javadocConverters = new ArrayList<JavadocConverter>();
    final java.util.List<Comment> notAttachedComments = new ArrayList<Comment>();
    private boolean buildJavadoc;
    private int focalPoint;

    private JavacConverter(AST ast, JCTree.JCCompilationUnit javacCompilationUnit, Context context, String rawText, boolean buildJavadoc) {
        this.ast = ast;
        this.javacCompilationUnit = javacCompilationUnit;
        this.context = context;
        this.rawText = rawText;
        this.buildJavadoc = buildJavadoc;
        this.focalPoint = -1;
    }

    public JavacConverter(AST ast, JCTree.JCCompilationUnit javacCompilationUnit, Context context, String rawText, boolean buildJavadoc, int focalPoint) {
        this(ast, javacCompilationUnit, context, rawText, buildJavadoc);
        this.focalPoint = focalPoint;
    }

    CompilationUnit convertCompilationUnit() {
        return this.convertCompilationUnit(this.javacCompilationUnit);
    }

    CompilationUnit convertCompilationUnit(JCTree.JCCompilationUnit javacCompilationUnit) {
        CompilationUnit res = this.ast.newCompilationUnit();
        this.populateCompilationUnit(res, javacCompilationUnit);
        return res;
    }

    void populateCompilationUnit(CompilationUnit res, JCTree.JCCompilationUnit javacCompilationUnit) {
        JCTree.JCErroneous jcer;
        PackageDeclaration possible;
        JCTree jCTree;
        this.commonSettings((ASTNode)res, javacCompilationUnit);
        res.setSourceRange(0, this.rawText.length());
        res.setLineEndTable(this.toLineEndPosTable(javacCompilationUnit.getLineMap(), res.getLength()));
        if (javacCompilationUnit.getPackage() != null) {
            res.setPackage(this.convert(javacCompilationUnit.getPackage()));
        } else if (javacCompilationUnit.defs != null && javacCompilationUnit.defs.size() > 0 && (jCTree = javacCompilationUnit.defs.get(0)) instanceof JCTree.JCErroneous && (possible = this.convertMalformedPackageDeclaration(jcer = (JCTree.JCErroneous)jCTree)) != null) {
            res.setPackage(possible);
        }
        if (javacCompilationUnit.getModule() != null && this.ast.apiLevel >= 9) {
            res.setModule(this.convert(javacCompilationUnit.getModuleDecl()));
        }
        javacCompilationUnit.getImports().stream().filter(imp -> imp instanceof JCTree.JCImport).map(jc -> this.convert((JCTree.JCImport)jc)).forEach(res.imports()::add);
        if (this.ast.apiLevel >= 23) {
            javacCompilationUnit.getImports().stream().filter(imp -> imp instanceof JCTree.JCModuleImport).map(jc -> this.convert((JCTree.JCModuleImport)jc)).forEach(res.imports()::add);
        }
        javacCompilationUnit.getTypeDecls().stream().map(n -> this.convertBodyDeclaration((JCTree)n, (ASTNode)res, false)).filter(Objects::nonNull).forEach(res.types()::add);
        res.accept((ASTVisitor)new FixPositions(this));
    }

    private PackageDeclaration convertMalformedPackageDeclaration(JCTree.JCErroneous jcer) {
        if (jcer.errs != null && jcer.errs.size() > 0 && jcer.errs.get(0) instanceof JCTree.JCModifiers) {
            String possiblePackageDecl;
            int errEndPos = jcer.getEndPosition(this.javacCompilationUnit.endPositions);
            String string = possiblePackageDecl = this.rawText.length() > errEndPos + 7 ? this.rawText.substring(errEndPos, errEndPos + 7) : null;
            if ("package".equals(possiblePackageDecl)) {
                int newLine = this.rawText.indexOf("\n", errEndPos);
                String decl = null;
                decl = newLine != -1 ? this.rawText.substring(errEndPos, newLine).trim() : this.rawText.substring(errEndPos);
                String pkgName = decl.substring(7).trim();
                if (pkgName.endsWith(";")) {
                    pkgName = pkgName.substring(0, pkgName.length() - 1);
                }
                PackageDeclaration res = this.ast.newPackageDeclaration();
                res.setName(JavacConverter.toName(pkgName, 0, this.ast));
                this.setJavadocForNode(jcer, (ASTNode)res);
                res.setSourceRange(errEndPos, Math.max(0, pkgName.length()));
                res.setFlags(res.getFlags() | 1);
                return res;
            }
        }
        return null;
    }

    private int[] toLineEndPosTable(Position.LineMap lineMap, int fileLength) {
        ArrayList<Integer> lineEnds = new ArrayList<Integer>();
        int line = 1;
        try {
            while (true) {
                lineEnds.add(lineMap.getStartPosition(line + 1) - 1);
                ++line;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            lineEnds.add(fileLength - 1);
            return lineEnds.stream().mapToInt(Integer::intValue).toArray();
        }
    }

    private PackageDeclaration convert(JCTree.JCPackageDecl javac) {
        PackageDeclaration res = this.ast.newPackageDeclaration();
        res.setName(this.toName(javac.getPackageName()));
        this.commonSettings((ASTNode)res, javac);
        Iterator<JCTree.JCAnnotation> it = javac.annotations.iterator();
        while (it.hasNext()) {
            res.annotations().add(this.convert(it.next()));
        }
        String raw = this.rawText.substring(res.getStartPosition(), res.getStartPosition() + res.getLength());
        if (!raw.trim().endsWith(";")) {
            res.setFlags(res.getFlags() | 1);
        }
        return res;
    }

    private ModuleDeclaration convert(JCTree.JCModuleDecl javac) {
        int ind;
        String prefix;
        int start;
        ModuleDeclaration res = this.ast.newModuleDeclaration();
        res.setName(this.toName(javac.getName()));
        this.domToJavac.put((ASTNode)res.getName(), javac);
        boolean isOpen = javac.getModuleType() == ModuleTree.ModuleKind.OPEN;
        res.setOpen(isOpen);
        if (javac.getDirectives() != null) {
            java.util.List directives = javac.getDirectives();
            for (int i = 0; i < directives.size(); ++i) {
                JCTree.JCDirective jcDirective = (JCTree.JCDirective)directives.get(i);
                res.moduleStatements().add(this.convert(jcDirective));
            }
        }
        this.commonSettings((ASTNode)res, javac);
        if (isOpen && !this.rawText.substring(start = res.getStartPosition()).trim().startsWith("open") && (prefix = this.rawText.substring(0, start)).trim().endsWith("open") && (ind = new StringBuffer().append(prefix).reverse().toString().indexOf("nepo")) != -1) {
            int gap = ind + 4;
            res.setSourceRange(res.getStartPosition() - gap, res.getLength() + gap);
        }
        java.util.List<IExtendedModifier> l = this.convertModifierAnnotations(javac.mods, (ASTNode)res);
        res.annotations().addAll(l);
        return res;
    }

    private ModuleDirective convert(JCTree.JCDirective javac) {
        return switch (javac.getKind()) {
            case Tree.Kind.EXPORTS -> this.convert((JCTree.JCExports)javac);
            case Tree.Kind.OPENS -> this.convert((JCTree.JCOpens)javac);
            case Tree.Kind.PROVIDES -> this.convert((JCTree.JCProvides)javac);
            case Tree.Kind.REQUIRES -> this.convert((JCTree.JCRequires)javac);
            case Tree.Kind.USES -> this.convert((JCTree.JCUses)javac);
            default -> throw new IllegalStateException();
        };
    }

    private ExportsDirective convert(JCTree.JCExports javac) {
        ExportsDirective res = this.ast.newExportsStatement();
        res.setName(this.toName(javac.getPackageName()));
        this.commonSettings((ASTNode)res, javac);
        java.util.List mods = javac.getModuleNames();
        if (mods != null) {
            for (JCTree.JCExpression jcpe : mods) {
                Expression e = this.convertExpression(jcpe);
                if (e == null) continue;
                res.modules().add(e);
            }
        }
        return res;
    }

    private OpensDirective convert(JCTree.JCOpens javac) {
        OpensDirective res = this.ast.newOpensDirective();
        res.setName(this.toName(javac.getPackageName()));
        this.commonSettings((ASTNode)res, javac);
        java.util.List mods = javac.getModuleNames();
        if (mods != null) {
            for (JCTree.JCExpression jcpe : mods) {
                Expression e = this.convertExpression(jcpe);
                if (e == null) continue;
                res.modules().add(e);
            }
        }
        return res;
    }

    private ProvidesDirective convert(JCTree.JCProvides javac) {
        ProvidesDirective res = this.ast.newProvidesDirective();
        res.setName(this.toName(javac.getServiceName()));
        for (JCTree.JCExpression jcName : javac.implNames) {
            res.implementations().add(this.toName(jcName));
        }
        this.commonSettings((ASTNode)res, javac);
        return res;
    }

    private RequiresDirective convert(JCTree.JCRequires javac) {
        int trueStart;
        RequiresDirective res = this.ast.newRequiresDirective();
        res.setName(this.toName(javac.getModuleName()));
        int javacStart = javac.getStartPosition();
        ArrayList<ModuleModifier> modifiersToAdd = new ArrayList<ModuleModifier>();
        if (javac.isTransitive()) {
            ModuleModifier trans = this.ast.newModuleModifier(ModuleModifier.ModuleModifierKeyword.TRANSITIVE_KEYWORD);
            int transStart = this.rawText.substring(javacStart).indexOf(ModuleModifier.ModuleModifierKeyword.TRANSITIVE_KEYWORD.toString());
            if (transStart != -1) {
                trueStart = javacStart + transStart;
                trans.setSourceRange(trueStart, ModuleModifier.ModuleModifierKeyword.TRANSITIVE_KEYWORD.toString().length());
            }
            modifiersToAdd.add(trans);
        }
        if (javac.isStatic()) {
            ModuleModifier stat = this.ast.newModuleModifier(ModuleModifier.ModuleModifierKeyword.STATIC_KEYWORD);
            int statStart = this.rawText.substring(javacStart).indexOf(ModuleModifier.ModuleModifierKeyword.STATIC_KEYWORD.toString());
            if (statStart != -1) {
                trueStart = javacStart + statStart;
                stat.setSourceRange(trueStart, ModuleModifier.ModuleModifierKeyword.STATIC_KEYWORD.toString().length());
            }
            modifiersToAdd.add(stat);
        }
        modifiersToAdd.sort((a, b) -> a.getStartPosition() - b.getStartPosition());
        modifiersToAdd.stream().forEach(res.modifiers()::add);
        this.commonSettings((ASTNode)res, javac);
        return res;
    }

    private UsesDirective convert(JCTree.JCUses javac) {
        UsesDirective res = this.ast.newUsesDirective();
        res.setName(this.toName(javac.getServiceName()));
        this.commonSettings((ASTNode)res, javac);
        return res;
    }

    private ImportDeclaration convert(JCTree.JCImport javac) {
        JCTree.JCFieldAccess select;
        ImportDeclaration res = this.ast.newImportDeclaration();
        this.commonSettings((ASTNode)res, javac);
        if (javac.isStatic()) {
            res.setStatic(true);
        }
        if ((select = javac.getQualifiedIdentifier()).getIdentifier().contentEquals("*")) {
            res.setOnDemand(true);
            res.setName(this.toName(select.getExpression()));
        } else if (this.ast.apiLevel >= 23 && select.selected.toString().equals("module") && select.name.toString().equals(ERROR)) {
            Modifier moduleModifier = this.ast.newModifier(Modifier.ModifierKeyword.MODULE_KEYWORD);
            res.modifiers().add(moduleModifier);
            SimpleName name = new SimpleName(this.ast);
            name.setSourceRange(res.getStartPosition() + res.getLength() + 1, 0);
            res.setName((Name)name);
            res.setSourceRange(res.getStartPosition(), res.getLength() + 1);
        } else {
            res.setName(this.toName(select));
        }
        if (res.getName().toString().contains(FAKE_IDENTIFIER)) {
            res.setFlags(res.getFlags() | 1);
        }
        if (javac.isStatic() || javac.isModule()) {
            if (this.ast.apiLevel < 23) {
                if (!javac.isStatic()) {
                    res.setFlags(res.getFlags() | 1);
                }
            } else {
                Modifier.ModifierKeyword keyword = null;
                if (javac.isStatic()) {
                    keyword = Modifier.ModifierKeyword.STATIC_KEYWORD;
                    Modifier preExisting = res.modifiers().stream().filter(x -> x instanceof Modifier && ((Modifier)x).isStatic()).findFirst().orElse(null);
                    if (preExisting != null) {
                        res.modifiers().remove(preExisting);
                    }
                }
                if (javac.isModule()) {
                    keyword = Modifier.ModifierKeyword.MODULE_KEYWORD;
                }
                if (keyword != null) {
                    Modifier newModifier = this.ast.newModifier(keyword);
                    newModifier.setSourceRange(javac.getStartPosition(), keyword.toString().length());
                    res.modifiers().add(newModifier);
                } else {
                    res.setFlags(res.getFlags() | 1);
                }
            }
        }
        return res;
    }

    private ImportDeclaration convert(JCTree.JCModuleImport javac) {
        ImportDeclaration res = this.ast.newImportDeclaration();
        this.commonSettings((ASTNode)res, (JCTree)javac);
        Modifier moduleModifier = this.ast.newModifier(Modifier.ModifierKeyword.MODULE_KEYWORD);
        res.modifiers().add(moduleModifier);
        if (javac.isStatic()) {
            res.setStatic(true);
        }
        JCTree.JCExpression select = javac.getQualifiedIdentifier();
        res.setName(this.toName(select));
        return res;
    }

    void commonSettings(ASTNode res, JCTree javac) {
        if (javac != null) {
            int length = this.commonSettingsGetLength(res, javac);
            this.commonSettings(res, javac, length, true);
        }
    }

    int commonSettingsGetLength(ASTNode res, JCTree javac) {
        int length = -1;
        if (javac != null) {
            int start = javac.getStartPosition();
            if (start >= 0) {
                int endPos = javac.getEndPosition(this.javacCompilationUnit.endPositions);
                if (endPos < 0) {
                    endPos = start + javac.toString().length();
                }
                if (res instanceof Name || res instanceof FieldAccess || res instanceof SuperFieldAccess) {
                    while (endPos > start && this.rawText.length() >= endPos && this.rawText.charAt(endPos - 1) == ';') {
                        --endPos;
                    }
                }
                if (start + Math.max(0, length = endPos - start) > this.rawText.length()) {
                    length = this.rawText.length() - start;
                }
            }
            return Math.max(0, length);
        }
        return length;
    }

    void commonSettings(ASTNode res, JCTree javac, int length, boolean removeWhitespace) {
        if (javac != null && length >= 0) {
            if (javac.getStartPosition() >= 0) {
                res.setSourceRange(javac.getStartPosition(), Math.max(0, length));
            }
            if (removeWhitespace) {
                this.removeSurroundingWhitespaceFromRange(res);
            }
            this.domToJavac.put(res, javac);
            this.setJavadocForNode(javac, res);
        }
    }

    private void nameSettings(SimpleName name, JCTree.JCMethodDecl javac, String selector, boolean isConstructor) {
        if (selector.equals(ERROR) || selector.equals(FAKE_IDENTIFIER)) {
            return;
        }
        int start = javac.getPreferredPosition();
        if (start > -1) {
            int length = isConstructor ? name.toString().length() : selector.length();
            name.setSourceRange(start, length);
        } else {
            name.setSourceRange(0, 0);
        }
    }

    private void nameSettings(SimpleName name, JCTree.JCVariableDecl javac, String varName) {
        if (varName.equals(ERROR) || varName.equals(FAKE_IDENTIFIER)) {
            return;
        }
        int start = javac.getPreferredPosition();
        if (start > -1) {
            name.setSourceRange(start, varName.length());
        } else {
            name.setSourceRange(0, 0);
        }
    }

    private Name toName(JCTree expression) {
        return this.toName(expression, null);
    }

    Name toName(JCTree expression, BiConsumer<ASTNode, JCTree> extraSettings) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)expression;
            Name res = this.convertName(ident.getName());
            this.commonSettings((ASTNode)res, expression);
            if (extraSettings != null) {
                extraSettings.accept((ASTNode)res, ident);
            }
            return res;
        }
        if (expression instanceof JCTree.JCFieldAccess) {
            int nameIndex;
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)expression;
            JCTree.JCExpression faExpression = fieldAccess.getExpression();
            SimpleName n = (SimpleName)this.convertName(fieldAccess.getIdentifier());
            if (n == null) {
                n = this.ast.newSimpleName(FAKE_IDENTIFIER);
                n.setFlags(8);
            }
            this.commonSettings((ASTNode)n, fieldAccess);
            Name qualifier = this.toName(faExpression, extraSettings);
            QualifiedName res = this.ast.newQualifiedName(qualifier, n);
            this.commonSettings((ASTNode)res, fieldAccess);
            if (extraSettings != null) {
                extraSettings.accept((ASTNode)res, fieldAccess);
            }
            if (!fieldAccess.getIdentifier().contentEquals(FAKE_IDENTIFIER) && !fieldAccess.getIdentifier().contentEquals(ERROR) && (nameIndex = this.rawText.indexOf(fieldAccess.getIdentifier().toString(), qualifier.getStartPosition() + qualifier.getLength())) >= 0) {
                n.setSourceRange(nameIndex, fieldAccess.getIdentifier().toString().length());
            }
            return res;
        }
        if (expression instanceof JCTree.JCAnnotatedType) {
            JCTree.JCAnnotatedType jcat = (JCTree.JCAnnotatedType)expression;
            Name n = this.toName(jcat.underlyingType, extraSettings);
            this.commonSettings((ASTNode)n, jcat.underlyingType);
            return n;
        }
        if (expression instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply jcta = (JCTree.JCTypeApply)expression;
            Name n = this.toName(jcta.clazz, extraSettings);
            this.commonSettings((ASTNode)n, jcta.clazz);
            return n;
        }
        throw new UnsupportedOperationException((String)("toName for " + String.valueOf(expression) + " (" + String.valueOf(expression) == null ? "null" : expression.getClass().getName() + ")"));
    }

    private AbstractTypeDeclaration convertClassDecl(JCTree.JCClassDecl javacClassDecl, ASTNode parent, boolean parentBodyFilled) {
        if (javacClassDecl.getKind() == Tree.Kind.ANNOTATION_TYPE && this.ast.scanner.complianceLevel < 0x310000L) {
            return null;
        }
        if (javacClassDecl.getKind() == Tree.Kind.ENUM && this.ast.scanner.complianceLevel < 0x310000L) {
            return null;
        }
        if (javacClassDecl.getKind() == Tree.Kind.RECORD && (this.ast.apiLevel < 16 || this.ast.scanner.complianceLevel < 0x3C0000L)) {
            return null;
        }
        AnnotationTypeDeclaration res = switch (javacClassDecl.getKind()) {
            case Tree.Kind.ANNOTATION_TYPE -> this.ast.newAnnotationTypeDeclaration();
            case Tree.Kind.ENUM -> this.ast.newEnumDeclaration();
            case Tree.Kind.RECORD -> this.ast.newRecordDeclaration();
            case Tree.Kind.INTERFACE -> {
                TypeDeclaration decl = this.ast.newTypeDeclaration();
                decl.setInterface(true);
                yield decl;
            }
            case Tree.Kind.CLASS -> {
                if (javacClassDecl.getModifiers() != null && (javacClassDecl.getModifiers().flags & 0x80000L) != 0L) {
                    yield new ImplicitTypeDeclaration(this.ast);
                }
                yield this.ast.newTypeDeclaration();
            }
            default -> throw new IllegalStateException();
        };
        return this.convertClassDecl(javacClassDecl, parent, (AbstractTypeDeclaration)res, parentBodyFilled);
    }

    private AbstractTypeDeclaration convertClassDecl(JCTree.JCClassDecl javacClassDecl, ASTNode parent, AbstractTypeDeclaration res, boolean parentBodyFilled) {
        this.commonSettings((ASTNode)res, javacClassDecl);
        SimpleName simpName = (SimpleName)this.convertName(javacClassDecl.getSimpleName());
        if (!(res instanceof ImplicitTypeDeclaration) && simpName != null) {
            int namePosition;
            res.setName(simpName);
            int searchNameFrom = javacClassDecl.getPreferredPosition();
            if (javacClassDecl.getModifiers() != null) {
                searchNameFrom = Math.max(searchNameFrom, TreeInfo.getEndPos(javacClassDecl.getModifiers(), this.javacCompilationUnit.endPositions));
            }
            if ((namePosition = this.rawText.indexOf(simpName.getIdentifier(), searchNameFrom)) >= 0) {
                simpName.setSourceRange(namePosition, simpName.getIdentifier().length());
            } else if (!MISSING_IDENTIFIER.equals(simpName.getFullyQualifiedName()) && DOMCodeSelector.isGenerated((ASTNode)res)) {
                simpName.setSourceRange(0, 0);
            }
        }
        res.modifiers().addAll(this.convert(javacClassDecl.mods, (ASTNode)res));
        if (res instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)res;
            if (javacClassDecl.getExtendsClause() != null) {
                typeDeclaration.setSuperclassType(this.convertToType(javacClassDecl.getExtendsClause()));
            }
            if (javacClassDecl.getImplementsClause() != null) {
                javacClassDecl.getImplementsClause().stream().map(this::convertToType).filter(Objects::nonNull).forEach(typeDeclaration.superInterfaceTypes()::add);
            }
            if (javacClassDecl.getTypeParameters() != null) {
                for (JCTree.JCTypeParameter next : javacClassDecl.getTypeParameters()) {
                    typeDeclaration.typeParameters().add(this.convert(next));
                }
            }
            if (javacClassDecl.getPermitsClause() != null && this.ast.apiLevel >= 17) {
                javacClassDecl.getPermitsClause().stream().map(this::convertToType).filter(Objects::nonNull).forEach(typeDeclaration.permittedTypes()::add);
                if (!((List)javacClassDecl.getPermitsClause()).isEmpty()) {
                    int permitsOffset = this.rawText.substring(javacClassDecl.pos).indexOf("permits") + javacClassDecl.pos;
                    typeDeclaration.setRestrictedIdentifierStartPosition(permitsOffset);
                }
            }
            if (javacClassDecl.getMembers() != null) {
                java.util.List members = javacClassDecl.getMembers();
                ASTNode previous = null;
                for (int i = 0; i < members.size(); ++i) {
                    ASTNode decl = this.convertBodyDeclaration((JCTree)members.get(i), (ASTNode)res, parentBodyFilled);
                    if (decl == null) continue;
                    typeDeclaration.bodyDeclarations().add(decl);
                    if (previous != null) {
                        int istart = decl.getStartPosition();
                        int siblingEnds = previous.getStartPosition() + previous.getLength();
                        if (previous.getStartPosition() >= 0 && siblingEnds > istart && istart > previous.getStartPosition()) {
                            previous.setSourceRange(previous.getStartPosition(), istart - previous.getStartPosition() - 1);
                        }
                    }
                    previous = decl;
                }
            }
        } else if (res instanceof EnumDeclaration) {
            EnumDeclaration enumDecl = (EnumDeclaration)res;
            java.util.List enumStatements = enumDecl.enumConstants();
            if (javacClassDecl.getMembers() != null) {
                for (JCTree member2 : javacClassDecl.getMembers()) {
                    EnumConstantDeclaration dec1 = this.convertEnumConstantDeclaration(member2, parent, enumDecl);
                    if (dec1 != null) {
                        enumStatements.add(dec1);
                        continue;
                    }
                    ASTNode bodyDecl = this.convertBodyDeclaration(member2, (ASTNode)res, parentBodyFilled);
                    if (bodyDecl == null) continue;
                    res.bodyDeclarations().add(bodyDecl);
                }
            }
        } else if (res instanceof AnnotationTypeDeclaration) {
            AnnotationTypeDeclaration annotDecl = (AnnotationTypeDeclaration)res;
            SimpleName name = new SimpleName(this.ast);
            name.internalSetIdentifier(new String(annotDecl.typeName.toString()));
            res.setName(name);
            if (javacClassDecl.defs != null) {
                Iterator<JCTree> i = javacClassDecl.defs.iterator();
                while (i.hasNext()) {
                    ASTNode converted = this.convertBodyDeclaration(i.next(), (ASTNode)res, parentBodyFilled);
                    if (converted == null) continue;
                    res.bodyDeclarations.add((Object)converted);
                }
            }
        } else if (res instanceof RecordDeclaration) {
            RecordDeclaration recordDecl = (RecordDeclaration)res;
            int start = javacClassDecl.getPreferredPosition();
            if (start != -1) {
                recordDecl.setRestrictedIdentifierStartPosition(start);
            }
            for (JCTree node : javacClassDecl.getMembers()) {
                JCTree.JCVariableDecl vd;
                if (node instanceof JCTree.JCVariableDecl && !(vd = (JCTree.JCVariableDecl)node).getModifiers().getFlags().contains((Object)javax.lang.model.element.Modifier.STATIC)) {
                    SingleVariableDeclaration vdd = (SingleVariableDeclaration)this.convertVariableDeclaration(vd);
                    vdd.modifiers().clear();
                    vdd.modifiers().addAll(this.convertModifierAnnotations(vd.getModifiers(), (ASTNode)vdd));
                    recordDecl.recordComponents().add(vdd);
                    continue;
                }
                ASTNode converted = this.convertBodyDeclaration(node, (ASTNode)res, parentBodyFilled);
                if (converted == null) continue;
                res.bodyDeclarations.add((Object)converted);
            }
        } else if (res instanceof ImplicitTypeDeclaration) {
            javacClassDecl.getMembers().stream().map(member -> this.convertBodyDeclaration((JCTree)member, (ASTNode)res, parentBodyFilled)).filter(Objects::nonNull).forEach(res.bodyDeclarations()::add);
        }
        return res;
    }

    private TypeParameter convert(JCTree.JCTypeParameter typeParameter) {
        TypeParameter ret = new TypeParameter(this.ast);
        this.commonSettings((ASTNode)ret, typeParameter);
        SimpleName simpleName = new SimpleName(this.ast);
        simpleName.internalSetIdentifier(typeParameter.getName().toString());
        int start = typeParameter.pos;
        int end = typeParameter.pos + typeParameter.getName().length();
        simpleName.setSourceRange(start, end - start);
        ret.setName(simpleName);
        java.util.List bounds = typeParameter.getBounds();
        for (JCTree t : bounds) {
            Type type = this.convertToType(t);
            ret.typeBounds().add(type);
            end = typeParameter.getEndPosition(this.javacCompilationUnit.endPositions);
        }
        if (typeParameter.getAnnotations() != null) {
            typeParameter.getAnnotations().stream().map(this::convert).forEach(ret.modifiers()::add);
        }
        ret.setSourceRange(start, end - start);
        return ret;
    }

    private ASTNode convertBodyDeclaration(JCTree tree, ASTNode parent, boolean parentBodyFilled) {
        if (parent instanceof AnnotationTypeDeclaration && tree instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)tree;
            return this.convertMethodInAnnotationTypeDecl(methodDecl, parent);
        }
        if (tree instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)tree;
            return this.convertMethodDecl(methodDecl, parent, parentBodyFilled);
        }
        if (tree instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)tree;
            return this.convertClassDecl(jcClassDecl, parent, parentBodyFilled);
        }
        if (tree instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)tree;
            return this.convertFieldDeclaration(jcVariableDecl, parent);
        }
        if (tree instanceof JCTree.JCBlock) {
            JCTree.JCBlock block = (JCTree.JCBlock)tree;
            Initializer res = this.ast.newInitializer();
            this.commonSettings((ASTNode)res, tree);
            res.modifiers().addAll(this.convertModifiersFromFlags(block.getStartPosition(), block.endpos, block.flags));
            boolean fillBlock = this.shouldFillBlock(block, this.focalPoint);
            if (fillBlock) {
                res.setBody(this.convertBlock(block));
            } else {
                Block b = this.ast.newBlock();
                this.commonSettings((ASTNode)res, block);
                res.setBody(b);
            }
            return res;
        }
        if (tree instanceof JCTree.JCErroneous || tree instanceof JCTree.JCSkip) {
            return null;
        }
        ILog.get().error("Unsupported " + String.valueOf(tree) + " of type" + String.valueOf(tree.getClass()));
        Block substitute = this.ast.newBlock();
        this.commonSettings((ASTNode)substitute, tree);
        return substitute;
    }

    private ASTNode convertMethodInAnnotationTypeDecl(JCTree.JCMethodDecl javac, ASTNode parent) {
        Name name;
        AnnotationTypeMemberDeclaration res = new AnnotationTypeMemberDeclaration(this.ast);
        this.commonSettings((ASTNode)res, javac);
        res.modifiers().addAll(this.convert(javac.getModifiers(), (ASTNode)res));
        res.setType(this.convertToType(javac.getReturnType()));
        if (javac.defaultValue != null) {
            res.setDefault(this.convertExpression(javac.defaultValue));
        }
        if ((name = this.convertName(javac.getName())) instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)name;
            res.setName(simpleName);
            int start = javac.getPreferredPosition();
            if (start > -1) {
                simpleName.setSourceRange(start, javac.getName().toString().length());
            }
        }
        return res;
    }

    private String getNodeName(ASTNode node) {
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration atd = (AbstractTypeDeclaration)node;
            return atd.getName().toString();
        }
        if (node instanceof EnumDeclaration) {
            EnumDeclaration ed = (EnumDeclaration)node;
            return ed.getName().toString();
        }
        return null;
    }

    private String getMethodDeclName(JCTree.JCMethodDecl javac, ASTNode parent, boolean records) {
        String name = javac.getName().toString();
        boolean javacIsConstructor = Objects.equals(javac.getName(), Names.instance((Context)this.context).init);
        if (javacIsConstructor) {
            String methodName;
            String parentName = this.getNodeName(parent);
            String tmpString1 = this.rawText.substring(javac.pos);
            int openParen = tmpString1.indexOf("(");
            int openBrack = tmpString1.indexOf("{");
            int endPos = -1;
            if (openParen != -1) {
                endPos = openParen;
            }
            if (records && openBrack != -1) {
                int n = endPos = endPos == -1 ? openBrack : Math.min(openBrack, endPos);
            }
            if (endPos != -1 && !(methodName = tmpString1.substring(0, endPos).trim()).isEmpty() && Character.isJavaIdentifierStart(methodName.charAt(0)) && methodName.substring(1).chars().allMatch(Character::isJavaIdentifierPart) && !methodName.equals(parentName)) {
                return methodName;
            }
            return parentName;
        }
        return name;
    }

    private MethodDeclaration convertMethodDecl(JCTree.JCMethodDecl javac, ASTNode parent, boolean parentBodyFilled) {
        boolean generatedByLombok;
        java.util.List<Dimension> dims;
        if (TreeInfo.getEndPos(javac, this.javacCompilationUnit.endPositions) <= javac.getStartPosition()) {
            return null;
        }
        MethodDeclaration res = this.ast.newMethodDeclaration();
        this.commonSettings((ASTNode)res, javac);
        res.modifiers().addAll(this.convert(javac.getModifiers(), (ASTNode)res));
        String javacName = javac.getName().toString();
        String methodDeclName = this.getMethodDeclName(javac, parent, parent instanceof RecordDeclaration);
        boolean methodDeclNameMatchesInit = Objects.equals(methodDeclName, Names.instance((Context)this.context).init.toString());
        boolean javacNameMatchesInit = javacName.equals("<init>");
        boolean javacNameMatchesError = javacName.endsWith(ERROR);
        boolean javacNameMatchesInitAndMethodNameMatchesTypeName = javacNameMatchesInit && methodDeclName.equals(this.getNodeName(parent));
        boolean isConstructor = methodDeclNameMatchesInit || javacNameMatchesInitAndMethodNameMatchesTypeName;
        res.setConstructor(isConstructor);
        if (isConstructor && ((List)javac.getParameters()).isEmpty() && javac.getBody() != null && javac.getBody().endpos == -1) {
            return null;
        }
        boolean isCompactConstructor = false;
        if (isConstructor && parent instanceof RecordDeclaration) {
            String postName = this.rawText.substring(javac.pos + methodDeclName.length()).trim();
            String firstChar = postName != null && postName.length() > 0 ? postName.substring(0, 1) : null;
            isCompactConstructor = "{".equals(firstChar);
            if (this.ast.apiLevel >= 16) {
                res.setCompactConstructor(isCompactConstructor);
            }
        }
        boolean malformed = false;
        if (isConstructor && !javacNameMatchesInitAndMethodNameMatchesTypeName) {
            malformed = true;
        }
        if (javacNameMatchesError || javacNameMatchesInit && !isConstructor) {
            malformed = true;
        }
        JCTree retTypeTree = javac.getReturnType();
        Type retType = null;
        if (!javacNameMatchesError) {
            SimpleName name = this.ast.newSimpleName(methodDeclName);
            this.nameSettings(name, javac, methodDeclName, isConstructor);
            res.setName(name);
        } else if (retTypeTree instanceof JCTree.JCIdent) {
            JCTree.JCIdent jcid = (JCTree.JCIdent)retTypeTree;
            SimpleName name = this.ast.newSimpleName(jcid.getName().toString());
            this.nameSettings(name, javac, javacName, isConstructor);
            res.setName(name);
            retTypeTree = null;
            if (jcid.toString().equals(this.getNodeName(parent))) {
                res.setConstructor(true);
                isConstructor = true;
            }
        }
        if (retTypeTree != null) {
            retType = this.convertToType(retTypeTree);
        }
        if (!(dims = this.convertDimensionsAfterPosition(retTypeTree, javac.pos)).isEmpty() && retTypeTree.pos > javac.pos) {
            res.extraDimensions().addAll(dims);
            retType = this.convertToType(this.unwrapDimensions(retTypeTree, dims.size()));
        }
        if (retType != null || isConstructor) {
            res.setReturnType2(retType);
        } else {
            res.setReturnType2(null);
        }
        if (!isCompactConstructor) {
            javac.getParameters().stream().map(this::convertVariableDeclaration).forEach(res.parameters()::add);
        }
        if (javac.getReceiverParameter() != null) {
            JCTree.JCExpression jCExpression;
            Type receiverType = this.convertToType(javac.getReceiverParameter().getType());
            if (receiverType instanceof AnnotatableType) {
                AnnotatableType annotable = (AnnotatableType)receiverType;
                javac.getReceiverParameter().getModifiers().getAnnotations().stream().map(this::convert).forEach(annotable.annotations()::add);
            }
            if (receiverType != null) {
                res.setReceiverType(receiverType);
            }
            if ((jCExpression = javac.getReceiverParameter().getNameExpression()) instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess qualifiedName = (JCTree.JCFieldAccess)jCExpression;
                res.setReceiverQualifier((SimpleName)this.toName(qualifiedName.getExpression()));
            }
        }
        if (javac.getTypeParameters() != null) {
            for (JCTree.JCTypeParameter next : javac.getTypeParameters()) {
                res.typeParameters().add(this.convert(next));
            }
        }
        boolean bl = generatedByLombok = javac.getModifiers() != null && javac.getModifiers().toString().contains("@lombok.Generated");
        if (!generatedByLombok && javac.getBody() != null && javac.getBody().endpos > javac.getBody().getStartPosition()) {
            boolean fillBlock = this.shouldFillBlock(javac, this.focalPoint);
            boolean bl2 = fillBlock = parentBodyFilled || fillBlock;
            if (fillBlock) {
                b = this.convertBlock(javac.getBody());
                if (b != null) {
                    boolean notAllowed;
                    TypeDeclaration td1;
                    AbstractTypeDeclaration td = this.findSurroundingTypeDeclaration(parent);
                    boolean isInterface = td instanceof TypeDeclaration && (td1 = (TypeDeclaration)td).isInterface();
                    long modFlags = javac.getModifiers() == null ? 0L : javac.getModifiers().flags;
                    boolean isAbstractOrNative = (modFlags & 0x500L) != 0L;
                    boolean isJlsAbove8 = this.ast.apiLevel > 8;
                    long flagsToCheckForAboveJLS8 = 0x80000000008L | (long)(isJlsAbove8 ? 2 : 0);
                    boolean bl3 = notAllowed = isAbstractOrNative || isInterface && (modFlags & flagsToCheckForAboveJLS8) == 0L;
                    if (notAllowed) {
                        res.setFlags(res.getFlags() | 1);
                    }
                    res.setBody(b);
                    if ((b.getFlags() & 1) > 0) {
                        malformed = true;
                    }
                }
            } else {
                b = this.ast.newBlock();
                this.commonSettings((ASTNode)res, javac);
                res.setBody(b);
            }
        }
        for (JCTree.JCExpression thrown : javac.getThrows()) {
            Type type = this.convertToType(thrown);
            if (type == null) continue;
            res.thrownExceptionTypes().add(type);
        }
        if (malformed) {
            res.setFlags(res.getFlags() | 1);
        }
        return res;
    }

    private boolean shouldFillBlock(JCTree tree, int focalPoint2) {
        int start = tree.getStartPosition();
        int endPos = tree.getEndPosition(this.javacCompilationUnit.endPositions);
        return this.focalPoint == -1 || this.focalPoint >= start && this.focalPoint <= endPos;
    }

    private AbstractTypeDeclaration findSurroundingTypeDeclaration(ASTNode parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration t = (AbstractTypeDeclaration)parent;
            return t;
        }
        return this.findSurroundingTypeDeclaration(parent.getParent());
    }

    private VariableDeclaration convertVariableDeclarationForLambda(JCTree.JCVariableDecl javac) {
        if (javac.getType() == null && javac.getStartPosition() == javac.getPreferredPosition()) {
            return this.createVariableDeclarationFragment(javac);
        }
        if (javac.getType() != null && javac.getType().getPreferredPosition() == -1) {
            return this.createVariableDeclarationFragment(javac);
        }
        return this.convertVariableDeclaration(javac);
    }

    private VariableDeclaration convertVariableDeclaration(JCTree.JCVariableDecl javac) {
        java.util.List<Dimension> dims;
        SingleVariableDeclaration res = this.ast.newSingleVariableDeclaration();
        this.commonSettings((ASTNode)res, javac);
        Name name = this.convertName(javac.getName());
        if (name instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)name;
            this.nameSettings(simpleName, javac, simpleName.toString());
            res.setName(simpleName);
        }
        res.modifiers().addAll(this.convert(javac.getModifiers(), (ASTNode)res));
        JCTree type = javac.getType();
        if (type instanceof JCTree.JCAnnotatedType) {
            JCTree.JCAnnotatedType annotatedType = (JCTree.JCAnnotatedType)type;
            annotatedType.getAnnotations().stream().map(this::convert).forEach(res.varargsAnnotations()::add);
            type = annotatedType.getUnderlyingType();
        }
        if ((javac.mods.flags & 0x400000000L) != 0L) {
            if (type instanceof JCTree.JCArrayTypeTree) {
                JCTree.JCArrayTypeTree arr = (JCTree.JCArrayTypeTree)type;
                type = this.unwrapDimensions(arr, 1);
            }
            res.setVarargs(true);
        }
        if (!(dims = this.convertDimensionsAfterPosition(javac.getType(), javac.getPreferredPosition())).isEmpty()) {
            res.extraDimensions().addAll(dims);
            type = this.unwrapDimensions(type, dims.size());
        }
        if (type != null) {
            Type converted;
            if (!(type instanceof JCTree.JCErroneous) && (converted = this.convertToType(type)) != null) {
                res.setType(converted);
            }
        } else if (javac.getStartPosition() != javac.getPreferredPosition() && this.rawText.substring(javac.getStartPosition(), javac.getPreferredPosition()).matches("var(\\s)+")) {
            SimpleName varName = this.ast.newSimpleName("var");
            varName.setSourceRange(javac.getStartPosition(), varName.getIdentifier().length());
            SimpleType varType = this.ast.newSimpleType((Name)varName);
            varType.setSourceRange(varName.getStartPosition(), varName.getLength());
            res.setType((Type)varType);
        }
        if (javac.getInitializer() != null) {
            res.setInitializer(this.convertExpression(javac.getInitializer()));
        }
        return res;
    }

    private VariableDeclarationFragment createVariableDeclarationFragment(JCTree.JCVariableDecl javac) {
        Expression initializer;
        VariableDeclarationFragment fragment = this.ast.newVariableDeclarationFragment();
        this.commonSettings((ASTNode)fragment, javac);
        int fragmentEnd = javac.getEndPosition(this.javacCompilationUnit.endPositions);
        int fragmentStart = javac.pos;
        int fragmentLength = fragmentEnd - fragmentStart;
        fragment.setSourceRange(fragmentStart, Math.max(0, fragmentLength));
        this.removeSurroundingWhitespaceFromRange((ASTNode)fragment);
        this.removeTrailingCharFromRange((ASTNode)fragment, new char[]{';', ','});
        this.removeSurroundingWhitespaceFromRange((ASTNode)fragment);
        Name name = this.convertName(javac.getName());
        if (name instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)name;
            fragment.setName(simpleName);
        }
        java.util.List<Dimension> dims = this.convertDimensionsAfterPosition(javac.getType(), fragmentStart);
        fragment.extraDimensions().addAll(dims);
        if (javac.getInitializer() != null && (initializer = this.convertExpression(javac.getInitializer())) != null) {
            fragment.setInitializer(initializer);
            int length = initializer.getStartPosition() + initializer.getLength() - fragment.getStartPosition();
            if (length >= 0) {
                fragment.setSourceRange(fragment.getStartPosition(), length);
            }
        }
        return fragment;
    }

    private FieldDeclaration convertFieldDeclaration(JCTree.JCVariableDecl javac, ASTNode parent) {
        SimpleName fragName;
        SimpleName simpleName;
        SimpleName sn;
        SimpleType st;
        Name name;
        AbstractTypeDeclaration decl;
        VariableDeclarationFragment fragment = this.createVariableDeclarationFragment(javac);
        ArrayList sameStartPosition = new ArrayList();
        if (parent instanceof AbstractTypeDeclaration) {
            decl = (AbstractTypeDeclaration)parent;
            decl.bodyDeclarations().stream().filter(x -> x instanceof FieldDeclaration).filter(x -> ((FieldDeclaration)x).getType().getStartPosition() == javac.vartype.getStartPosition()).forEach(x -> sameStartPosition.add((ASTNode)x));
        }
        if (parent instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)parent;
            decl.bodyDeclarations().stream().filter(x -> x instanceof FieldDeclaration).filter(x -> ((FieldDeclaration)x).getType().getStartPosition() == javac.vartype.getStartPosition()).forEach(x -> sameStartPosition.add((ASTNode)x));
        }
        if (sameStartPosition.size() >= 1) {
            FieldDeclaration fd = (FieldDeclaration)sameStartPosition.get(0);
            if (fd != null) {
                fd.fragments().add(fragment);
                int newParentEnd = fragment.getStartPosition() + fragment.getLength();
                fd.setSourceRange(fd.getStartPosition(), newParentEnd - fd.getStartPosition() + 1);
            }
            return null;
        }
        FieldDeclaration res = this.ast.newFieldDeclaration(fragment);
        this.commonSettings((ASTNode)res, javac);
        res.modifiers().addAll(this.convert(javac.getModifiers(), (ASTNode)res));
        Type resType = this.convertToType(this.unwrapDimensions(javac.getType(), fragment.getExtraDimensions()));
        if (resType != null) {
            res.setType(resType);
        }
        if (javac.getType() instanceof JCTree.JCErroneous && resType instanceof SimpleType && (name = (st = (SimpleType)resType).getName()) instanceof SimpleName && (sn = (SimpleName)name).toString().equals(FAKE_IDENTIFIER) && (simpleName = fragment.getName()) instanceof SimpleName && (fragName = simpleName).toString().equals(FAKE_IDENTIFIER)) {
            return null;
        }
        return res;
    }

    private void setJavadocForNode(JCTree javac, ASTNode node) {
        Tokens.Comment c = this.javacCompilationUnit.docComments.getComment(javac);
        if (c != null && (c.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_BLOCK || c.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE)) {
            Comment comment = this.convert(c, javac);
            if (!(comment instanceof Javadoc)) {
                return;
            }
            Javadoc javadoc = (Javadoc)comment;
            if (node instanceof BodyDeclaration) {
                BodyDeclaration bodyDeclaration = (BodyDeclaration)node;
                bodyDeclaration.setJavadoc(javadoc);
                bodyDeclaration.setSourceRange(javadoc.getStartPosition(), bodyDeclaration.getStartPosition() + bodyDeclaration.getLength() - javadoc.getStartPosition());
            } else if (node instanceof ModuleDeclaration) {
                ModuleDeclaration moduleDeclaration = (ModuleDeclaration)node;
                moduleDeclaration.setJavadoc(javadoc);
                moduleDeclaration.setSourceRange(javadoc.getStartPosition(), moduleDeclaration.getStartPosition() + moduleDeclaration.getLength() - javadoc.getStartPosition());
            } else if (node instanceof PackageDeclaration) {
                PackageDeclaration packageDeclaration = (PackageDeclaration)node;
                packageDeclaration.setJavadoc(javadoc);
                packageDeclaration.setSourceRange(javadoc.getStartPosition(), packageDeclaration.getStartPosition() + packageDeclaration.getLength() - javadoc.getStartPosition());
            } else {
                this.notAttachedComments.add((Comment)javadoc);
            }
        }
    }

    private Expression convertExpressionImpl(JCTree.JCExpression javac) {
        if (javac instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javac;
            if (Objects.equals(ident.name, Names.instance((Context)this.context)._this)) {
                ThisExpression res = this.ast.newThisExpression();
                this.commonSettings((ASTNode)res, javac);
                return res;
            }
            return this.toName(ident);
        }
        if (javac instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral literal = (JCTree.JCLiteral)javac;
            return this.convertLiteral(literal);
        }
        if (javac instanceof JCTree.JCFieldAccess) {
            Object oldestIdentifier;
            JCTree.JCFieldAccess fieldAccess;
            block118: {
                JCTree.JCExpression cursor;
                JCTree.JCExpression qualifierName;
                JCTree.JCExpression res;
                JCTree.JCExpression parentFieldAccess;
                fieldAccess = (JCTree.JCFieldAccess)javac;
                if (Objects.equals(Names.instance((Context)this.context)._class, fieldAccess.getIdentifier())) {
                    TypeLiteral res2 = this.ast.newTypeLiteral();
                    this.commonSettings((ASTNode)res2, javac);
                    res2.setType(this.convertToType(fieldAccess.getExpression()));
                    return res2;
                }
                if (Objects.equals(Names.instance((Context)this.context)._this, fieldAccess.getIdentifier())) {
                    ThisExpression res3 = this.ast.newThisExpression();
                    this.commonSettings((ASTNode)res3, javac);
                    res3.setQualifier(this.toName(fieldAccess.getExpression()));
                    return res3;
                }
                JCTree.JCExpression jCExpression = fieldAccess.getExpression();
                if (jCExpression instanceof JCTree.JCFieldAccess && Objects.equals(Names.instance((Context)this.context)._super, ((JCTree.JCFieldAccess)(parentFieldAccess = (JCTree.JCFieldAccess)jCExpression)).getIdentifier())) {
                    res = this.ast.newSuperFieldAccess();
                    this.commonSettings((ASTNode)res, javac);
                    res.setQualifier(this.toName(((JCTree.JCFieldAccess)parentFieldAccess).getExpression()));
                    res.setName((SimpleName)this.convertName(fieldAccess.getIdentifier()));
                    return res;
                }
                res = fieldAccess.getExpression();
                if (res instanceof JCTree.JCIdent && Objects.equals(Names.instance((Context)this.context)._super, ((JCTree.JCIdent)(parentFieldAccess = (JCTree.JCIdent)res)).getName())) {
                    res = this.ast.newSuperFieldAccess();
                    this.commonSettings((ASTNode)res, javac);
                    res.setName((SimpleName)this.convertName(fieldAccess.getIdentifier()));
                    return res;
                }
                res = fieldAccess.getExpression();
                if (res instanceof JCTree.JCIdent && Objects.equals(Names.instance((Context)this.context)._this, ((JCTree.JCIdent)(parentFieldAccess = (JCTree.JCIdent)res)).getName())) {
                    res = this.ast.newFieldAccess();
                    this.commonSettings((ASTNode)res, javac);
                    res.setExpression(this.convertExpression(parentFieldAccess));
                    Name name = this.convertName(fieldAccess.getIdentifier());
                    if (name instanceof SimpleName) {
                        SimpleName name2 = (SimpleName)name;
                        res.setName(name2);
                    }
                    return res;
                }
                res = fieldAccess.getExpression();
                if (res instanceof JCTree.JCIdent) {
                    JCTree.JCIdent qualifier = (JCTree.JCIdent)res;
                    qualifierName = this.convertName(qualifier.getName());
                    this.commonSettings((ASTNode)qualifierName, qualifier);
                    SimpleName qualifiedName = (SimpleName)this.convertName(fieldAccess.getIdentifier());
                    if (qualifiedName == null) {
                        qualifiedName = this.ast.newSimpleName(FAKE_IDENTIFIER);
                        qualifiedName.setFlags(8);
                    } else {
                        int qualifiedOffset = this.rawText.indexOf(qualifiedName.toString(), qualifierName.getStartPosition() + qualifierName.getLength() + 1);
                        if (qualifiedOffset != -1) {
                            qualifiedName.setSourceRange(qualifiedOffset, qualifiedName.toString().length());
                        }
                    }
                    QualifiedName res4 = this.ast.newQualifiedName((Name)qualifierName, qualifiedName);
                    this.commonSettings((ASTNode)res4, javac);
                    return res4;
                }
                qualifierName = fieldAccess.getExpression();
                if (qualifierName instanceof JCTree.JCFieldAccess && !Objects.equals(Names.instance((Context)this.context)._class, ((JCTree.JCFieldAccess)(cursor = (parentFieldAccess = (JCTree.JCFieldAccess)qualifierName))).getIdentifier()) && !Objects.equals(Names.instance((Context)this.context)._this, ((JCTree.JCFieldAccess)cursor).getIdentifier()) && !Objects.equals(Names.instance((Context)this.context)._super, ((JCTree.JCFieldAccess)cursor).getIdentifier())) {
                    JCTree.JCExpression res4;
                    while ((res4 = ((JCTree.JCFieldAccess)cursor).getExpression()) instanceof JCTree.JCFieldAccess) {
                        JCTree.JCFieldAccess newParent = (JCTree.JCFieldAccess)res4;
                        cursor = newParent;
                        if (!Objects.equals(Names.instance((Context)this.context)._class, ((JCTree.JCFieldAccess)cursor).getIdentifier()) && !Objects.equals(Names.instance((Context)this.context)._this, ((JCTree.JCFieldAccess)cursor).getIdentifier()) && !Objects.equals(Names.instance((Context)this.context)._super, ((JCTree.JCFieldAccess)cursor).getIdentifier())) continue;
                        break block118;
                    }
                    res4 = ((JCTree.JCFieldAccess)cursor).getExpression();
                    if (res4 instanceof JCTree.JCIdent && !Objects.equals(Names.instance((Context)this.context)._class, ((JCTree.JCIdent)(oldestIdentifier = (JCTree.JCIdent)res4)).getName()) && !Objects.equals(Names.instance((Context)this.context)._this, ((JCTree.JCIdent)oldestIdentifier).getName()) && !Objects.equals(Names.instance((Context)this.context)._super, ((JCTree.JCIdent)oldestIdentifier).getName())) {
                        return this.convertQualifiedName(fieldAccess);
                    }
                }
            }
            FieldAccess res = this.ast.newFieldAccess();
            this.commonSettings((ASTNode)res, javac);
            res.setExpression(this.convertExpression(fieldAccess.getExpression()));
            oldestIdentifier = this.convertName(fieldAccess.getIdentifier());
            if (oldestIdentifier instanceof SimpleName) {
                SimpleName name = (SimpleName)oldestIdentifier;
                res.setName(name);
            }
            return res;
        }
        if (javac instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)javac;
            JCTree.JCExpression nameExpr = methodInvocation.getMethodSelect();
            if (nameExpr instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)nameExpr;
                boolean superCall1 = access.getExpression() instanceof JCTree.JCFieldAccess && Objects.equals(Names.instance((Context)this.context)._super, ((JCTree.JCFieldAccess)access.getExpression()).getIdentifier());
                boolean superCall2 = Objects.equals(Names.instance((Context)this.context)._super.toString(), access.getExpression().toString());
                if (superCall1 || superCall2) {
                    JCTree.JCFieldAccess fa = superCall1 ? (JCTree.JCFieldAccess)access.getExpression() : access;
                    SuperMethodInvocation res2 = this.ast.newSuperMethodInvocation();
                    this.commonSettings((ASTNode)res2, javac);
                    methodInvocation.getArguments().stream().map(this::convertExpression).forEach(res2.arguments()::add);
                    methodInvocation.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res2.typeArguments()::add);
                    if (superCall1) {
                        res2.setQualifier(this.toName(fa.getExpression()));
                    }
                    res2.setName((SimpleName)this.convertName(access.getIdentifier()));
                    return res2;
                }
            }
            MethodInvocation res = this.ast.newMethodInvocation();
            this.commonSettings((ASTNode)res, methodInvocation);
            if (nameExpr instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident = (JCTree.JCIdent)nameExpr;
                if (Objects.equals(ident.getName(), Names.instance((Context)this.context)._super)) {
                    return this.convertSuperMethodInvocation(methodInvocation);
                }
                SimpleName name = (SimpleName)this.convertName(ident.getName());
                this.commonSettings((ASTNode)name, ident);
                res.setName(name);
            } else if (nameExpr instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)nameExpr;
                boolean superCall1 = access.getExpression() instanceof JCTree.JCFieldAccess && Objects.equals(Names.instance((Context)this.context)._super, ((JCTree.JCFieldAccess)access.getExpression()).getIdentifier());
                boolean superCall2 = Objects.equals(Names.instance((Context)this.context)._super.toString(), access.getExpression().toString());
                if (superCall1 || superCall2) {
                    JCTree.JCFieldAccess fa = superCall1 ? (JCTree.JCFieldAccess)access.getExpression() : access;
                    SuperMethodInvocation res2 = this.ast.newSuperMethodInvocation();
                    this.commonSettings((ASTNode)res2, javac);
                    methodInvocation.getArguments().stream().map(this::convertExpression).forEach(res.arguments()::add);
                    methodInvocation.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.typeArguments()::add);
                    if (superCall1) {
                        res2.setQualifier(this.toName(fa.getExpression()));
                    }
                    res2.setName((SimpleName)this.convertName(access.getIdentifier()));
                    return res2;
                }
                Name res2 = this.convertName(access.getIdentifier());
                if (res2 instanceof SimpleName) {
                    SimpleName simpleName = (SimpleName)res2;
                    res.setName(simpleName);
                    String asString = access.getIdentifier().toString();
                    this.commonSettings((ASTNode)simpleName, access);
                    int foundOffset = this.rawText.indexOf(asString, access.getPreferredPosition());
                    if (foundOffset > 0) {
                        simpleName.setSourceRange(foundOffset, asString.length());
                    }
                }
                res.setExpression(this.convertExpression(access.getExpression()));
            }
            if (methodInvocation.getArguments() != null) {
                methodInvocation.getArguments().stream().map(this::convertExpression).forEach(res.arguments()::add);
            }
            if (methodInvocation.getTypeArguments() != null) {
                methodInvocation.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.typeArguments()::add);
            }
            return res;
        }
        if (javac instanceof JCTree.JCNewClass) {
            JCTree.JCClassDecl ident;
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)javac;
            ClassInstanceCreation res = this.ast.newClassInstanceCreation();
            this.commonSettings((ASTNode)res, javac);
            res.setType(this.convertToType(newClass.getIdentifier()));
            if (newClass.getClassBody() != null && (ident = newClass.getClassBody()) instanceof JCTree.JCClassDecl) {
                JCTree.JCClassDecl javacAnon = ident;
                AnonymousClassDeclaration anon = this.createAnonymousClassDeclaration(javacAnon, (ASTNode)res);
                res.setAnonymousClassDeclaration(anon);
            }
            if (newClass.getArguments() != null) {
                newClass.getArguments().stream().map(this::convertExpression).forEach(res.arguments()::add);
            }
            if (newClass.encl != null) {
                res.setExpression(this.convertExpression(newClass.encl));
            }
            if (newClass.getTypeArguments() != null) {
                Iterator it = ((List)newClass.getTypeArguments()).iterator();
                while (it.hasNext()) {
                    Type e = this.convertToType((JCTree)it.next());
                    if (e == null) continue;
                    res.typeArguments().add(e);
                }
            }
            return res;
        }
        if (javac instanceof JCTree.JCBinary) {
            JCTree.JCBinary binary = (JCTree.JCBinary)javac;
            return this.handleInfixExpression(binary, javac);
        }
        if (javac instanceof JCTree.JCUnary) {
            JCTree.JCUnary unary = (JCTree.JCUnary)javac;
            if (unary.getTag() != JCTree.Tag.POSTINC && unary.getTag() != JCTree.Tag.POSTDEC) {
                PrefixExpression res = this.ast.newPrefixExpression();
                this.commonSettings((ASTNode)res, javac);
                res.setOperand(this.convertExpression(unary.getExpression()));
                res.setOperator(switch (unary.getTag()) {
                    case JCTree.Tag.POS -> PrefixExpression.Operator.PLUS;
                    case JCTree.Tag.NEG -> PrefixExpression.Operator.MINUS;
                    case JCTree.Tag.NOT -> PrefixExpression.Operator.NOT;
                    case JCTree.Tag.COMPL -> PrefixExpression.Operator.COMPLEMENT;
                    case JCTree.Tag.PREINC -> PrefixExpression.Operator.INCREMENT;
                    case JCTree.Tag.PREDEC -> PrefixExpression.Operator.DECREMENT;
                    default -> null;
                });
                return res;
            }
            PostfixExpression res = this.ast.newPostfixExpression();
            this.commonSettings((ASTNode)res, javac);
            res.setOperand(this.convertExpression(unary.getExpression()));
            res.setOperator(switch (unary.getTag()) {
                case JCTree.Tag.POSTINC -> PostfixExpression.Operator.INCREMENT;
                case JCTree.Tag.POSTDEC -> PostfixExpression.Operator.DECREMENT;
                default -> null;
            });
            return res;
        }
        if (javac instanceof JCTree.JCParens) {
            JCTree.JCParens parens = (JCTree.JCParens)javac;
            ParenthesizedExpression res = this.ast.newParenthesizedExpression();
            this.commonSettings((ASTNode)res, javac);
            res.setExpression(this.convertExpression(parens.getExpression()));
            return res;
        }
        if (javac instanceof JCTree.JCAssign) {
            JCTree.JCAssign assign = (JCTree.JCAssign)javac;
            Assignment res = this.ast.newAssignment();
            this.commonSettings((ASTNode)res, javac);
            res.setLeftHandSide(this.convertExpression(assign.getVariable()));
            res.setRightHandSide(this.convertExpression(assign.getExpression()));
            return res;
        }
        if (javac instanceof JCTree.JCAssignOp) {
            JCTree.JCAssignOp assignOp = (JCTree.JCAssignOp)javac;
            Assignment res = this.ast.newAssignment();
            this.commonSettings((ASTNode)res, javac);
            res.setLeftHandSide(this.convertExpression(assignOp.getVariable()));
            res.setRightHandSide(this.convertExpression(assignOp.getExpression()));
            res.setOperator(switch (assignOp.getTag()) {
                case JCTree.Tag.PLUS_ASG -> Assignment.Operator.PLUS_ASSIGN;
                case JCTree.Tag.BITOR_ASG -> Assignment.Operator.BIT_OR_ASSIGN;
                case JCTree.Tag.BITXOR_ASG -> Assignment.Operator.BIT_XOR_ASSIGN;
                case JCTree.Tag.BITAND_ASG -> Assignment.Operator.BIT_AND_ASSIGN;
                case JCTree.Tag.SL_ASG -> Assignment.Operator.LEFT_SHIFT_ASSIGN;
                case JCTree.Tag.SR_ASG -> Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN;
                case JCTree.Tag.USR_ASG -> Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN;
                case JCTree.Tag.MINUS_ASG -> Assignment.Operator.MINUS_ASSIGN;
                case JCTree.Tag.MUL_ASG -> Assignment.Operator.TIMES_ASSIGN;
                case JCTree.Tag.DIV_ASG -> Assignment.Operator.DIVIDE_ASSIGN;
                case JCTree.Tag.MOD_ASG -> Assignment.Operator.REMAINDER_ASSIGN;
                default -> null;
            });
            return res;
        }
        if (javac instanceof JCTree.JCInstanceOf) {
            JCTree.JCInstanceOf jcInstanceOf = (JCTree.JCInstanceOf)javac;
            JCTree.JCPattern jcPattern = jcInstanceOf.getPattern();
            if (jcInstanceOf.getType() != null && jcPattern == null) {
                InstanceofExpression res = this.ast.newInstanceofExpression();
                this.commonSettings((ASTNode)res, javac);
                res.setLeftOperand(this.convertExpression(jcInstanceOf.getExpression()));
                res.setRightOperand(this.convertToType(jcInstanceOf.getType()));
                return res;
            }
            if (jcPattern instanceof JCTree.JCAnyPattern) {
                InstanceofExpression res = this.ast.newInstanceofExpression();
                this.commonSettings((ASTNode)res, javac);
                res.setLeftOperand(this.convertExpression(jcInstanceOf.getExpression()));
                throw new UnsupportedOperationException("Right operand not supported yet");
            }
            PatternInstanceofExpression res = this.ast.newPatternInstanceofExpression();
            this.commonSettings((ASTNode)res, javac);
            res.setLeftOperand(this.convertExpression(jcInstanceOf.getExpression()));
            Pattern p = this.convert(jcPattern);
            if (p != null && this.ast.apiLevel >= 20) {
                res.setPattern(p);
            } else {
                res.setRightOperand(this.convertToSingleVarDecl(jcPattern));
            }
            return res;
        }
        if (javac instanceof JCTree.JCArrayAccess) {
            JCTree.JCArrayAccess jcArrayAccess = (JCTree.JCArrayAccess)javac;
            ArrayAccess res = this.ast.newArrayAccess();
            this.commonSettings((ASTNode)res, javac);
            res.setArray(this.convertExpression(jcArrayAccess.getExpression()));
            res.setIndex(this.convertExpression(jcArrayAccess.getIndex()));
            return res;
        }
        if (javac instanceof JCTree.JCTypeCast) {
            JCTree.JCTypeCast jcCast = (JCTree.JCTypeCast)javac;
            CastExpression res = this.ast.newCastExpression();
            this.commonSettings((ASTNode)res, javac);
            res.setExpression(this.convertExpression(jcCast.getExpression()));
            res.setType(this.convertToType(jcCast.getType()));
            return res;
        }
        if (javac instanceof JCTree.JCMemberReference) {
            JCTree.JCFieldAccess fieldAccess;
            JCTree.JCIdent ident;
            JCTree.JCMemberReference jcMemberReference = (JCTree.JCMemberReference)javac;
            JCTree.JCExpression qualifierExpression = jcMemberReference.getQualifierExpression();
            if (Objects.equals(Names.instance((Context)this.context).init, jcMemberReference.getName())) {
                CreationReference res = this.ast.newCreationReference();
                this.commonSettings((ASTNode)res, javac);
                res.setType(this.convertToType(qualifierExpression));
                if (jcMemberReference.getTypeArguments() != null) {
                    jcMemberReference.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.typeArguments()::add);
                }
                return res;
            }
            if (qualifierExpression.getKind() == Tree.Kind.PARAMETERIZED_TYPE || qualifierExpression.getKind() == Tree.Kind.ARRAY_TYPE || qualifierExpression.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                TypeMethodReference res = this.ast.newTypeMethodReference();
                this.commonSettings((ASTNode)res, javac);
                res.setType(this.convertToType(qualifierExpression));
                res.setName((SimpleName)this.convertName(jcMemberReference.getName()));
                if (jcMemberReference.getTypeArguments() != null) {
                    jcMemberReference.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.typeArguments()::add);
                }
                return res;
            }
            if (qualifierExpression instanceof JCTree.JCIdent && Names.instance((Context)this.context)._super.equals((ident = (JCTree.JCIdent)qualifierExpression).getName())) {
                SuperMethodReference res = this.ast.newSuperMethodReference();
                this.commonSettings((ASTNode)res, javac);
                res.setName((SimpleName)this.convertName(jcMemberReference.getName()));
                if (jcMemberReference.getTypeArguments() != null) {
                    jcMemberReference.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.typeArguments()::add);
                }
                return res;
            }
            if (qualifierExpression instanceof JCTree.JCFieldAccess && Names.instance((Context)this.context)._super.equals((fieldAccess = (JCTree.JCFieldAccess)qualifierExpression).getIdentifier())) {
                SuperMethodReference res = this.ast.newSuperMethodReference();
                this.commonSettings((ASTNode)res, javac);
                res.setName((SimpleName)this.convertName(jcMemberReference.getName()));
                res.setQualifier(this.toName(fieldAccess.getExpression()));
                if (jcMemberReference.getTypeArguments() != null) {
                    jcMemberReference.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.typeArguments()::add);
                }
                return res;
            }
            ExpressionMethodReference res = this.ast.newExpressionMethodReference();
            this.commonSettings((ASTNode)res, javac);
            res.setExpression(this.convertExpression(jcMemberReference.getQualifierExpression()));
            res.setName((SimpleName)this.convertName(jcMemberReference.getName()));
            if (jcMemberReference.getTypeArguments() != null) {
                jcMemberReference.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.typeArguments()::add);
            }
            return res;
        }
        if (javac instanceof JCTree.JCConditional) {
            JCTree.JCConditional jcCondition = (JCTree.JCConditional)javac;
            ConditionalExpression res = this.ast.newConditionalExpression();
            this.commonSettings((ASTNode)res, javac);
            res.setExpression(this.convertExpression(jcCondition.getCondition()));
            res.setThenExpression(this.convertExpression(jcCondition.getTrueExpression()));
            res.setElseExpression(this.convertExpression(jcCondition.getFalseExpression()));
            return res;
        }
        if (javac instanceof JCTree.JCLambda) {
            Expression body;
            JCTree.JCLambda jcLambda = (JCTree.JCLambda)javac;
            LambdaExpression res = this.ast.newLambdaExpression();
            this.commonSettings((ASTNode)res, javac);
            jcLambda.getParameters().stream().filter(JCTree.JCVariableDecl.class::isInstance).map(JCTree.JCVariableDecl.class::cast).map(this::convertVariableDeclarationForLambda).forEach(res.parameters()::add);
            int arrowIndex = this.rawText.indexOf("->", jcLambda.getStartPosition());
            int parenthesisIndex = this.rawText.indexOf(")", jcLambda.getStartPosition());
            res.setParentheses(parenthesisIndex >= 0 && parenthesisIndex < arrowIndex);
            JCTree simpleName = jcLambda.getBody();
            if (simpleName instanceof JCTree.JCExpression) {
                JCTree.JCExpression expr = (JCTree.JCExpression)simpleName;
                v3 = this.convertExpression(expr);
            } else {
                simpleName = jcLambda.getBody();
                if (simpleName instanceof JCTree.JCStatement) {
                    JCTree.JCStatement stmt = (JCTree.JCStatement)simpleName;
                    v3 = this.convertStatement(stmt, (ASTNode)res);
                } else {
                    v3 = body = null;
                }
            }
            if (body != null) {
                res.setBody((ASTNode)body);
            }
            int endPos = jcLambda.getEndPosition(this.javacCompilationUnit.endPositions);
            res.setSourceRange(jcLambda.pos, endPos - jcLambda.pos);
            return res;
        }
        if (javac instanceof JCTree.JCNewArray) {
            JCTree.JCNewArray jcNewArray = (JCTree.JCNewArray)javac;
            ArrayCreation res = this.ast.newArrayCreation();
            this.commonSettings((ASTNode)res, javac);
            if (jcNewArray.getType() == null) {
                ArrayInitializer ret = this.createArrayInitializerFromJCNewArray(jcNewArray);
                return ret;
            }
            if (jcNewArray.getType() != null) {
                ArrayType arrayType;
                Type type = this.convertToType(jcNewArray.getType());
                if (type instanceof ArrayType) {
                    ArrayType childArrayType;
                    arrayType = childArrayType = (ArrayType)type;
                    java.util.List<Dimension> extraDimensions = jcNewArray.getDimAnnotations().stream().map(annotations -> annotations.stream().map(this::convert).toList()).map(this::wrapAsDimension).toList();
                    if (arrayType.dimensions().isEmpty()) {
                        arrayType.dimensions().addAll(extraDimensions);
                    } else {
                        Object lastDimension = arrayType.dimensions().removeFirst();
                        arrayType.dimensions().addAll(extraDimensions);
                        arrayType.dimensions().add(lastDimension);
                    }
                    int totalRequiredDims = this.countDimensions(jcNewArray.getType()) + 1;
                    int totalCreated = arrayType.dimensions().size();
                    if (totalCreated < totalRequiredDims) {
                        int endPos = jcNewArray.getEndPosition(this.javacCompilationUnit.endPositions);
                        int startPos = jcNewArray.getStartPosition();
                        String raw = this.rawText.substring(startPos, endPos);
                        for (int i = 0; i < totalRequiredDims; ++i) {
                            int absoluteEndChar = startPos + JavacConverter.ordinalIndexOf(raw, "]", i + 1);
                            int absoluteEnd = absoluteEndChar + 1;
                            int absoluteStart = startPos + JavacConverter.ordinalIndexOf(raw, "[", i + 1);
                            boolean found = false;
                            if (absoluteEnd == -1 || absoluteStart == -1) continue;
                            for (int j = 0; j < totalCreated && !found; ++j) {
                                Dimension d = (Dimension)arrayType.dimensions().get(j);
                                if (d.getStartPosition() != absoluteStart || d.getStartPosition() + d.getLength() != absoluteEnd) continue;
                                found = true;
                            }
                            if (found) continue;
                            Dimension d = this.ast.newDimension();
                            d.setSourceRange(absoluteStart, absoluteEnd - absoluteStart);
                            arrayType.dimensions().add(i, d);
                            ++totalCreated;
                        }
                    }
                } else {
                    arrayType = this.ast.newArrayType(type);
                    arrayType.dimensions().clear();
                    if (!((List)jcNewArray.getAnnotations()).isEmpty()) {
                        arrayType.dimensions().add(this.wrapAsDimension(jcNewArray.getAnnotations().stream().map(this::convert).toList()));
                    } else if (!((List)jcNewArray.getDimAnnotations()).isEmpty()) {
                        jcNewArray.getDimAnnotations().stream().map(dimAnnotations -> dimAnnotations.stream().map(this::convert).toList()).map(this::wrapAsDimension).forEach(arrayType.dimensions()::add);
                    } else {
                        arrayType.dimensions().add(this.ast.newDimension());
                    }
                }
                this.commonSettings((ASTNode)arrayType, jcNewArray.getType());
                res.setType(arrayType);
            }
            ((List)jcNewArray.getDimensions()).map(this::convertExpression).forEach(res.dimensions()::add);
            if (jcNewArray.getInitializers() != null) {
                res.setInitializer(this.createArrayInitializerFromJCNewArray(jcNewArray));
            }
            return res;
        }
        if (javac instanceof JCTree.JCAnnotation) {
            JCTree.JCAnnotation jcAnnot = (JCTree.JCAnnotation)javac;
            return this.convert(jcAnnot);
        }
        if (javac instanceof JCTree.JCPrimitiveTypeTree) {
            JCTree.JCPrimitiveTypeTree primitiveTree = (JCTree.JCPrimitiveTypeTree)javac;
            SimpleName res = this.ast.newSimpleName(primitiveTree.getPrimitiveTypeKind().name());
            this.commonSettings((ASTNode)res, javac);
            return res;
        }
        if (javac instanceof JCTree.JCSwitchExpression) {
            JCTree.JCSwitchExpression jcSwitch = (JCTree.JCSwitchExpression)javac;
            SwitchExpression res = this.ast.newSwitchExpression();
            this.commonSettings((ASTNode)res, javac);
            JCTree.JCExpression switchExpr = jcSwitch.getExpression();
            if (switchExpr instanceof JCTree.JCParens) {
                JCTree.JCParens jcp = (JCTree.JCParens)switchExpr;
                switchExpr = jcp.getExpression();
            }
            res.setExpression(this.convertExpression(switchExpr));
            java.util.List cases = jcSwitch.getCases();
            Iterator it = cases.iterator();
            ArrayList<JCTree> bodyList = new ArrayList<JCTree>();
            while (it.hasNext()) {
                JCTree.JCCase switchCase = (JCTree.JCCase)it.next();
                bodyList.add(switchCase);
                if (switchCase.getCaseKind() == CaseTree.CaseKind.STATEMENT) {
                    if (switchCase.getStatements() == null || ((List)switchCase.getStatements()).size() <= 0) continue;
                    bodyList.addAll(switchCase.getStatements());
                    continue;
                }
                bodyList.add(switchCase.getBody());
            }
            for (JCTree next : bodyList) {
                JCTree.JCExpression jce;
                Statement s1;
                if (next instanceof JCTree.JCStatement) {
                    JCTree.JCStatement jcs = (JCTree.JCStatement)next;
                    s1 = this.convertStatement(jcs, (ASTNode)res);
                    if (s1 == null) continue;
                    res.statements().add(s1);
                    continue;
                }
                if (!(next instanceof JCTree.JCExpression) || (s1 = this.convertExpression(jce = (JCTree.JCExpression)next)) == null) continue;
                YieldStatement r1 = this.ast.newYieldStatement();
                this.commonSettings((ASTNode)r1, jce);
                r1.setExpression((Expression)s1);
                res.statements().add(r1);
            }
            return res;
        }
        if (javac instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCArrayTypeTree arrayTypeTree = (JCTree.JCArrayTypeTree)javac;
            Type type = this.convertToType(javac);
            TypeLiteral res = this.ast.newTypeLiteral();
            res.setType(type);
            this.commonSettings((ASTNode)res, arrayTypeTree);
            return res;
        }
        if (javac instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply parameterizedType = (JCTree.JCTypeApply)javac;
            Type recoveredType = this.convertToType(parameterizedType);
            TypeLiteral decl = this.ast.newTypeLiteral();
            decl.setSourceRange(recoveredType.getStartPosition(), recoveredType.getLength());
            decl.setFlags(1);
            decl.setType(recoveredType);
            return decl;
        }
        return null;
    }

    private SingleVariableDeclaration convertToSingleVarDecl(JCTree.JCPattern jcPattern) {
        if (jcPattern instanceof JCTree.JCBindingPattern) {
            JCTree.JCBindingPattern jcbp = (JCTree.JCBindingPattern)jcPattern;
            JCTree.JCVariableDecl jCVariableDecl = jcbp.var;
            if (jCVariableDecl instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl decl = jCVariableDecl;
                SingleVariableDeclaration vdd = (SingleVariableDeclaration)this.convertVariableDeclaration(decl);
                return vdd;
            }
        }
        return null;
    }

    private Dimension wrapAsDimension(java.util.List<Annotation> annotations) {
        Dimension dim = this.ast.newDimension();
        dim.annotations().addAll(annotations);
        int startOffset = annotations.stream().mapToInt(ASTNode::getStartPosition).min().orElse(-1);
        int endOffset = annotations.stream().mapToInt(ann -> ann.getStartPosition() + ann.getLength()).max().orElse(-1);
        dim.setSourceRange(startOffset, endOffset - startOffset);
        return dim;
    }

    private java.util.List<JCTree.JCExpression> consecutiveInfixExpressionsWithEqualOps(JCTree.JCBinary binary, JCTree.Tag opcode) {
        return this.consecutiveInfixExpressionsWithEqualOps(binary, opcode, new ArrayList<JCTree.JCExpression>());
    }

    private java.util.List<JCTree.JCExpression> consecutiveInfixExpressionsWithEqualOps(JCTree.JCBinary binary, JCTree.Tag opcode, java.util.List<JCTree.JCExpression> consecutive) {
        if (opcode.equals((Object)binary.getTag())) {
            JCTree.JCBinary jcb;
            if (consecutive != null) {
                JCTree.JCExpression left = binary.getLeftOperand();
                if (left instanceof JCTree.JCBinary) {
                    jcb = (JCTree.JCBinary)left;
                    consecutive = this.consecutiveInfixExpressionsWithEqualOps(jcb, opcode, consecutive);
                } else {
                    consecutive.add(left);
                }
            }
            if (consecutive != null) {
                JCTree.JCExpression right = binary.getRightOperand();
                if (right instanceof JCTree.JCBinary) {
                    jcb = (JCTree.JCBinary)right;
                    consecutive = this.consecutiveInfixExpressionsWithEqualOps(jcb, opcode, consecutive);
                } else {
                    consecutive.add(right);
                }
            }
            return consecutive;
        }
        return null;
    }

    private Expression handleInfixExpression(JCTree.JCBinary binary, JCTree.JCExpression javac) {
        Expression right;
        java.util.List<JCTree.JCExpression> conseq = this.consecutiveInfixExpressionsWithEqualOps(binary, binary.getTag());
        if (conseq != null && conseq.size() > 2) {
            return this.handleConsecutiveInfixExpression(binary, javac, conseq);
        }
        InfixExpression res = this.ast.newInfixExpression();
        this.commonSettings((ASTNode)res, javac);
        Expression left = this.convertExpression(binary.getLeftOperand());
        if (left != null) {
            res.setLeftOperand(left);
        }
        if ((right = this.convertExpression(binary.getRightOperand())) != null) {
            res.setRightOperand(right);
        }
        res.setOperator(this.binaryTagToInfixOperator(binary.getTag()));
        return res;
    }

    private Expression handleConsecutiveInfixExpression(JCTree.JCBinary binary, JCTree.JCExpression javac, java.util.List<JCTree.JCExpression> conseq) {
        Expression right;
        InfixExpression res = this.ast.newInfixExpression();
        this.commonSettings((ASTNode)res, javac);
        Expression left = this.convertExpression(conseq.get(0));
        if (left != null) {
            res.setLeftOperand(left);
        }
        if ((right = this.convertExpression(conseq.get(1))) != null) {
            res.setRightOperand(right);
        }
        for (int i = 2; i < conseq.size(); ++i) {
            res.extendedOperands().add(this.convertExpression(conseq.get(i)));
        }
        res.setOperator(this.binaryTagToInfixOperator(binary.getTag()));
        return res;
    }

    private InfixExpression.Operator binaryTagToInfixOperator(JCTree.Tag t) {
        return switch (t) {
            case JCTree.Tag.OR -> InfixExpression.Operator.CONDITIONAL_OR;
            case JCTree.Tag.AND -> InfixExpression.Operator.CONDITIONAL_AND;
            case JCTree.Tag.BITOR -> InfixExpression.Operator.OR;
            case JCTree.Tag.BITXOR -> InfixExpression.Operator.XOR;
            case JCTree.Tag.BITAND -> InfixExpression.Operator.AND;
            case JCTree.Tag.EQ -> InfixExpression.Operator.EQUALS;
            case JCTree.Tag.NE -> InfixExpression.Operator.NOT_EQUALS;
            case JCTree.Tag.LT -> InfixExpression.Operator.LESS;
            case JCTree.Tag.GT -> InfixExpression.Operator.GREATER;
            case JCTree.Tag.LE -> InfixExpression.Operator.LESS_EQUALS;
            case JCTree.Tag.GE -> InfixExpression.Operator.GREATER_EQUALS;
            case JCTree.Tag.SL -> InfixExpression.Operator.LEFT_SHIFT;
            case JCTree.Tag.SR -> InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
            case JCTree.Tag.USR -> InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
            case JCTree.Tag.PLUS -> InfixExpression.Operator.PLUS;
            case JCTree.Tag.MINUS -> InfixExpression.Operator.MINUS;
            case JCTree.Tag.MUL -> InfixExpression.Operator.TIMES;
            case JCTree.Tag.DIV -> InfixExpression.Operator.DIVIDE;
            case JCTree.Tag.MOD -> InfixExpression.Operator.REMAINDER;
            default -> null;
        };
    }

    private Name convertQualifiedName(JCTree.JCFieldAccess fieldAccess) {
        Name parentName;
        JCTree.JCExpression parent = fieldAccess.getExpression();
        if (parent instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess parentFieldAccess = (JCTree.JCFieldAccess)parent;
            parentName = this.convertQualifiedName(parentFieldAccess);
        } else if (parent instanceof JCTree.JCIdent) {
            JCTree.JCIdent parentIdent = (JCTree.JCIdent)parent;
            parentName = this.convertName(parentIdent.getName());
        } else {
            throw new IllegalArgumentException("Unrecognized javac AST node type: " + parent.getClass().getCanonicalName());
        }
        this.commonSettings((ASTNode)parentName, parent);
        SimpleName segmentName = (SimpleName)this.convertName(fieldAccess.getIdentifier());
        int endPos = fieldAccess.getEndPosition(this.javacCompilationUnit.endPositions);
        int startPos = endPos - fieldAccess.getIdentifier().length();
        segmentName.setSourceRange(startPos, fieldAccess.getIdentifier().length());
        QualifiedName res = this.ast.newQualifiedName(parentName, segmentName);
        this.commonSettings((ASTNode)res, fieldAccess);
        return res;
    }

    private Expression convertExpression(JCTree.JCExpression javac) {
        Expression ret = this.convertExpressionImpl(javac);
        if (ret != null) {
            return ret;
        }
        if (javac instanceof JCTree.JCErroneous) {
            JCTree tree;
            char c;
            JCTree.JCErroneous error = (JCTree.JCErroneous)javac;
            int pos = javac.getPreferredPosition();
            char c2 = c = this.rawText.length() > pos ? this.rawText.charAt(pos) : (char)'\u0000';
            if (((List)error.getErrorTrees()).isEmpty() && c == '\"') {
                int newLine = this.rawText.indexOf(10, pos);
                int lineEnd = newLine == -1 ? this.rawText.length() - 1 : newLine;
                String litText = this.rawText.substring(pos + 1, lineEnd);
                Expression res = this.convertStringToLiteral(litText, pos, lineEnd, null);
                res.setSourceRange(pos, lineEnd - pos);
                res.setFlags(res.getFlags() | 1);
                return res;
            }
            if (((List)error.getErrorTrees()).size() == 1 && (tree = (JCTree)((List)error.getErrorTrees()).get(0)) instanceof JCTree.JCExpression) {
                JCTree.JCExpression nestedExpr = (JCTree.JCExpression)tree;
                try {
                    return this.convertExpression(nestedExpr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.shouldRecoverWithSimpleName(javac)) {
            SimpleName res = this.ast.newSimpleName(FAKE_IDENTIFIER);
            res.setFlags(8);
            this.commonSettings((ASTNode)res, javac);
            return res;
        }
        return null;
    }

    private boolean shouldRecoverWithSimpleName(JCTree.JCExpression javac) {
        return !(javac instanceof JCTree.JCNewClass);
    }

    private Pattern convert(JCTree.JCPattern jcPattern) {
        if (this.ast.apiLevel >= 21) {
            if (jcPattern instanceof JCTree.JCBindingPattern) {
                JCTree.JCBindingPattern jcBindingPattern = (JCTree.JCBindingPattern)jcPattern;
                TypePattern jdtPattern = this.ast.newTypePattern();
                this.commonSettings((ASTNode)jdtPattern, jcBindingPattern);
                if (this.ast.apiLevel < 22) {
                    jdtPattern.setPatternVariable((SingleVariableDeclaration)this.convertVariableDeclaration(jcBindingPattern.var));
                } else {
                    jdtPattern.setPatternVariable(this.convertVariableDeclaration(jcBindingPattern.var));
                }
                return jdtPattern;
            }
            if (jcPattern instanceof JCTree.JCRecordPattern) {
                JCTree.JCRecordPattern jcRecordPattern = (JCTree.JCRecordPattern)jcPattern;
                RecordPattern jdtPattern = this.ast.newRecordPattern();
                this.commonSettings((ASTNode)jdtPattern, jcRecordPattern);
                jdtPattern.setPatternType(this.convertToType(jcRecordPattern.deconstructor));
                for (JCTree.JCPattern nestedJcPattern : jcRecordPattern.nested) {
                    jdtPattern.patterns().add(this.convert(nestedJcPattern));
                }
                return jdtPattern;
            }
            if (jcPattern instanceof JCTree.JCAnyPattern) {
                JCTree.JCAnyPattern jcAnyPattern = (JCTree.JCAnyPattern)jcPattern;
                TypePattern jdtPattern = this.ast.newTypePattern();
                this.commonSettings((ASTNode)jdtPattern, jcAnyPattern);
                VariableDeclarationFragment variable = this.ast.newVariableDeclarationFragment();
                this.commonSettings((ASTNode)variable, jcAnyPattern);
                variable.setName(this.ast.newSimpleName("_"));
                jdtPattern.setPatternVariable((VariableDeclaration)variable);
                return jdtPattern;
            }
        }
        return null;
    }

    private ArrayInitializer createArrayInitializerFromJCNewArray(JCTree.JCNewArray jcNewArray) {
        ArrayInitializer initializer = this.ast.newArrayInitializer();
        this.commonSettings((ASTNode)initializer, jcNewArray);
        if (!((List)jcNewArray.getInitializers()).isEmpty()) {
            int end;
            int start;
            jcNewArray.getInitializers().stream().map(this::convertExpression).filter(Objects::nonNull).forEach(initializer.expressions()::add);
            for (start = ((Expression)initializer.expressions().getFirst()).getStartPosition() - 1; start >= 0 && this.rawText.charAt(start) != '{'; --start) {
            }
            Expression lastExpr = (Expression)initializer.expressions().getLast();
            for (end = lastExpr.getStartPosition() + lastExpr.getLength(); end < this.rawText.length() && this.rawText.charAt(end) != '}'; ++end) {
            }
            initializer.setSourceRange(start, end - start + 1);
        }
        return initializer;
    }

    private AnonymousClassDeclaration createAnonymousClassDeclaration(JCTree.JCClassDecl javacAnon, ASTNode parent) {
        AnonymousClassDeclaration anon = this.ast.newAnonymousClassDeclaration();
        this.commonSettings((ASTNode)anon, javacAnon);
        if (javacAnon.getMembers() != null) {
            java.util.List members = javacAnon.getMembers();
            for (int i = 0; i < members.size(); ++i) {
                ASTNode decl = this.convertBodyDeclaration((JCTree)members.get(i), (ASTNode)anon, true);
                if (decl == null) continue;
                anon.bodyDeclarations().add(decl);
            }
        }
        return anon;
    }

    private java.util.List<Dimension> convertDimensionsAfterPosition(JCTree tree, int pos) {
        if (tree == null) {
            return java.util.List.of();
        }
        ArrayList<Dimension> res = new ArrayList<Dimension>();
        JCTree elem = tree;
        do {
            if (elem.pos >= pos) {
                JCTree.JCAnnotatedType annotated;
                int endPosition;
                int startPosition;
                Object dimension;
                if (elem instanceof JCTree.JCArrayTypeTree) {
                    JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)elem;
                    dimension = this.ast.newDimension();
                    res.add((Dimension)dimension);
                    startPosition = this.rawText.indexOf(91, arrayType.pos);
                    endPosition = this.rawText.indexOf(93, startPosition);
                    dimension.setSourceRange(startPosition, endPosition - startPosition + 1);
                    elem = arrayType.getType();
                    continue;
                }
                if (elem instanceof JCTree.JCAnnotatedType && (dimension = (annotated = (JCTree.JCAnnotatedType)elem).getUnderlyingType()) instanceof JCTree.JCArrayTypeTree) {
                    JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)dimension;
                    dimension = this.ast.newDimension();
                    annotated.getAnnotations().stream().map(this::convert).forEach(dimension.annotations()::add);
                    startPosition = this.rawText.indexOf(91, arrayType.pos);
                    endPosition = this.rawText.indexOf(93, startPosition);
                    dimension.setSourceRange(startPosition, endPosition - startPosition + 1);
                    res.add((Dimension)dimension);
                    elem = arrayType.getType();
                    continue;
                }
                elem = null;
                continue;
            }
            elem = null;
        } while (elem != null);
        return res;
    }

    private JCTree unwrapDimensions(JCTree tree, int count) {
        JCTree elem = tree;
        while (count > 0) {
            JCTree.JCAnnotatedType annotated;
            JCTree.JCExpression jCExpression;
            if (elem instanceof JCTree.JCArrayTypeTree) {
                JCTree.JCArrayTypeTree arrayTree = (JCTree.JCArrayTypeTree)elem;
                elem = arrayTree.getType();
                --count;
                continue;
            }
            if (elem instanceof JCTree.JCAnnotatedType && (jCExpression = (annotated = (JCTree.JCAnnotatedType)elem).getUnderlyingType()) instanceof JCTree.JCArrayTypeTree) {
                JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)jCExpression;
                elem = arrayType.getType();
                --count;
                continue;
            }
            count = 0;
        }
        return elem;
    }

    private int countDimensions(JCTree tree) {
        JCTree elem = tree;
        int count = 0;
        boolean done = false;
        while (!done) {
            JCTree.JCAnnotatedType annotated;
            JCTree.JCExpression jCExpression;
            if (elem instanceof JCTree.JCArrayTypeTree) {
                JCTree.JCArrayTypeTree arrayTree = (JCTree.JCArrayTypeTree)elem;
                elem = arrayTree.getType();
                ++count;
                continue;
            }
            if (elem instanceof JCTree.JCAnnotatedType && (jCExpression = (annotated = (JCTree.JCAnnotatedType)elem).getUnderlyingType()) instanceof JCTree.JCArrayTypeTree) {
                JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)jCExpression;
                elem = arrayType.getType();
                ++count;
                continue;
            }
            done = true;
        }
        return count;
    }

    private SuperMethodInvocation convertSuperMethodInvocation(JCTree.JCMethodInvocation javac) {
        SuperMethodInvocation res = this.ast.newSuperMethodInvocation();
        this.commonSettings((ASTNode)res, javac);
        javac.getArguments().stream().map(this::convertExpression).forEach(res.arguments()::add);
        javac.getTypeArguments().stream().map(this::convertToType).forEach(res.typeArguments()::add);
        return res;
    }

    private SuperConstructorInvocation convertSuperConstructorInvocation(JCTree.JCMethodInvocation javac) {
        SuperConstructorInvocation res = this.ast.newSuperConstructorInvocation();
        this.commonSettings((ASTNode)res, javac);
        this.ensureTrailingSemicolonInRange((ASTNode)res);
        javac.getArguments().stream().map(this::convertExpression).forEach(res.arguments()::add);
        javac.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.typeArguments()::add);
        JCTree.JCExpression jCExpression = javac.getMethodSelect();
        if (jCExpression instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess jcfa = (JCTree.JCFieldAccess)jCExpression;
            if (jcfa.selected != null) {
                res.setExpression(this.convertExpression(jcfa.selected));
            }
        }
        return res;
    }

    private ConstructorInvocation convertThisConstructorInvocation(JCTree.JCMethodInvocation javac) {
        ConstructorInvocation res = this.ast.newConstructorInvocation();
        this.commonSettings((ASTNode)res, javac);
        res.setSourceRange(res.getStartPosition(), res.getLength() + 1);
        javac.getArguments().stream().map(this::convertExpression).forEach(res.arguments()::add);
        javac.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.typeArguments()::add);
        return res;
    }

    private Expression convertLiteral(JCTree.JCLiteral literal) {
        Object value = literal.getValue();
        if (value instanceof Number) {
            String fromSrc;
            NumberLiteral res;
            Long l;
            Integer i;
            boolean isNumberLiteral;
            boolean bl = isNumberLiteral = this.rawText.charAt(literal.getStartPosition()) != '-' || value instanceof Integer && (i = (Integer)value) == Integer.MIN_VALUE || value instanceof Long && (l = (Long)value) == Long.MIN_VALUE;
            if (isNumberLiteral) {
                res = this.ast.newNumberLiteral();
                this.commonSettings((ASTNode)res, literal);
                fromSrc = this.rawText.substring(res.getStartPosition(), res.getStartPosition() + res.getLength());
                try {
                    res.setToken(fromSrc);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return res;
            }
            res = this.ast.newPrefixExpression();
            this.commonSettings((ASTNode)res, literal);
            fromSrc = this.rawText.substring(res.getStartPosition() + 1, res.getStartPosition() + res.getLength());
            NumberLiteral operand = this.ast.newNumberLiteral();
            this.commonSettings((ASTNode)operand, literal);
            operand.setToken(fromSrc);
            res.setOperand((Expression)operand);
            res.setOperator(PrefixExpression.Operator.MINUS);
            return res;
        }
        if (value instanceof String) {
            String string = (String)value;
            return this.convertStringToLiteral(string, literal.pos, literal.getEndPosition(this.javacCompilationUnit.endPositions), literal);
        }
        if (value instanceof Boolean) {
            Boolean string = (Boolean)value;
            BooleanLiteral res = this.ast.newBooleanLiteral(string.booleanValue());
            this.commonSettings((ASTNode)res, literal);
            return res;
        }
        if (value == null) {
            NullLiteral res = this.ast.newNullLiteral();
            this.commonSettings((ASTNode)res, literal);
            return res;
        }
        if (value instanceof Character) {
            Character v = (Character)value;
            CharacterLiteral res = this.ast.newCharacterLiteral();
            this.commonSettings((ASTNode)res, literal);
            res.setCharValue(v.charValue());
            res.setEscapedValue(this.rawText.substring(res.getStartPosition(), res.getStartPosition() + res.getLength()));
            return res;
        }
        throw new UnsupportedOperationException("Not supported yet " + String.valueOf(literal) + "\n of type" + literal.getClass().getName());
    }

    private Expression convertStringToLiteral(String string, int pos, int endPos, JCTree.JCLiteral literal) {
        boolean malformed = false;
        if (this.rawText.charAt(pos) == '\"' && this.rawText.charAt(pos + 1) == '\"' && this.rawText.charAt(pos + 2) == '\"') {
            if (this.ast.apiLevel() > 14) {
                TextBlock res = this.ast.newTextBlock();
                this.commonSettings((ASTNode)res, literal);
                String rawValue = this.rawText.substring(pos, endPos);
                res.internalSetEscapedValue(rawValue, (String)string);
                return res;
            }
            malformed = true;
        }
        StringLiteral res = this.ast.newStringLiteral();
        this.commonSettings((ASTNode)res, literal);
        int startPos = res.getStartPosition();
        int len = res.getLength();
        if (((String)string).length() != len && len > 2) {
            try {
                string = this.rawText.substring(startPos, startPos + len);
                if (!((String)string).startsWith("\"")) {
                    string = "\"" + (String)string;
                }
                if (!((String)string).endsWith("\"")) {
                    string = (String)string + "\"";
                }
                res.internalSetEscapedValue((String)string);
            }
            catch (IndexOutOfBoundsException ignore) {
                res.setLiteralValue((String)string);
            }
        } else {
            res.setLiteralValue((String)string);
        }
        if (malformed) {
            res.setFlags(res.getFlags() | 1);
        }
        return res;
    }

    private Statement convertStatement(JCTree.JCStatement javac, ASTNode parent) {
        int preferredPos;
        int endPos = TreeInfo.getEndPos(javac, this.javacCompilationUnit.endPositions);
        if (endPos < (preferredPos = javac.getPreferredPosition())) {
            return null;
        }
        if (javac instanceof JCTree.JCReturn) {
            JCTree.JCReturn returnStatement = (JCTree.JCReturn)javac;
            ReturnStatement res = this.ast.newReturnStatement();
            this.commonSettings((ASTNode)res, javac);
            if (returnStatement.getExpression() != null) {
                res.setExpression(this.convertExpression(returnStatement.getExpression()));
            }
            return res;
        }
        if (javac instanceof JCTree.JCBlock) {
            JCTree.JCBlock block = (JCTree.JCBlock)javac;
            return this.convertBlock(block);
        }
        if (javac instanceof JCTree.JCExpressionStatement) {
            JCTree.JCExpression expr;
            JCTree.JCExpression methodName;
            JCTree.JCMethodInvocation jcMethodInvocation;
            JCTree.JCExpression jCExpression;
            JCTree.JCExpressionStatement jcExpressionStatement = (JCTree.JCExpressionStatement)javac;
            JCTree.JCExpression jcExpression = jcExpressionStatement.getExpression();
            if (jcExpression instanceof JCTree.JCMethodInvocation && (jCExpression = (jcMethodInvocation = (JCTree.JCMethodInvocation)jcExpression).getMethodSelect()) instanceof JCTree.JCIdent && Objects.equals(((JCTree.JCIdent)(methodName = (JCTree.JCIdent)jCExpression)).getName(), Names.instance((Context)this.context)._this)) {
                return this.convertThisConstructorInvocation(jcMethodInvocation);
            }
            if (jcExpressionStatement.getExpression() == null) {
                return null;
            }
            methodName = jcExpressionStatement.getExpression();
            if (methodName instanceof JCTree.JCErroneous) {
                JCTree.JCErroneous jcError = (JCTree.JCErroneous)methodName;
                if (((List)jcError.getErrorTrees()).size() == 1) {
                    JCTree tree = (JCTree)((List)jcError.getErrorTrees()).get(0);
                    if (tree instanceof JCTree.JCStatement) {
                        JCTree.JCStatement nestedStmt = (JCTree.JCStatement)tree;
                        try {
                            Statement stmt = this.convertStatement(nestedStmt, parent);
                            if (stmt != null) {
                                stmt.setFlags(stmt.getFlags() | 8);
                            }
                            return stmt;
                        }
                        catch (Exception stmt) {
                            // empty catch block
                        }
                    }
                    if (tree instanceof JCTree.JCExpression) {
                        expr = (JCTree.JCExpression)tree;
                        Expression expression = this.convertExpression(expr);
                        if (expression instanceof SimpleName) {
                            SimpleName simpleName = (SimpleName)expression;
                            if (expression.getStartPosition() + expression.getLength() + 1 < this.rawText.length() && Character.isSpaceChar(this.rawText.charAt(expression.getStartPosition() + expression.getLength()))) {
                                VariableDeclarationFragment fakeVdf = this.ast.newVariableDeclarationFragment();
                                SimpleName fakeSimpleName = this.ast.newSimpleName(FAKE_IDENTIFIER);
                                int fakePos = expression.getStartPosition() + expression.getLength() + 1;
                                fakeSimpleName.setSourceRange(fakePos, 0);
                                fakeVdf.setName(fakeSimpleName);
                                fakeVdf.setSourceRange(fakePos, 0);
                                fakeVdf.setFlags(fakeVdf.getFlags() | 1);
                                SimpleType simpleType = this.ast.newSimpleType((Name)simpleName);
                                this.commonSettings((ASTNode)simpleType, expr);
                                VariableDeclarationStatement res = this.ast.newVariableDeclarationStatement(fakeVdf);
                                res.setType((Type)simpleType);
                                this.commonSettings((ASTNode)res, expr);
                                return res;
                            }
                        }
                        ExpressionStatement res = this.ast.newExpressionStatement(expression);
                        this.commonSettings((ASTNode)res, javac);
                        return res;
                    }
                }
                parent.setFlags(parent.getFlags() | 1);
                return null;
            }
            boolean uniqueCaseFound = false;
            expr = jcExpressionStatement.getExpression();
            if (expr instanceof JCTree.JCMethodInvocation) {
                JCTree.JCFieldAccess jcfa;
                JCTree.JCIdent ident;
                JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)expr;
                JCTree.JCExpression nameExpr = methodInvocation.getMethodSelect();
                if (nameExpr instanceof JCTree.JCIdent && Objects.equals((ident = (JCTree.JCIdent)nameExpr).getName(), Names.instance((Context)this.context)._super)) {
                    uniqueCaseFound = true;
                }
                if (nameExpr instanceof JCTree.JCFieldAccess && Objects.equals((jcfa = (JCTree.JCFieldAccess)nameExpr).getIdentifier(), Names.instance((Context)this.context)._super)) {
                    uniqueCaseFound = true;
                }
            }
            if (uniqueCaseFound) {
                return this.convertSuperConstructorInvocation((JCTree.JCMethodInvocation)jcExpressionStatement.getExpression());
            }
            ExpressionStatement res = this.ast.newExpressionStatement(this.convertExpression(jcExpressionStatement.getExpression()));
            this.commonSettings((ASTNode)res, javac);
            return res;
        }
        if (javac instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)javac;
            VariableDeclarationFragment fragment = this.createVariableDeclarationFragment(jcVariableDecl);
            if (jcVariableDecl.vartype != null) {
                java.util.List<Object> sameStartPosition = java.util.List.of();
                if (parent instanceof Block) {
                    Block decl = (Block)parent;
                    sameStartPosition = decl.statements().stream().filter(VariableDeclarationStatement.class::isInstance).map(VariableDeclarationStatement.class::cast).filter(x -> x.getType().getStartPosition() == jcVariableDecl.vartype.getStartPosition()).toList();
                } else if (parent instanceof ForStatement) {
                    ForStatement decl = (ForStatement)parent;
                    sameStartPosition = decl.initializers().stream().filter(VariableDeclarationExpression.class::isInstance).map(VariableDeclarationExpression.class::cast).filter(x -> x.getType().getStartPosition() == jcVariableDecl.vartype.getStartPosition()).toList();
                } else if (parent instanceof SwitchStatement) {
                    SwitchStatement decl = (SwitchStatement)parent;
                    sameStartPosition = decl.statements().stream().filter(VariableDeclarationStatement.class::isInstance).map(VariableDeclarationStatement.class::cast).filter(x -> x.getType().getStartPosition() == jcVariableDecl.vartype.getStartPosition()).toList();
                }
                if (sameStartPosition.size() >= 1) {
                    Object obj0 = sameStartPosition.get(0);
                    if (obj0 instanceof VariableDeclarationStatement) {
                        VariableDeclarationStatement fd = (VariableDeclarationStatement)obj0;
                        fd.fragments().add(fragment);
                        int newParentEnd = fragment.getStartPosition() + fragment.getLength();
                        fd.setSourceRange(fd.getStartPosition(), newParentEnd - fd.getStartPosition() + 1);
                        this.removeSurroundingWhitespaceFromRange((ASTNode)fd);
                    } else if (obj0 instanceof VariableDeclarationExpression) {
                        VariableDeclarationExpression fd = (VariableDeclarationExpression)obj0;
                        fd.fragments().add(fragment);
                        int newParentEnd = fragment.getStartPosition() + fragment.getLength();
                        fd.setSourceRange(fd.getStartPosition(), newParentEnd - fd.getStartPosition() + 1);
                        this.removeTrailingSemicolonFromRange((ASTNode)fd);
                        this.removeSurroundingWhitespaceFromRange((ASTNode)fd);
                    }
                    return null;
                }
            }
            VariableDeclarationStatement res = this.ast.newVariableDeclarationStatement(fragment);
            this.commonSettings((ASTNode)res, javac);
            if (jcVariableDecl.vartype != null) {
                int fragmentDimensions = fragment.getExtraDimensions();
                res.setType(this.convertToType(this.unwrapDimensions(jcVariableDecl.vartype, fragmentDimensions)));
            } else if (jcVariableDecl.declaredUsingVar()) {
                SimpleType st = this.ast.newSimpleType((Name)this.ast.newSimpleName("var"));
                st.setSourceRange(javac.getStartPosition(), 3);
                res.setType((Type)st);
            }
            res.modifiers().addAll(this.convert(jcVariableDecl.getModifiers(), (ASTNode)res));
            return res;
        }
        if (javac instanceof JCTree.JCIf) {
            JCTree.JCIf ifStatement = (JCTree.JCIf)javac;
            return this.convertIfStatement(ifStatement);
        }
        if (javac instanceof JCTree.JCThrow) {
            JCTree.JCThrow throwStatement = (JCTree.JCThrow)javac;
            ThrowStatement res = this.ast.newThrowStatement();
            this.commonSettings((ASTNode)res, javac);
            res.setExpression(this.convertExpression(throwStatement.getExpression()));
            return res;
        }
        if (javac instanceof JCTree.JCTry) {
            JCTree.JCTry tryStatement = (JCTree.JCTry)javac;
            return this.convertTryStatement(tryStatement, parent);
        }
        if (javac instanceof JCTree.JCSynchronized) {
            JCTree.JCSynchronized jcSynchronized = (JCTree.JCSynchronized)javac;
            SynchronizedStatement res = this.ast.newSynchronizedStatement();
            this.commonSettings((ASTNode)res, javac);
            JCTree.JCExpression syncExpr = jcSynchronized.getExpression();
            if (syncExpr instanceof JCTree.JCParens) {
                JCTree.JCParens jcp = (JCTree.JCParens)syncExpr;
                syncExpr = jcp.getExpression();
            }
            res.setExpression(this.convertExpression(syncExpr));
            res.setBody(this.convertBlock(jcSynchronized.getBlock()));
            return res;
        }
        if (javac instanceof JCTree.JCForLoop) {
            Expression expr;
            JCTree.JCForLoop jcForLoop = (JCTree.JCForLoop)javac;
            ForStatement res = this.ast.newForStatement();
            this.commonSettings((ASTNode)res, javac);
            Statement stmt = this.convertStatement(jcForLoop.getStatement(), (ASTNode)res);
            if (stmt != null) {
                res.setBody(stmt);
            }
            Iterator initializerIt = ((List)jcForLoop.getInitializer()).iterator();
            while (initializerIt.hasNext()) {
                expr = this.convertStatementToExpression((JCTree.JCStatement)initializerIt.next(), (ASTNode)res);
                if (expr == null) continue;
                res.initializers().add(expr);
            }
            if (jcForLoop.getCondition() != null && (expr = this.convertExpression(jcForLoop.getCondition())) != null) {
                res.setExpression(expr);
            }
            Iterator updateIt = ((List)jcForLoop.getUpdate()).iterator();
            while (updateIt.hasNext()) {
                Expression expr2 = this.convertStatementToExpression((JCTree.JCStatement)updateIt.next(), (ASTNode)res);
                if (expr2 == null) continue;
                res.updaters().add(expr2);
            }
            return res;
        }
        if (javac instanceof JCTree.JCEnhancedForLoop) {
            Statement stmt;
            JCTree.JCEnhancedForLoop jcEnhancedForLoop = (JCTree.JCEnhancedForLoop)javac;
            EnhancedForStatement res = this.ast.newEnhancedForStatement();
            this.commonSettings((ASTNode)res, javac);
            res.setParameter((SingleVariableDeclaration)this.convertVariableDeclaration(jcEnhancedForLoop.getVariable()));
            Expression expr = this.convertExpression(jcEnhancedForLoop.getExpression());
            if (expr != null) {
                res.setExpression(expr);
            }
            if ((stmt = this.convertStatement(jcEnhancedForLoop.getStatement(), (ASTNode)res)) != null) {
                res.setBody(stmt);
            }
            return res;
        }
        if (javac instanceof JCTree.JCBreak) {
            JCTree.JCBreak jcBreak = (JCTree.JCBreak)javac;
            BreakStatement res = this.ast.newBreakStatement();
            this.commonSettings((ASTNode)res, javac);
            if (jcBreak.getLabel() != null) {
                res.setLabel((SimpleName)this.convertName(jcBreak.getLabel()));
            }
            return res;
        }
        if (javac instanceof JCTree.JCSwitch) {
            JCTree.JCSwitch jcSwitch = (JCTree.JCSwitch)javac;
            SwitchStatement res = this.ast.newSwitchStatement();
            this.commonSettings((ASTNode)res, javac);
            JCTree.JCExpression switchExpr = jcSwitch.getExpression();
            if (switchExpr instanceof JCTree.JCParens) {
                JCTree.JCParens jcp = (JCTree.JCParens)switchExpr;
                switchExpr = jcp.getExpression();
            }
            res.setExpression(this.convertExpression(switchExpr));
            jcSwitch.getCases().stream().flatMap(switchCase -> {
                ArrayList<JCTree.JCStatement> stmts = new ArrayList<JCTree.JCStatement>();
                switch (switchCase.getCaseKind()) {
                    case STATEMENT: {
                        int numStatements = switchCase.getStatements() != null ? ((List)switchCase.getStatements()).size() : 0;
                        stmts.add((JCTree.JCStatement)switchCase);
                        if (numStatements > 0) {
                            stmts.addAll(switchCase.getStatements());
                        }
                        return stmts.stream();
                    }
                    case RULE: {
                        stmts.add((JCTree.JCStatement)switchCase);
                        JCTree body = switchCase.getBody();
                        if (!(body instanceof JCTree.JCExpressionStatement)) break;
                        JCTree.JCExpressionStatement stmt = (JCTree.JCExpressionStatement)body;
                        stmts.add(stmt);
                    }
                }
                return stmts.stream();
            }).map(x -> this.convertStatement((JCTree.JCStatement)x, (ASTNode)res)).filter(x -> x != null).forEach(res.statements()::add);
            return res;
        }
        if (javac instanceof JCTree.JCCase) {
            JCTree.JCCase jcCase = (JCTree.JCCase)javac;
            return this.convertSwitchCase(jcCase);
        }
        if (javac instanceof JCTree.JCWhileLoop) {
            JCTree.JCWhileLoop jcWhile = (JCTree.JCWhileLoop)javac;
            WhileStatement res = this.ast.newWhileStatement();
            this.commonSettings((ASTNode)res, javac);
            JCTree.JCExpression expr = jcWhile.getCondition();
            if (expr instanceof JCTree.JCParens) {
                JCTree.JCParens jcp = (JCTree.JCParens)expr;
                expr = jcp.getExpression();
            }
            res.setExpression(this.convertExpression(expr));
            Statement body = this.convertStatement(jcWhile.getStatement(), (ASTNode)res);
            if (body != null) {
                res.setBody(body);
            }
            return res;
        }
        if (javac instanceof JCTree.JCDoWhileLoop) {
            Statement body;
            JCTree.JCDoWhileLoop jcDoWhile = (JCTree.JCDoWhileLoop)javac;
            DoStatement res = this.ast.newDoStatement();
            this.commonSettings((ASTNode)res, javac);
            JCTree.JCExpression expr = jcDoWhile.getCondition();
            if (expr instanceof JCTree.JCParens) {
                JCTree.JCParens jcp = (JCTree.JCParens)expr;
                expr = jcp.getExpression();
            }
            Expression expr1 = this.convertExpression(expr);
            if (expr != null) {
                res.setExpression(expr1);
            }
            if ((body = this.convertStatement(jcDoWhile.getStatement(), (ASTNode)res)) != null) {
                res.setBody(body);
            }
            return res;
        }
        if (javac instanceof JCTree.JCYield) {
            JCTree.JCYield jcYield = (JCTree.JCYield)javac;
            YieldStatement res = this.ast.newYieldStatement();
            this.commonSettings((ASTNode)res, javac);
            res.setExpression(this.convertExpression(jcYield.getValue()));
            return res;
        }
        if (javac instanceof JCTree.JCContinue) {
            JCTree.JCContinue jcContinue = (JCTree.JCContinue)javac;
            ContinueStatement res = this.ast.newContinueStatement();
            this.commonSettings((ASTNode)res, javac);
            if (jcContinue.getLabel() != null) {
                res.setLabel((SimpleName)this.convertName(jcContinue.getLabel()));
            }
            return res;
        }
        if (javac instanceof JCTree.JCLabeledStatement) {
            JCTree.JCLabeledStatement jcLabel = (JCTree.JCLabeledStatement)javac;
            LabeledStatement res = this.ast.newLabeledStatement();
            this.commonSettings((ASTNode)res, javac);
            res.setLabel((SimpleName)this.convertName(jcLabel.getLabel()));
            Statement stmt = this.convertStatement(jcLabel.getStatement(), (ASTNode)res);
            if (stmt != null) {
                res.setBody(stmt);
            }
            return res;
        }
        if (javac instanceof JCTree.JCAssert) {
            Expression det;
            JCTree.JCAssert jcAssert = (JCTree.JCAssert)javac;
            AssertStatement res = this.ast.newAssertStatement();
            this.commonSettings((ASTNode)res, javac);
            Expression expr = this.convertExpression(jcAssert.getCondition());
            if (expr != null) {
                res.setExpression(expr);
            }
            if (jcAssert.getDetail() != null && (det = this.convertExpression(jcAssert.getDetail())) != null) {
                res.setMessage(det);
            }
            return res;
        }
        if (javac instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl jcclass = (JCTree.JCClassDecl)javac;
            TypeDeclarationStatement res = this.ast.newTypeDeclarationStatement(this.convertClassDecl(jcclass, parent, true));
            this.commonSettings((ASTNode)res, javac);
            return res;
        }
        if (javac instanceof JCTree.JCSkip) {
            EmptyStatement res = this.ast.newEmptyStatement();
            this.commonSettings((ASTNode)res, javac);
            return res;
        }
        throw new UnsupportedOperationException("Missing support to convert " + String.valueOf(javac) + "of type " + javac.getClass().getName());
    }

    private Statement convertSwitchCase(JCTree.JCCase jcCase) {
        SwitchCase res = this.ast.newSwitchCase();
        this.commonSettings((ASTNode)res, jcCase);
        if (this.ast.apiLevel >= 14) {
            if (jcCase.getGuard() != null && (((List)jcCase.getLabels()).size() > 1 || ((List)jcCase.getLabels()).get(0) instanceof JCTree.JCPatternCaseLabel)) {
                int end2;
                int start;
                GuardedPattern guardedPattern = this.ast.newGuardedPattern();
                guardedPattern.setExpression(this.convertExpression(jcCase.getGuard()));
                guardedPattern.setRestrictedIdentifierStartPosition(jcCase.guard.getStartPosition() - 5);
                if (((List)jcCase.getLabels()).length() > 1) {
                    start = Integer.MAX_VALUE;
                    end2 = Integer.MIN_VALUE;
                    EitherOrMultiPattern eitherOrMultiPattern = this.ast.newEitherOrMultiPattern();
                    for (JCTree.JCCaseLabel label : jcCase.getLabels()) {
                        if (label.pos < start) {
                            start = label.pos;
                        }
                        if (end2 < label.getEndPosition(this.javacCompilationUnit.endPositions)) {
                            end2 = label.getEndPosition(this.javacCompilationUnit.endPositions);
                        }
                        if (!(label instanceof JCTree.JCPatternCaseLabel)) continue;
                        JCTree.JCPatternCaseLabel jcPattern = (JCTree.JCPatternCaseLabel)label;
                        eitherOrMultiPattern.patterns().add(this.convert(jcPattern.getPattern()));
                    }
                    eitherOrMultiPattern.setSourceRange(start, end2 - start);
                    guardedPattern.setPattern((Pattern)eitherOrMultiPattern);
                } else if (((List)jcCase.getLabels()).length() == 1) {
                    Object end2 = ((List)jcCase.getLabels()).get(0);
                    if (end2 instanceof JCTree.JCPatternCaseLabel) {
                        JCTree.JCPatternCaseLabel jcPattern = (JCTree.JCPatternCaseLabel)end2;
                        guardedPattern.setPattern(this.convert(jcPattern.getPattern()));
                    } else {
                        throw new UnsupportedOperationException("cannot convert case label: " + String.valueOf(((List)jcCase.getLabels()).get(0)));
                    }
                }
                start = guardedPattern.getPattern().getStartPosition();
                end2 = guardedPattern.getExpression().getStartPosition() + guardedPattern.getExpression().getLength();
                guardedPattern.setSourceRange(start, end2 - start);
                res.expressions().add(guardedPattern);
            } else {
                Object start;
                if (((List)jcCase.getLabels()).length() == 1 && (start = ((List)jcCase.getLabels()).get(0)) instanceof JCTree.JCPatternCaseLabel) {
                    JCTree.JCPatternCaseLabel jcPattern = (JCTree.JCPatternCaseLabel)start;
                    Pattern p = this.convert(jcPattern.getPattern());
                    if (p != null) {
                        int start2 = jcPattern.getStartPosition();
                        p.setSourceRange(start2, jcPattern.getEndPosition(this.javacCompilationUnit.endPositions) - start2);
                        res.expressions().add(p);
                    }
                } else {
                    for (JCTree.JCCaseLabel jcLabel : jcCase.getLabels()) {
                        JCTree.JCCaseLabel jCCaseLabel;
                        Objects.requireNonNull(jcLabel);
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JCTree.JCConstantCaseLabel.class, JCTree.JCDefaultCaseLabel.class}, (JCTree.JCCaseLabel)jCCaseLabel, n)) {
                            case 0: {
                                JCTree.JCConstantCaseLabel constantLabel = (JCTree.JCConstantCaseLabel)jCCaseLabel;
                                if (!constantLabel.expr.toString().equals("null")) break;
                                res.expressions().add(this.ast.newNullLiteral());
                                break;
                            }
                            case 1: {
                                JCTree.JCDefaultCaseLabel defaultCase = (JCTree.JCDefaultCaseLabel)jCCaseLabel;
                                if (((List)jcCase.getLabels()).size() == 1) break;
                                res.expressions().add(this.ast.newCaseDefaultExpression());
                                break;
                            }
                        }
                    }
                    int start1 = res.getStartPosition();
                    int colon = this.rawText.indexOf(":", start1);
                    if (colon != -1) {
                        res.setSourceRange(start1, colon - start1 + 1);
                    }
                }
                jcCase.getExpressions().stream().map(this::convertExpression).forEach(res.expressions()::add);
            }
            res.setSwitchLabeledRule(jcCase.getCaseKind() == CaseTree.CaseKind.RULE);
        } else {
            java.util.List l;
            int start1 = res.getStartPosition();
            int colon = this.rawText.indexOf(":", start1);
            if (colon != -1) {
                res.setSourceRange(start1, colon - start1 + 1);
            }
            if ((l = jcCase.getExpressions()).size() == 1) {
                res.setExpression(this.convertExpression((JCTree.JCExpression)l.get(0)));
            } else if (l.size() == 0) {
                res.setExpression(null);
            }
        }
        return res;
    }

    private Expression convertStatementToExpression(JCTree.JCStatement javac, ASTNode parent) {
        VariableDeclarationStatement decl;
        if (javac instanceof JCTree.JCExpressionStatement) {
            JCTree.JCExpressionStatement jcExpressionStatement = (JCTree.JCExpressionStatement)javac;
            return this.convertExpression(jcExpressionStatement.getExpression());
        }
        Statement javacStatement = this.convertStatement(javac, parent);
        if (javacStatement instanceof VariableDeclarationStatement && (decl = (VariableDeclarationStatement)javacStatement).fragments().size() == 1) {
            javacStatement.delete();
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)decl.fragments().get(0);
            fragment.delete();
            VariableDeclarationExpression jdtVariableDeclarationExpression = this.ast.newVariableDeclarationExpression(fragment);
            this.commonSettings((ASTNode)jdtVariableDeclarationExpression, javac);
            if (javac instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl jcvd = (JCTree.JCVariableDecl)javac;
                if (jcvd.vartype != null) {
                    JCTree.JCExpression jCExpression = jcvd.vartype;
                    if (jCExpression instanceof JCTree.JCArrayTypeTree) {
                        JCTree.JCArrayTypeTree jcatt = (JCTree.JCArrayTypeTree)jCExpression;
                        int extraDims = 0;
                        if (fragment.extraDimensions() != null && fragment.extraDimensions().size() > 0) {
                            extraDims = fragment.extraDimensions().size();
                        }
                        jdtVariableDeclarationExpression.setType(this.convertToType(this.unwrapDimensions(jcatt, extraDims)));
                    } else {
                        jdtVariableDeclarationExpression.setType(this.convertToType(this.findBaseType(jcvd.vartype)));
                    }
                }
            }
            return jdtVariableDeclarationExpression;
        }
        return null;
    }

    private JCTree findBaseType(JCTree.JCExpression vartype) {
        if (vartype instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCArrayTypeTree jcatt = (JCTree.JCArrayTypeTree)vartype;
            return this.findBaseType(jcatt.elemtype);
        }
        return vartype;
    }

    private Block convertBlock(JCTree.JCBlock javac) {
        Block res = this.ast.newBlock();
        this.commonSettings((ASTNode)res, javac);
        if (javac.getStatements() != null) {
            for (JCTree.JCStatement next : javac.getStatements()) {
                Statement s = this.convertStatement(next, (ASTNode)res);
                if (s == null) continue;
                res.statements().add(s);
            }
        }
        return res;
    }

    private TryStatement convertTryStatement(JCTree.JCTry javac, ASTNode parent) {
        TryStatement res = this.ast.newTryStatement();
        this.commonSettings((ASTNode)res, javac);
        res.setBody(this.convertBlock(javac.getBlock()));
        if (javac.finalizer != null) {
            res.setFinally(this.convertBlock(javac.getFinallyBlock()));
        }
        if (((List)javac.getResources()).size() > 0) {
            Iterator it = ((List)javac.getResources()).iterator();
            while (it.hasNext()) {
                Expression working = this.convertTryResource((JCTree)it.next(), parent);
                if (working instanceof VariableDeclarationExpression) {
                    res.resources().add(working);
                    continue;
                }
                if (this.ast.apiLevel >= 9 && working instanceof Name) {
                    res.resources().add(working);
                    continue;
                }
                if (this.ast.apiLevel >= 9 && working instanceof SuperFieldAccess) {
                    res.resources().add(working);
                    continue;
                }
                if (this.ast.apiLevel >= 9 && working instanceof FieldAccess) {
                    res.resources().add(working);
                    continue;
                }
                res.setFlags(res.getFlags() | 1);
            }
        }
        javac.getCatches().stream().map(this::convertCatcher).forEach(res.catchClauses()::add);
        return res;
    }

    private Expression convertTryResource(JCTree javac, ASTNode parent) {
        if (javac instanceof JCTree.JCVariableDecl) {
            VariableDeclarationFragment fragment;
            JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)javac;
            VariableDeclaration converted = this.convertVariableDeclaration(decl);
            if (converted instanceof VariableDeclarationFragment) {
                VariableDeclarationFragment f;
                fragment = f = (VariableDeclarationFragment)converted;
            } else if (converted instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration single = (SingleVariableDeclaration)converted;
                single.delete();
                this.domToJavac.remove(single);
                fragment = this.ast.newVariableDeclarationFragment();
                this.commonSettings((ASTNode)fragment, javac);
                fragment.setFlags(single.getFlags());
                SimpleName name = (SimpleName)single.getName().clone(this.ast);
                fragment.setName(name);
                Expression initializer = single.getInitializer();
                if (initializer != null) {
                    initializer.delete();
                    fragment.setInitializer(initializer);
                }
                for (Dimension extraDimension : single.extraDimensions()) {
                    extraDimension.delete();
                    fragment.extraDimensions().add(extraDimension);
                }
            } else {
                fragment = this.ast.newVariableDeclarationFragment();
            }
            VariableDeclarationExpression res = this.ast.newVariableDeclarationExpression(fragment);
            this.commonSettings((ASTNode)res, javac);
            this.removeTrailingSemicolonFromRange((ASTNode)res);
            res.setType(this.convertToType(decl.getType()));
            res.modifiers().addAll(this.convert(decl.getModifiers(), (ASTNode)res));
            return res;
        }
        if (javac instanceof JCTree.JCExpression) {
            JCTree.JCExpression jcExpression = (JCTree.JCExpression)javac;
            return this.convertExpression(jcExpression);
        }
        return null;
    }

    private void removeTrailingSemicolonFromRange(ASTNode res) {
        this.removeTrailingCharFromRange(res, new char[]{';'});
    }

    private void ensureTrailingSemicolonInRange(ASTNode res) {
        int end = res.getStartPosition() + res.getLength();
        if (end < this.rawText.length() && this.rawText.charAt(end - 1) != ';' && this.rawText.charAt(end) == ';') {
            res.setSourceRange(res.getStartPosition(), res.getLength() + 1);
        }
    }

    private void removeSurroundingWhitespaceFromRange(ASTNode res) {
        int start = res.getStartPosition();
        if (start >= 0 && start < this.rawText.length()) {
            String rawSource = this.rawText.substring(start, start + res.getLength());
            int trimLeading = rawSource.length() - rawSource.stripLeading().length();
            int trimTrailing = rawSource.length() - rawSource.stripTrailing().length();
            if ((trimLeading != 0 || trimTrailing != 0) && res.getLength() > trimLeading + trimTrailing) {
                res.setSourceRange(start + trimLeading, res.getLength() - trimLeading - trimTrailing);
            }
        }
    }

    private void removeTrailingCharFromRange(ASTNode res, char[] possible) {
        if (res.getLength() == 0) {
            return;
        }
        int endPos = res.getStartPosition() + res.getLength();
        char lastChar = this.rawText.charAt(endPos - 1);
        boolean found = false;
        for (int i = 0; i < possible.length; ++i) {
            if (lastChar != possible[i]) continue;
            found = true;
        }
        if (found) {
            res.setSourceRange(res.getStartPosition(), res.getLength() - 1);
        }
    }

    private CatchClause convertCatcher(JCTree.JCCatch javac) {
        CatchClause res = this.ast.newCatchClause();
        this.commonSettings((ASTNode)res, javac);
        res.setBody(this.convertBlock(javac.getBlock()));
        res.setException((SingleVariableDeclaration)this.convertVariableDeclaration(javac.getParameter()));
        return res;
    }

    private IfStatement convertIfStatement(JCTree.JCIf javac) {
        Statement stmt;
        IfStatement res = this.ast.newIfStatement();
        this.commonSettings((ASTNode)res, javac);
        if (javac.getCondition() != null) {
            JCTree.JCExpression expr = javac.getCondition();
            if (expr instanceof JCTree.JCParens) {
                JCTree.JCParens jpc = (JCTree.JCParens)expr;
                res.setExpression(this.convertExpression(jpc.getExpression()));
            } else {
                res.setExpression(this.convertExpression(expr));
            }
        }
        if (javac.getThenStatement() != null && (stmt = this.convertStatement(javac.getThenStatement(), (ASTNode)res)) != null) {
            res.setThenStatement(stmt);
        }
        if (javac.getElseStatement() != null && (stmt = this.convertStatement(javac.getElseStatement(), (ASTNode)res)) != null) {
            res.setElseStatement(stmt);
        }
        return res;
    }

    Type convertToType(JCTree javac) {
        if (javac instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javac;
            Name name = this.convertName(ident.name);
            int len = FAKE_IDENTIFIER.equals(name.toString()) ? 0 : ident.name.length();
            int startPosition = ident.getStartPosition();
            if (startPosition < 0 && ident.type instanceof Type.PackageType) {
                ILog.get().info("negative start position " + startPosition);
                startPosition = 0;
            }
            name.setSourceRange(startPosition, len);
            SimpleType res = this.ast.newSimpleType(name);
            this.commonSettings((ASTNode)res, ident);
            this.commonSettings((ASTNode)name, ident);
            return res;
        }
        if (javac instanceof JCTree.JCFieldAccess) {
            SimpleType simpleType;
            JCTree.JCFieldAccess qualified = (JCTree.JCFieldAccess)javac;
            try {
                if (qualified.getExpression() == null) {
                    Name qn = this.toName(qualified);
                    this.commonSettings((ASTNode)qn, javac);
                    SimpleType res = this.ast.newSimpleType(qn);
                    this.commonSettings((ASTNode)res, qualified);
                    return res;
                }
            }
            catch (Exception qn) {
                // empty catch block
            }
            Type qualifierType = this.convertToType(qualified.getExpression());
            SimpleName simpleName = (SimpleName)this.convertName(qualified.getIdentifier());
            int simpleNameStart = this.rawText.indexOf(simpleName.getIdentifier(), qualifierType.getStartPosition() + qualifierType.getLength());
            if (simpleNameStart > 0) {
                simpleName.setSourceRange(simpleNameStart, simpleName.getIdentifier().length());
            } else {
                if (simpleName.getIdentifier().isEmpty()) {
                    simpleName.delete();
                    return qualifierType;
                }
                if (MISSING_IDENTIFIER.equals(simpleName.getFullyQualifiedName())) {
                    simpleName.setSourceRange(qualifierType.getStartPosition(), 0);
                } else {
                    simpleName.setSourceRange(0, 0);
                }
            }
            if (qualifierType instanceof SimpleType && (simpleType = (SimpleType)qualifierType).annotations().isEmpty()) {
                simpleType.delete();
                Name parentName = simpleType.getName();
                parentName.setParent(null, null);
                QualifiedName name = this.ast.newQualifiedName(simpleType.getName(), simpleName);
                this.commonSettings((ASTNode)name, javac);
                int length = simpleType.getName().getLength() + 1 + simpleName.getLength();
                if (simpleNameStart > 0 && name.getStartPosition() >= 0) {
                    name.setSourceRange(name.getStartPosition(), Math.max(0, length));
                } else if (!MISSING_IDENTIFIER.equals(simpleName.getFullyQualifiedName())) {
                    name.setSourceRange(0, 0);
                }
                SimpleType res = this.ast.newSimpleType((Name)name);
                this.commonSettings((ASTNode)res, javac);
                if (simpleNameStart > 0 && name.getStartPosition() >= 0) {
                    res.setSourceRange(name.getStartPosition(), Math.max(0, length));
                } else if (!MISSING_IDENTIFIER.equals(simpleName.getFullyQualifiedName())) {
                    res.setSourceRange(0, 0);
                }
                return res;
            }
            QualifiedType res = this.ast.newQualifiedType(qualifierType, simpleName);
            this.commonSettings((ASTNode)res, qualified);
            return res;
        }
        if (javac instanceof JCTree.JCPrimitiveTypeTree) {
            JCTree.JCPrimitiveTypeTree primitiveTypeTree = (JCTree.JCPrimitiveTypeTree)javac;
            PrimitiveType res = this.ast.newPrimitiveType(this.convert(primitiveTypeTree.getPrimitiveTypeKind()));
            this.commonSettings((ASTNode)res, primitiveTypeTree);
            return res;
        }
        if (javac instanceof JCTree.JCTypeUnion) {
            JCTree.JCTypeUnion union = (JCTree.JCTypeUnion)javac;
            UnionType res = this.ast.newUnionType();
            this.commonSettings((ASTNode)res, javac);
            union.getTypeAlternatives().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.types()::add);
            return res;
        }
        if (javac instanceof JCTree.JCArrayTypeTree) {
            ArrayType res;
            JCTree.JCArrayTypeTree jcArrayType = (JCTree.JCArrayTypeTree)javac;
            Type t = this.convertToType(jcArrayType.getType());
            if (t == null) {
                return null;
            }
            if (t instanceof ArrayType) {
                ArrayType childArrayType;
                res = childArrayType = (ArrayType)t;
                res.dimensions().addFirst(this.ast.newDimension());
                this.commonSettings((ASTNode)res, jcArrayType);
            } else {
                int dims = this.countDimensions(jcArrayType);
                res = this.ast.newArrayType(t);
                if (dims == 0) {
                    this.commonSettings((ASTNode)res, jcArrayType);
                } else {
                    int endPos = jcArrayType.getEndPosition(this.javacCompilationUnit.endPositions);
                    if (endPos == -1) {
                        endPos = jcArrayType.pos;
                    }
                    int startPos = jcArrayType.getStartPosition();
                    try {
                        String raw = this.rawText.substring(startPos, endPos);
                        int ordinalEnd = JavacConverter.ordinalIndexOf(raw, "]", dims);
                        int ordinalStart = JavacConverter.ordinalIndexOf(raw, "[", dims);
                        if (ordinalStart == -1) {
                            ordinalStart = JavacConverter.ordinalIndexOf(raw, "\\u005b", dims);
                        }
                        if (ordinalEnd != -1) {
                            this.commonSettings((ASTNode)res, jcArrayType, ordinalEnd + 1, true);
                            if (res.dimensions().size() > 0) {
                                ((Dimension)res.dimensions().get(0)).setSourceRange(startPos + ordinalStart, ordinalEnd - ordinalStart + 1);
                            }
                            return res;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.commonSettings((ASTNode)res, jcArrayType);
                }
            }
            return res;
        }
        if (javac instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply jcTypeApply = (JCTree.JCTypeApply)javac;
            ParameterizedType res = this.ast.newParameterizedType(this.convertToType(jcTypeApply.getType()));
            this.commonSettings((ASTNode)res, javac);
            jcTypeApply.getTypeArguments().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.typeArguments()::add);
            return res;
        }
        if (javac instanceof JCTree.JCWildcard) {
            JCTree.JCWildcard wc = (JCTree.JCWildcard)javac;
            WildcardType res = this.ast.newWildcardType();
            if (wc.kind.kind == BoundKind.SUPER) {
                Type bound = this.convertToType(wc.inner);
                res.setBound(bound, false);
            } else if (wc.kind.kind == BoundKind.EXTENDS) {
                Type bound = this.convertToType(wc.inner);
                res.setBound(bound, true);
            }
            this.commonSettings((ASTNode)res, javac);
            return res;
        }
        if (javac instanceof JCTree.JCTypeIntersection) {
            JCTree.JCTypeIntersection jcTypeIntersection = (JCTree.JCTypeIntersection)javac;
            IntersectionType res = this.ast.newIntersectionType();
            this.commonSettings((ASTNode)res, javac);
            jcTypeIntersection.getBounds().stream().map(this::convertToType).filter(Objects::nonNull).forEach(res.types()::add);
            return res;
        }
        if (javac instanceof JCTree.JCAnnotatedType) {
            ArrayType arrayType;
            JCTree.JCAnnotatedType jcAnnotatedType = (JCTree.JCAnnotatedType)javac;
            Type res = null;
            JCTree.JCExpression jcpe = jcAnnotatedType.getUnderlyingType();
            if (jcAnnotatedType.getAnnotations() != null && !((List)jcAnnotatedType.getAnnotations()).isEmpty() && !(jcpe instanceof JCTree.JCWildcard)) {
                if (jcpe instanceof JCTree.JCFieldAccess) {
                    JCTree.JCFieldAccess jcfa2 = (JCTree.JCFieldAccess)jcpe;
                    if (jcfa2.selected instanceof JCTree.JCAnnotatedType || jcfa2.selected instanceof JCTree.JCTypeApply) {
                        nameQualifiedType = new QualifiedType(this.ast);
                        this.commonSettings((ASTNode)nameQualifiedType, javac);
                        nameQualifiedType.setQualifier(this.convertToType(jcfa2.selected));
                        nameQualifiedType.setName(this.ast.newSimpleName(jcfa2.name.toString()));
                        res = nameQualifiedType;
                    } else {
                        nameQualifiedType = new NameQualifiedType(this.ast);
                        this.commonSettings((ASTNode)nameQualifiedType, javac);
                        nameQualifiedType.setQualifier(this.toName(jcfa2.selected));
                        nameQualifiedType.setName(this.ast.newSimpleName(jcfa2.name.toString()));
                        res = nameQualifiedType;
                    }
                } else if (jcpe instanceof JCTree.JCIdent) {
                    JCTree.JCIdent simpleType = (JCTree.JCIdent)jcpe;
                    res = this.ast.newSimpleType(this.convertName(simpleType.getName()));
                    this.commonSettings((ASTNode)res, javac);
                }
            }
            if (res == null) {
                res = this.convertToType(jcAnnotatedType.getUnderlyingType());
            }
            if (res instanceof AnnotatableType) {
                AnnotatableType annotatableType = (AnnotatableType)res;
                for (JCTree.JCAnnotation annotation : jcAnnotatedType.getAnnotations()) {
                    annotatableType.annotations().add(this.convert(annotation));
                }
            } else if (res instanceof ArrayType && !(arrayType = (ArrayType)res).dimensions().isEmpty()) {
                for (JCTree.JCAnnotation annotation : jcAnnotatedType.getAnnotations()) {
                    ((Dimension)arrayType.dimensions().get(0)).annotations().add(this.convert(annotation));
                }
            }
            return res;
        }
        if (javac instanceof JCTree.JCErroneous || javac == null) {
            SimpleType res = this.ast.newSimpleType((Name)this.ast.newSimpleName(FAKE_IDENTIFIER));
            if (javac instanceof JCTree.JCErroneous) {
                JCTree.JCErroneous err = (JCTree.JCErroneous)javac;
                int startPosition = err.getStartPosition();
                if (startPosition < 0) {
                    ILog.get().info("negative start position " + startPosition);
                    startPosition = 0;
                }
                res.setSourceRange(startPosition, 0);
            }
            res.setFlags(8);
            return res;
        }
        ILog.get().warn("Not supported yet, converting to type type " + String.valueOf(javac) + " of class" + String.valueOf(javac.getClass()));
        return null;
    }

    public static int ordinalIndexOf(String str, String substr, int n) {
        int pos = str.indexOf(substr);
        while (--n > 0 && pos != -1) {
            pos = str.indexOf(substr, pos + 1);
        }
        return pos;
    }

    private PrimitiveType.Code convert(TypeKind javac) {
        return switch (javac) {
            case TypeKind.BOOLEAN -> PrimitiveType.BOOLEAN;
            case TypeKind.BYTE -> PrimitiveType.BYTE;
            case TypeKind.SHORT -> PrimitiveType.SHORT;
            case TypeKind.INT -> PrimitiveType.INT;
            case TypeKind.LONG -> PrimitiveType.LONG;
            case TypeKind.CHAR -> PrimitiveType.CHAR;
            case TypeKind.FLOAT -> PrimitiveType.FLOAT;
            case TypeKind.DOUBLE -> PrimitiveType.DOUBLE;
            case TypeKind.VOID -> PrimitiveType.VOID;
            default -> throw new IllegalArgumentException(javac.toString());
        };
    }

    private Annotation convert(JCTree.JCAnnotation javac) {
        JCTree.JCAssign namedArg;
        Object result2;
        boolean mustUseNormalAnnot;
        int length;
        int startPos = javac.getStartPosition();
        String content = this.rawText.substring(startPos, startPos + (length = javac.getEndPosition(this.javacCompilationUnit.endPositions) - startPos));
        boolean bl = mustUseNormalAnnot = content != null && content.contains("(");
        if (((List)javac.getArguments()).size() == 0 && !mustUseNormalAnnot) {
            MarkerAnnotation res = this.ast.newMarkerAnnotation();
            this.commonSettings((ASTNode)res, javac);
            res.setTypeName(this.toName(javac.getAnnotationType()));
            return res;
        }
        if (((List)javac.getArguments()).size() == 1 && !(((List)javac.getArguments()).get(0) instanceof JCTree.JCAssign)) {
            SingleMemberAnnotation result2 = this.ast.newSingleMemberAnnotation();
            this.commonSettings((ASTNode)result2, javac);
            result2.setTypeName(this.toName(javac.annotationType));
            JCTree value = (JCTree)((List)javac.getArguments()).get(0);
            if (value != null) {
                if (value instanceof JCTree.JCExpression) {
                    JCTree.JCExpression jce = (JCTree.JCExpression)value;
                    result2.setValue(this.convertExpression(jce));
                } else {
                    result2.setValue((Expression)this.toName(value));
                }
            }
            return result2;
        }
        if (((List)javac.getArguments()).size() == 1 && (result2 = ((List)javac.getArguments()).get(0)) instanceof JCTree.JCAssign && ((namedArg = (JCTree.JCAssign)result2).getVariable().getPreferredPosition() == -1 || namedArg.getVariable().getPreferredPosition() == namedArg.getExpression().getPreferredPosition())) {
            result2 = this.ast.newSingleMemberAnnotation();
            this.commonSettings((ASTNode)result2, javac);
            result2.setTypeName(this.toName(javac.annotationType));
            JCTree.JCExpression value = namedArg.getExpression();
            if (value != null) {
                if (value instanceof JCTree.JCExpression) {
                    JCTree.JCExpression jce = value;
                    result2.setValue(this.convertExpression(jce));
                } else {
                    result2.setValue((Expression)this.toName(value));
                }
            }
            return result2;
        }
        NormalAnnotation res = this.ast.newNormalAnnotation();
        this.commonSettings((ASTNode)res, javac);
        res.setTypeName(this.toName(javac.getAnnotationType()));
        for (JCTree.JCExpression expr : javac.getArguments()) {
            if (!(expr instanceof JCTree.JCAssign)) continue;
            JCTree.JCAssign jcass = (JCTree.JCAssign)expr;
            JCTree.JCExpression jCExpression = jcass.lhs;
            if (!(jCExpression instanceof JCTree.JCIdent)) continue;
            JCTree.JCIdent jcid = (JCTree.JCIdent)jCExpression;
            MemberValuePair pair = new MemberValuePair(this.ast);
            this.commonSettings((ASTNode)pair, jcass);
            SimpleName simpleName = new SimpleName(this.ast);
            this.commonSettings((ASTNode)simpleName, jcid);
            simpleName.internalSetIdentifier(new String(jcid.getName().toString()));
            int start = jcid.pos;
            int end = start + jcid.getName().toString().length();
            simpleName.setSourceRange(start, end - start);
            pair.setName(simpleName);
            Expression value = null;
            JCTree.JCExpression jCExpression2 = jcass.rhs;
            if (jCExpression2 instanceof JCTree.JCNewArray) {
                JCTree.JCNewArray jcNewArray = (JCTree.JCNewArray)jCExpression2;
                ArrayInitializer initializer = this.ast.newArrayInitializer();
                this.commonSettings((ASTNode)initializer, javac);
                jcNewArray.getInitializers().stream().map(this::convertExpression).forEach(initializer.expressions()::add);
                value = initializer;
            } else {
                value = this.convertExpression(jcass.rhs);
            }
            this.commonSettings((ASTNode)value, jcass.rhs);
            pair.setValue(value);
            start = value.getStartPosition();
            end = value.getStartPosition() + value.getLength() - 1;
            pair.setSourceRange(start, end - start + 1);
            res.values().add(pair);
        }
        return res;
    }

    private java.util.List<IExtendedModifier> convert(JCTree.JCModifiers modifiers, ASTNode parent) {
        ArrayList<IExtendedModifier> res = new ArrayList<IExtendedModifier>();
        this.convertModifiers(modifiers, parent, res);
        this.convertModifierAnnotations(modifiers, parent, res);
        this.sortModifierNodesByPosition(res);
        return res;
    }

    private void sortModifierNodesByPosition(java.util.List<IExtendedModifier> l) {
        l.sort((o1, o2) -> {
            ASTNode a1 = (ASTNode)o1;
            ASTNode a2 = (ASTNode)o2;
            return a1.getStartPosition() - a2.getStartPosition();
        });
    }

    private void convertModifiers(JCTree.JCModifiers modifiers, ASTNode parent, java.util.List<IExtendedModifier> res) {
        Iterator<javax.lang.model.element.Modifier> mods = modifiers.getFlags().iterator();
        while (mods.hasNext()) {
            Modifier converted = this.convert(mods.next(), modifiers.pos, modifiers.getEndPosition(this.javacCompilationUnit.endPositions) + 1);
            if (converted.getStartPosition() < 0) continue;
            res.add((IExtendedModifier)converted);
        }
    }

    private java.util.List<IExtendedModifier> convertModifierAnnotations(JCTree.JCModifiers modifiers, ASTNode parent) {
        ArrayList<IExtendedModifier> res = new ArrayList<IExtendedModifier>();
        this.convertModifierAnnotations(modifiers, parent, res);
        this.sortModifierNodesByPosition(res);
        return res;
    }

    private void convertModifierAnnotations(JCTree.JCModifiers modifiers, ASTNode parent, java.util.List<IExtendedModifier> res) {
        modifiers.getAnnotations().stream().map(this::convert).forEach(res::add);
    }

    private java.util.List<IExtendedModifier> convertModifiersFromFlags(int startPos, int endPos, long oflags) {
        String rawTextSub = this.rawText.substring(startPos, endPos);
        ArrayList<IExtendedModifier> res = new ArrayList<IExtendedModifier>();
        Modifier.ModifierKeyword[] ops = new Modifier.ModifierKeyword[]{Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.PROTECTED_KEYWORD, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.NATIVE_KEYWORD, Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD, Modifier.ModifierKeyword.VOLATILE_KEYWORD, Modifier.ModifierKeyword.STRICTFP_KEYWORD, Modifier.ModifierKeyword.DEFAULT_KEYWORD, Modifier.ModifierKeyword.SEALED_KEYWORD, Modifier.ModifierKeyword.NON_SEALED_KEYWORD};
        for (int i = 0; i < ops.length; ++i) {
            Modifier.ModifierKeyword k = ops[i];
            int flagVal = k.toFlagValue();
            if ((oflags & (long)flagVal) <= 0L) continue;
            Modifier m = this.ast.newModifier(k);
            String asStr = k.toString();
            int foundLoc = rawTextSub.indexOf(asStr);
            if (foundLoc != -1) {
                m.setSourceRange(startPos + foundLoc, asStr.length());
            }
            res.add((IExtendedModifier)m);
        }
        return res;
    }

    private Modifier.ModifierKeyword modifierToKeyword(javax.lang.model.element.Modifier javac) {
        return switch (javac) {
            default -> throw new MatchException(null, null);
            case javax.lang.model.element.Modifier.PUBLIC -> Modifier.ModifierKeyword.PUBLIC_KEYWORD;
            case javax.lang.model.element.Modifier.PROTECTED -> Modifier.ModifierKeyword.PROTECTED_KEYWORD;
            case javax.lang.model.element.Modifier.PRIVATE -> Modifier.ModifierKeyword.PRIVATE_KEYWORD;
            case javax.lang.model.element.Modifier.ABSTRACT -> Modifier.ModifierKeyword.ABSTRACT_KEYWORD;
            case javax.lang.model.element.Modifier.DEFAULT -> Modifier.ModifierKeyword.DEFAULT_KEYWORD;
            case javax.lang.model.element.Modifier.STATIC -> Modifier.ModifierKeyword.STATIC_KEYWORD;
            case javax.lang.model.element.Modifier.SEALED -> Modifier.ModifierKeyword.SEALED_KEYWORD;
            case javax.lang.model.element.Modifier.NON_SEALED -> Modifier.ModifierKeyword.NON_SEALED_KEYWORD;
            case javax.lang.model.element.Modifier.FINAL -> Modifier.ModifierKeyword.FINAL_KEYWORD;
            case javax.lang.model.element.Modifier.TRANSIENT -> Modifier.ModifierKeyword.TRANSIENT_KEYWORD;
            case javax.lang.model.element.Modifier.VOLATILE -> Modifier.ModifierKeyword.VOLATILE_KEYWORD;
            case javax.lang.model.element.Modifier.SYNCHRONIZED -> Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD;
            case javax.lang.model.element.Modifier.NATIVE -> Modifier.ModifierKeyword.NATIVE_KEYWORD;
            case javax.lang.model.element.Modifier.STRICTFP -> Modifier.ModifierKeyword.STRICTFP_KEYWORD;
        };
    }

    private Modifier modifierToDom(javax.lang.model.element.Modifier javac) {
        return this.ast.newModifier(this.modifierToKeyword(javac));
    }

    private Modifier convert(javax.lang.model.element.Modifier javac, int startPos, int endPos) {
        int indOf;
        Modifier res = this.modifierToDom(javac);
        if (startPos >= 0 && endPos >= startPos && endPos <= this.rawText.length() && (indOf = this.rawText.indexOf(res.getKeyword().toString(), startPos, endPos)) != -1) {
            res.setSourceRange(indOf, res.getKeyword().toString().length());
        }
        return res;
    }

    private Name convertName(com.sun.tools.javac.util.Name javac) {
        if (javac == null || Objects.equals(javac, Names.instance((Context)this.context).error)) {
            SimpleName res = this.ast.newSimpleName(FAKE_IDENTIFIER);
            res.setFlags(8);
            return res;
        }
        if (Objects.equals(javac, Names.instance((Context)this.context).empty)) {
            return this.ast.newSimpleName("_");
        }
        String nameString = javac.toString();
        int lastDot = nameString.lastIndexOf(".");
        if (lastDot < 0) {
            try {
                return this.ast.newSimpleName(nameString);
            }
            catch (IllegalArgumentException ex) {
                SimpleName res = this.ast.newSimpleName(FAKE_IDENTIFIER);
                res.setFlags(8);
                return res;
            }
        }
        return this.ast.newQualifiedName(this.convertName(javac.subName(0, lastDot)), (SimpleName)this.convertName(javac.subName(lastDot + 1, javac.length() - 1)));
    }

    public Comment convert(Tokens.Comment javac, JCTree context) {
        DocCommentTree docCommentTree;
        Tokens.Comment.CommentStyle style = javac.getStyle();
        if ((style == Tokens.Comment.CommentStyle.JAVADOC_BLOCK || style == Tokens.Comment.CommentStyle.JAVADOC_LINE) && context != null && (docCommentTree = this.javacCompilationUnit.docComments.getCommentTree(context)) instanceof DCTree.DCDocComment) {
            DCTree.DCDocComment dcDocComment = (DCTree.DCDocComment)docCommentTree;
            JavadocConverter javadocConverter = new JavadocConverter(this, dcDocComment, TreePath.getPath(this.javacCompilationUnit, (Tree)context), this.buildJavadoc);
            String raw = javadocConverter.getRawContent();
            if (!"/**/".equals(raw)) {
                this.javadocConverters.add(javadocConverter);
                Javadoc javadoc = javadocConverter.convertJavadoc();
                if (this.ast.apiLevel() >= 23) {
                    javadoc.setMarkdown(javac.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE);
                }
                this.javadocDiagnostics.addAll(javadocConverter.getDiagnostics());
                return javadoc;
            }
            style = Tokens.Comment.CommentStyle.BLOCK;
        }
        LineComment jdt = switch (style) {
            default -> throw new MatchException(null, null);
            case Tokens.Comment.CommentStyle.LINE -> this.ast.newLineComment();
            case Tokens.Comment.CommentStyle.BLOCK -> this.ast.newBlockComment();
            case Tokens.Comment.CommentStyle.JAVADOC_BLOCK -> this.ast.newJavadoc();
            case Tokens.Comment.CommentStyle.JAVADOC_LINE -> this.ast.newJavadoc();
        };
        javac.isDeprecated();
        javac.getText();
        int startPos = javac.getPos().getStartPosition();
        int endPos = javac.getPos().getEndPosition(this.javacCompilationUnit.endPositions);
        jdt.setSourceRange(startPos, endPos - startPos);
        return jdt;
    }

    public Comment convert(Tokens.Comment javac, int pos, int endPos) {
        if (javac.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_BLOCK || javac.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE) {
            DocCommentParser parser = new DocCommentParser(ParserFactory.instance(this.context), Log.instance(this.context).currentSource(), javac);
            JavadocConverter javadocConverter = new JavadocConverter(this, parser.parse(), pos, endPos, this.buildJavadoc);
            this.javadocConverters.add(javadocConverter);
            Javadoc javadoc = javadocConverter.convertJavadoc();
            if (this.ast.apiLevel() >= 23) {
                javadoc.setMarkdown(javac.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE);
            }
            this.javadocDiagnostics.addAll(javadocConverter.getDiagnostics());
            return javadoc;
        }
        LineComment jdt = switch (javac.getStyle()) {
            default -> throw new MatchException(null, null);
            case Tokens.Comment.CommentStyle.LINE -> this.ast.newLineComment();
            case Tokens.Comment.CommentStyle.BLOCK -> this.ast.newBlockComment();
            case Tokens.Comment.CommentStyle.JAVADOC_BLOCK -> this.ast.newJavadoc();
            case Tokens.Comment.CommentStyle.JAVADOC_LINE -> this.ast.newLineComment();
        };
        javac.isDeprecated();
        javac.getText();
        jdt.setSourceRange(pos, endPos - pos);
        return jdt;
    }

    private EnumConstantDeclaration convertEnumConstantDeclaration(JCTree var, ASTNode parent, EnumDeclaration enumDecl) {
        EnumConstantDeclaration enumConstantDeclaration = null;
        String enumName = null;
        if (var instanceof JCTree.JCVariableDecl) {
            JCTree jCTree;
            JCTree.JCVariableDecl enumConstant = (JCTree.JCVariableDecl)var;
            if ((enumConstant.getModifiers().flags & 0x4000L) != 0L && (jCTree = enumConstant.getType()) instanceof JCTree.JCIdent) {
                JCTree.JCExpression jCExpression;
                String o2;
                JCTree.JCIdent jcid = (JCTree.JCIdent)jCTree;
                String o = jcid.getName().toString();
                if (o.equals(o2 = enumDecl.getName().toString())) {
                    enumConstantDeclaration = new EnumConstantDeclaration(this.ast);
                    this.commonSettings((ASTNode)enumConstantDeclaration, enumConstant);
                    SimpleName typeName = new SimpleName(this.ast);
                    enumName = enumConstant.getName().toString();
                    typeName.internalSetIdentifier(enumName);
                    typeName.setSourceRange(enumConstant.getStartPosition(), Math.max(0, enumName.length()));
                    enumConstantDeclaration.setName(typeName);
                    if (enumConstant.getModifiers() != null && enumConstant.getPreferredPosition() != -1) {
                        enumConstantDeclaration.modifiers().addAll(this.convert(enumConstant.getModifiers(), (ASTNode)enumConstantDeclaration));
                    }
                }
                if ((jCExpression = enumConstant.init) instanceof JCTree.JCNewClass) {
                    JCTree.JCNewClass jcnc = (JCTree.JCNewClass)jCExpression;
                    JCTree.JCClassDecl jCClassDecl = jcnc.def;
                    if (jCClassDecl instanceof JCTree.JCClassDecl) {
                        Object a;
                        JCTree.JCClassDecl jccd = jCClassDecl;
                        int blockStarts = jcnc.getStartPosition() + (enumName == null ? 0 : enumName.length());
                        if (jcnc.getArguments() != null && !((List)jcnc.getArguments()).isEmpty() && (a = ((List)jcnc.getArguments()).get(((List)jcnc.getArguments()).length() - 1)) instanceof JCTree) {
                            JCTree lastArg = (JCTree)a;
                            blockStarts = lastArg.getEndPosition(this.javacCompilationUnit.endPositions);
                        }
                        int endPos = jcnc.getEndPosition(this.javacCompilationUnit.endPositions);
                        AnonymousClassDeclaration e = this.createAnonymousClassDeclaration(jccd, (ASTNode)enumConstantDeclaration);
                        if (e != null) {
                            String tmp = this.rawText.substring(blockStarts);
                            int bracket = tmp.indexOf("{");
                            if (bracket != -1) {
                                blockStarts += bracket;
                            }
                            e.setSourceRange(blockStarts, endPos - blockStarts);
                            enumConstantDeclaration.setAnonymousClassDeclaration(e);
                        }
                    }
                    if (jcnc.getArguments() != null) {
                        Iterator it = ((List)jcnc.getArguments()).iterator();
                        while (it.hasNext()) {
                            Expression e = this.convertExpression((JCTree.JCExpression)it.next());
                            if (e == null) continue;
                            enumConstantDeclaration.arguments().add(e);
                        }
                    }
                }
            }
        }
        return enumConstantDeclaration;
    }

    private static java.util.List<ASTNode> siblingsOf(ASTNode node) {
        return JavacConverter.childrenOf(node.getParent());
    }

    public static Name toName(String val, int startPosition, AST ast) {
        try {
            String stripped = val.stripLeading();
            int strippedAmt = val.length() - stripped.length();
            int lastDot = stripped.lastIndexOf(".");
            if (lastDot == -1) {
                SimpleName sn = ast.newSimpleName(stripped);
                sn.setSourceRange(startPosition + strippedAmt, stripped.length());
                return sn;
            }
            SimpleName sn = ast.newSimpleName(stripped.substring(lastDot + 1));
            sn.setSourceRange(startPosition + strippedAmt + lastDot + 1, sn.getIdentifier().length());
            QualifiedName qn = ast.newQualifiedName(JavacConverter.toName(stripped.substring(0, lastDot), startPosition + strippedAmt, ast), sn);
            qn.setSourceRange(startPosition + strippedAmt, stripped.length());
            return qn;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private static java.util.List<ASTNode> childrenOf(ASTNode node) {
        return node.properties().values().stream().filter(ASTNode.class::isInstance).map(ASTNode.class::cast).filter(Predicate.not(arg_0 -> ((ASTNode)node).equals(arg_0))).toList();
    }

    public DocTreePath findDocTreePath(ASTNode node) {
        return this.javadocConverters.stream().map(javadocConverter -> javadocConverter.converted.get(node)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public DocTreePath[] searchRelatedDocTreePath(MethodRef ref) {
        ArrayList possibleNodes = new ArrayList();
        this.javadocConverters.forEach(x -> possibleNodes.addAll(x.converted.keySet()));
        DocTreePath[] r = (DocTreePath[])possibleNodes.stream().filter(x -> {
            MethodRef mr;
            return x != ref && x instanceof MethodRef && (mr = (MethodRef)x).getName().toString().equals(ref.getName().toString()) && Objects.equals(mr.getQualifier() == null ? null : mr.getQualifier().toString(), ref.getQualifier() == null ? null : ref.getQualifier().toString());
        }).map(x -> this.findDocTreePath((ASTNode)x)).toArray(DocTreePath[]::new);
        return r;
    }

    class FixPositions
    extends ASTVisitor {
        private final String contents;

        FixPositions(JavacConverter this$0) {
            super(true);
            String s = null;
            try {
                s = this$0.javacCompilationUnit.getSourceFile().getCharContent(true).toString();
            }
            catch (IOException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
            this.contents = s;
        }

        public boolean visit(QualifiedName node) {
            int foundOffset;
            if (node.getStartPosition() < 0 && (foundOffset = this.findPositionOfText(node.getFullyQualifiedName(), node.getParent(), JavacConverter.siblingsOf((ASTNode)node))) >= 0) {
                node.setSourceRange(foundOffset, node.getFullyQualifiedName().length());
            }
            return true;
        }

        public void endVisit(QualifiedName node) {
            if (node.getName().getStartPosition() >= 0 && node.getName().getStartPosition() + node.getName().getLength() - node.getQualifier().getStartPosition() >= 0) {
                node.setSourceRange(node.getQualifier().getStartPosition(), node.getName().getStartPosition() + node.getName().getLength() - node.getQualifier().getStartPosition());
            } else if (!JavacConverter.MISSING_IDENTIFIER.equals(node.getName().getIdentifier())) {
                node.setSourceRange(0, 0);
            }
        }

        public boolean visit(SimpleName name) {
            int foundOffset;
            if (name.getStartPosition() < 0 && !FAKE_IDENTIFIER.equals(name.getIdentifier()) && (foundOffset = this.findPositionOfText(name.getIdentifier(), name.getParent(), JavacConverter.siblingsOf((ASTNode)name))) >= 0) {
                name.setSourceRange(foundOffset, name.getIdentifier().length());
            }
            return false;
        }

        public boolean visit(Modifier modifier) {
            int parentStart = modifier.getParent().getStartPosition();
            int relativeStart = this.contents.substring(parentStart, parentStart + modifier.getParent().getLength()).indexOf(modifier.getKeyword().toString());
            if (relativeStart >= 0 && relativeStart < modifier.getParent().getLength()) {
                modifier.setSourceRange(parentStart + relativeStart, modifier.getKeyword().toString().length());
            }
            return true;
        }

        public void endVisit(TagElement tagElement) {
            Javadoc javadoc;
            ASTNode aSTNode;
            if (tagElement.getStartPosition() < 0) {
                OptionalInt start = tagElement.fragments().stream().filter(node -> node.getStartPosition() >= 0 && node.getLength() >= 0).mapToInt(ASTNode::getStartPosition).min();
                OptionalInt end = tagElement.fragments().stream().filter(node -> node.getStartPosition() >= 0 && node.getLength() >= 0).mapToInt(node -> node.getStartPosition() + node.getLength()).max();
                if (start.isPresent() && end.isPresent()) {
                    if (JavadocConverter.isInline(tagElement)) {
                        tagElement.setSourceRange(start.getAsInt() - 1, end.getAsInt() - start.getAsInt() + 2);
                    } else {
                        tagElement.setSourceRange(start.getAsInt(), end.getAsInt() - start.getAsInt());
                    }
                }
            }
            if ("@deprecated".equals(tagElement.getTagName()) && (aSTNode = tagElement.getParent()) instanceof Javadoc && (javadoc = (Javadoc)aSTNode).getParent() != null) {
                javadoc.getParent().setFlags(javadoc.getParent().getFlags() | 0x100000);
            }
        }

        private int findPositionOfText(String text, ASTNode in, java.util.List<ASTNode> excluding) {
            int current = in.getStartPosition();
            PriorityQueue<ASTNode> excluded = new PriorityQueue<ASTNode>(Comparator.comparing(ASTNode::getStartPosition));
            if (current == -1) {
                return -1;
            }
            if (excluded.isEmpty()) {
                int position = this.contents.indexOf(text, current, current + in.getLength());
                if (position >= 0) {
                    return position;
                }
            } else {
                ASTNode currentExclusion = null;
                while ((currentExclusion = excluded.poll()) != null) {
                    if (currentExclusion.getStartPosition() < current) continue;
                    int rangeEnd = currentExclusion.getStartPosition();
                    int position = this.contents.indexOf(text, current, rangeEnd);
                    if (position >= 0) {
                        return position;
                    }
                    current = rangeEnd + currentExclusion.getLength();
                }
            }
            return -1;
        }
    }
}

