/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle;

import com.github.badsyntax.gradle.BuildServerThread;
import com.github.badsyntax.gradle.TaskService;
import com.github.badsyntax.gradle.utils.Utils;
import com.google.common.base.Strings;
import com.microsoft.gradle.GradleLanguageServer;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleServer {
    private static final Logger logger = LoggerFactory.getLogger((String)GradleServer.class.getName());
    private final int port;
    private final Server taskServer;

    public GradleServer(int port) {
        this((ServerBuilder<?>)NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress("127.0.0.1", port)), port);
    }

    public GradleServer(ServerBuilder<?> serverBuilder, int port) {
        this.port = port;
        this.taskServer = serverBuilder.addService((BindableService)new TaskService()).build();
    }

    public void start() throws IOException {
        this.taskServer.start();
        logger.info("Gradle Server started, listening on {}", (Object)this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("Shutting down gRPC server since JVM is shutting down");
                try {
                    GradleServer.this.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                    Thread.currentThread().interrupt();
                }
                logger.info("Server shut down");
            }
        });
    }

    public void stop() throws InterruptedException {
        if (this.taskServer != null) {
            this.taskServer.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.taskServer != null) {
            this.taskServer.awaitTermination();
        }
    }

    public static void main(String[] args) throws Exception {
        boolean startBuildServer;
        Map<String, String> params = Utils.parseArgs(args);
        int taskServerPort = Integer.parseInt(Utils.validateRequiredParam(params, "port"));
        GradleServer.startTaskServerThread(taskServerPort);
        String languageServerPipePath = params.get("languageServerPipePath");
        if (!Strings.isNullOrEmpty((String)languageServerPipePath)) {
            GradleServer.startLanguageServerThread(languageServerPipePath);
        }
        if (startBuildServer = Boolean.parseBoolean(Utils.validateRequiredParam(params, "startBuildServer"))) {
            String buildServerPipeName = Utils.validateRequiredParam(params, "pipeName");
            String bundleDirectory = Utils.validateRequiredParam(params, "bundleDir");
            GradleServer.startBuildServerThread(buildServerPipeName, bundleDirectory);
        }
    }

    private static void startTaskServerThread(int port) {
        GradleServer server = new GradleServer(port);
        Thread serverThread = new Thread(() -> {
            try {
                server.start();
                server.blockUntilShutdown();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        serverThread.start();
    }

    private static void startBuildServerThread(String pipeName, String directory) {
        BuildServerThread buildServerConnectionThread = new BuildServerThread(pipeName, directory);
        Thread buildServerThread = new Thread(buildServerConnectionThread);
        buildServerThread.start();
    }

    private static void startLanguageServerThread(String languageServerPipePath) {
        Thread languageServerThread = new Thread(() -> GradleLanguageServer.main((String[])new String[]{languageServerPipePath}));
        languageServerThread.start();
    }
}

