/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;

public class DOMCompletionUtil {
    private static final List<String> JAVA_MODIFIERS = List.of(Modifier.ModifierKeyword.PUBLIC_KEYWORD.toString(), Modifier.ModifierKeyword.PRIVATE_KEYWORD.toString(), Modifier.ModifierKeyword.STATIC_KEYWORD.toString(), Modifier.ModifierKeyword.PROTECTED_KEYWORD.toString(), Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD.toString(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD.toString(), Modifier.ModifierKeyword.FINAL_KEYWORD.toString(), Modifier.ModifierKeyword.DEFAULT_KEYWORD.toString(), Modifier.ModifierKeyword.NATIVE_KEYWORD.toString(), Modifier.ModifierKeyword.STRICTFP_KEYWORD.toString(), Modifier.ModifierKeyword.TRANSIENT_KEYWORD.toString(), Modifier.ModifierKeyword.VOLATILE_KEYWORD.toString());

    public static ASTNode findParent(ASTNode nodeToSearch, int[] kindsToFind) {
        for (ASTNode cursor = nodeToSearch; cursor != null; cursor = cursor.getParent()) {
            for (int kindToFind : kindsToFind) {
                if (cursor.getNodeType() != kindToFind) continue;
                return cursor;
            }
        }
        return null;
    }

    public static <T extends ASTNode> void visitChildren(ASTNode root, final int kind, final Consumer<T> consumer) {
        ASTVisitor visitor = new ASTVisitor(){

            public void preVisit(ASTNode node) {
                if (node.getNodeType() == kind) {
                    consumer.accept(node);
                }
            }
        };
        root.accept(visitor);
    }

    public static AbstractTypeDeclaration findParentTypeDeclaration(ASTNode nodeToSearch) {
        return (AbstractTypeDeclaration)DOMCompletionUtil.findParent(nodeToSearch, new int[]{55, 71, 103, 81});
    }

    public static boolean isJavaFieldOrMethodModifier(String potentialModifer) {
        return JAVA_MODIFIERS.contains(potentialModifer);
    }

    public static boolean findInSupers(ITypeBinding root, ITypeBinding toFind) {
        ITypeBinding superFind = toFind.getErasure();
        if (superFind != null) {
            String keyToFind = superFind.getKey();
            return DOMCompletionUtil.findInSupers(root, keyToFind);
        }
        return false;
    }

    public static boolean findInSupers(ITypeBinding root, String keyOfTypeToFind) {
        String keyToFind = keyOfTypeToFind;
        LinkedList<ITypeBinding> toCheck = new LinkedList<ITypeBinding>();
        HashSet<String> alreadyChecked = new HashSet<String>();
        toCheck.add(root.getErasure());
        while (!toCheck.isEmpty()) {
            ITypeBinding current = (ITypeBinding)toCheck.poll();
            String currentKey = current.getErasure().getKey();
            if (alreadyChecked.contains(currentKey)) continue;
            alreadyChecked.add(currentKey);
            if (currentKey.equals(keyToFind)) {
                return true;
            }
            for (ITypeBinding superInterface : current.getInterfaces()) {
                toCheck.add(superInterface);
            }
            if (current.getSuperclass() == null) continue;
            toCheck.add(current.getSuperclass());
        }
        return false;
    }

    public static boolean findInSupers(IType root, String keyOfTypeToFind) {
        if (root.getKey().equals(keyOfTypeToFind)) {
            return true;
        }
        try {
            ITypeHierarchy hierarchy = root.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            for (IType superType : hierarchy.getAllSupertypes(root)) {
                if (!superType.getKey().equals(keyOfTypeToFind)) continue;
                return true;
            }
            return false;
        }
        catch (JavaModelException e) {
            return false;
        }
    }
}

